/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.messages;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.android.tools.idea.logcat.messages.DocumentAppenderKt;
import com.android.tools.idea.logcat.messages.TextAccumulator;
import com.android.tools.idea.logcat.util.LogcatLoggerKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArrayDeque;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0007J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0016\u001a\u00020\u0007J\b\u0010\u0017\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r8\u0000X\u0081\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/logcat/messages/DocumentAppender;", "", "project", "Lcom/intellij/openapi/project/Project;", "document", "Lcom/intellij/openapi/editor/ex/DocumentEx;", "maxDocumentSize", "", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/DocumentEx;I)V", "markupModel", "Lcom/intellij/openapi/editor/markup/MarkupModel;", "kotlin.jvm.PlatformType", "ranges", "Lkotlin/collections/ArrayDeque;", "Lcom/intellij/openapi/editor/RangeMarker;", "getRanges$intellij_android_logcat", "()Lkotlin/collections/ArrayDeque;", "appendToDocument", "", "buffer", "Lcom/android/tools/idea/logcat/messages/TextAccumulator;", "setMaxDocumentSize", "size", "trimToSize", "intellij.android.logcat"})
public final class DocumentAppender {
    @NotNull
    private final DocumentEx document;
    private int maxDocumentSize;
    private final MarkupModel markupModel;
    @VisibleForTesting
    @NotNull
    private final ArrayDeque<RangeMarker> ranges;

    public DocumentAppender(@NotNull Project project, @NotNull DocumentEx document2, int maxDocumentSize) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)document2, (String)"document");
        this.document = document2;
        this.maxDocumentSize = maxDocumentSize;
        this.markupModel = DocumentMarkupModel.forDocument((Document)((Document)this.document), (Project)project, (boolean)true);
        this.ranges = new ArrayDeque();
    }

    @NotNull
    public final ArrayDeque<RangeMarker> getRanges$intellij_android_logcat() {
        return this.ranges;
    }

    @UiThread
    public final void appendToDocument(@NotNull TextAccumulator buffer) {
        Logger logger2;
        Intrinsics.checkNotNullParameter((Object)buffer, (String)"buffer");
        Logger $this$debug$iv = LogcatLoggerKt.getLOGGER();
        Exception e$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug$iv.isDebugEnabled()) {
            logger2 = $this$debug$iv;
            boolean bl = false;
            logger2.debug("Appending " + buffer.getText().length() + " bytes to document", (Throwable)e$iv);
        }
        String text2 = buffer.getText();
        if (text2.length() >= this.maxDocumentSize) {
            this.document.setText((CharSequence)"");
            int n = this.document.getTextLength();
            String string = text2.substring(StringsKt.lastIndexOf$default((CharSequence)text2, (char)'\n', (int)(text2.length() - this.maxDocumentSize), (boolean)false, (int)4, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            this.document.insertString(n, (CharSequence)string);
        } else {
            this.document.insertString(this.document.getTextLength(), (CharSequence)text2);
            this.trimToSize();
        }
        Logger $this$debug$iv2 = LogcatLoggerKt.getLOGGER();
        Exception e$iv2 = null;
        boolean bl = false;
        if ($this$debug$iv2.isDebugEnabled()) {
            logger2 = $this$debug$iv2;
            boolean bl2 = false;
            logger2.debug("Document text.length: " + this.document.getText().length() + " immutableCharSequence.length: " + this.document.getImmutableCharSequence().length(), (Throwable)e$iv2);
        }
        int offset = this.document.getTextLength() - text2.length();
        for (TextAccumulator.Range<TextAttributes> range : buffer.getTextAttributesRanges()) {
            DocumentAppenderKt.access$applyRange(range, offset, (Function3)new Function3<Integer, Integer, TextAttributes, Unit>(this){
                final /* synthetic */ DocumentAppender this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                public final void invoke(int start2, int end, @NotNull TextAttributes textAttributes) {
                    Intrinsics.checkNotNullParameter((Object)textAttributes, (String)"textAttributes");
                    DocumentAppender.access$getMarkupModel$p(this.this$0).addRangeHighlighter(start2, end, 1000, textAttributes, HighlighterTargetArea.EXACT_RANGE);
                }
            });
        }
        for (TextAccumulator.Range<TextAttributes> range : buffer.getTextAttributesKeyRanges()) {
            DocumentAppenderKt.access$applyRange(range, offset, (Function3)new Function3<Integer, Integer, TextAttributesKey, Unit>(this){
                final /* synthetic */ DocumentAppender this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                public final void invoke(int start2, int end, @NotNull TextAttributesKey textAttributesKey) {
                    Intrinsics.checkNotNullParameter((Object)textAttributesKey, (String)"textAttributesKey");
                    DocumentAppender.access$getMarkupModel$p(this.this$0).addRangeHighlighter(textAttributesKey, start2, end, 1000, HighlighterTargetArea.EXACT_RANGE);
                }
            });
        }
        for (TextAccumulator.Range<Object> range : buffer.getFilterHintRanges()) {
            DocumentAppenderKt.access$applyRange(range, offset, (Function3)new Function3<Integer, Integer, TextAccumulator.FilterHint, Unit>(this){
                final /* synthetic */ DocumentAppender this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(int start2, int end, @NotNull TextAccumulator.FilterHint hint) {
                    void $this$invoke_u24lambda_u2d0;
                    RangeMarker rangeMarker;
                    Intrinsics.checkNotNullParameter((Object)hint, (String)"hint");
                    RangeMarker rangeMarker2 = rangeMarker = DocumentAppender.access$getDocument$p(this.this$0).createRangeMarker(start2, end);
                    ArrayDeque<RangeMarker> arrayDeque = this.this$0.getRanges$intellij_android_logcat();
                    boolean bl = false;
                    $this$invoke_u24lambda_u2d0.putUserData(DocumentAppenderKt.getLOGCAT_FILTER_HINT_KEY(), (Object)hint);
                    RangeMarker rangeMarker3 = rangeMarker;
                    Intrinsics.checkNotNullExpressionValue((Object)rangeMarker3, (String)"document.createRangeMark\u2026HINT_KEY, hint)\n        }");
                    arrayDeque.add((Object)rangeMarker3);
                }
            });
        }
        for (TextAccumulator.Range<Object> range : buffer.getMessageRanges()) {
            DocumentAppenderKt.access$applyRange(range, offset, (Function3)new Function3<Integer, Integer, LogcatMessage, Unit>(this){
                final /* synthetic */ DocumentAppender this$0;
                {
                    this.this$0 = $receiver;
                    super(3);
                }

                /*
                 * WARNING - void declaration
                 */
                public final void invoke(int start2, int end, @NotNull LogcatMessage message2) {
                    void $this$invoke_u24lambda_u2d0;
                    RangeMarker rangeMarker;
                    Intrinsics.checkNotNullParameter((Object)message2, (String)"message");
                    RangeMarker rangeMarker2 = rangeMarker = DocumentAppender.access$getDocument$p(this.this$0).createRangeMarker(start2, end);
                    ArrayDeque<RangeMarker> arrayDeque = this.this$0.getRanges$intellij_android_logcat();
                    boolean bl = false;
                    $this$invoke_u24lambda_u2d0.putUserData(DocumentAppenderKt.getLOGCAT_MESSAGE_KEY(), (Object)message2);
                    RangeMarker rangeMarker3 = rangeMarker;
                    Intrinsics.checkNotNullExpressionValue((Object)rangeMarker3, (String)"document.createRangeMark\u2026E_KEY, message)\n        }");
                    arrayDeque.add((Object)rangeMarker3);
                }
            });
        }
        while (!this.ranges.isEmpty() && !DocumentAppenderKt.access$isReallyValid((RangeMarker)this.ranges.first())) {
            this.ranges.removeFirst();
        }
    }

    public final void setMaxDocumentSize(int size) {
        this.maxDocumentSize = size;
        this.trimToSize();
    }

    private final void trimToSize() {
        if (this.document.getTextLength() > this.maxDocumentSize) {
            int offset = this.document.getTextLength() - this.maxDocumentSize;
            CharSequence charSequence = this.document.getImmutableCharSequence();
            Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"document.immutableCharSequence");
            this.document.deleteString(0, StringsKt.lastIndexOf$default((CharSequence)charSequence, (char)'\n', (int)offset, (boolean)false, (int)4, null) + 1);
        }
    }

    public static final /* synthetic */ MarkupModel access$getMarkupModel$p(DocumentAppender $this) {
        return $this.markupModel;
    }

    public static final /* synthetic */ DocumentEx access$getDocument$p(DocumentAppender $this) {
        return $this.document;
    }
}

