/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.message;

import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.MatchGroup;
import kotlin.text.MatchGroupCollection;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.jdk8.RegexExtensionsJDK8Kt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u001a\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\u0010\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0002\u001a\f\u0010\u0011\u001a\u00020\u0012*\u00020\u0013H\u0002\u001a\u001c\u0010\u0014\u001a\u00020\u0012*\u00020\u00132\u0006\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0005\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\b\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\t\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"DATE", "Lkotlin/text/Regex;", "EPOCH", "HEADER_EPOCH_REGEX", "HEADER_STANDARD_REGEX", "PID", "PRIORITY", "TAG", "TID", "TIME", "parseEpochSeconds", "", "string", "", "parsePid", "", "parseThreadId", "getEpochTimestamp", "Ljava/time/Instant;", "Lkotlin/text/MatchResult;", "getStandardTimestamp", "defaultYear", "defaultZoneId", "Ljava/time/ZoneId;", "intellij.android.logcat"})
public final class LogcatHeaderParserKt {
    @NotNull
    private static final Regex EPOCH = new Regex("(?<epochSec>\\d+)\\.(?<epochMilli>\\d\\d\\d)");
    @NotNull
    private static final Regex DATE = new Regex("(?<month>\\d\\d)-(?<day>\\d\\d)");
    @NotNull
    private static final Regex TIME = new Regex("(?<hour>\\d\\d):(?<min>\\d\\d):(?<sec>\\d\\d)\\.(?<milli>\\d\\d\\d)");
    @NotNull
    private static final Regex PID = new Regex("(?<pid>\\d+)");
    @NotNull
    private static final Regex TID = new Regex("(?<tid>\\w+)");
    @NotNull
    private static final Regex PRIORITY = new Regex("(?<priority>[VDIWEAF])");
    @NotNull
    private static final Regex TAG = new Regex("(?<tag>.*?)");
    @NotNull
    private static final Regex HEADER_EPOCH_REGEX = new Regex("^\\[ +" + EPOCH + " +" + PID + ": *" + TID + " +" + PRIORITY + "/" + TAG + " +]$");
    @NotNull
    private static final Regex HEADER_STANDARD_REGEX = new Regex("^\\[ +" + DATE + " +" + TIME + " +" + PID + ": *" + TID + " +" + PRIORITY + "/" + TAG + " +]$");

    private static final Instant getEpochTimestamp(MatchResult $this$getEpochTimestamp) {
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$getEpochTimestamp.getGroups(), (String)"epochSec");
        Intrinsics.checkNotNull((Object)matchGroup);
        long l = LogcatHeaderParserKt.parseEpochSeconds(matchGroup.getValue());
        MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$getEpochTimestamp.getGroups(), (String)"epochMilli");
        String string = matchGroup2 != null ? matchGroup2.getValue() : null;
        Intrinsics.checkNotNull((Object)string);
        Instant instant = Instant.ofEpochSecond(l, TimeUnit.MILLISECONDS.toNanos(Long.parseLong(string)));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"ofEpochSecond(\n    parse\u2026lli\"]?.value!!.toLong()))");
        return instant;
    }

    private static final Instant getStandardTimestamp(MatchResult $this$getStandardTimestamp, int defaultYear, ZoneId defaultZoneId) {
        MatchGroup matchGroup = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$getStandardTimestamp.getGroups(), (String)"month");
        Intrinsics.checkNotNull((Object)matchGroup);
        int n = Integer.parseInt(matchGroup.getValue());
        MatchGroup matchGroup2 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$getStandardTimestamp.getGroups(), (String)"day");
        Intrinsics.checkNotNull((Object)matchGroup2);
        int n2 = Integer.parseInt(matchGroup2.getValue());
        MatchGroup matchGroup3 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$getStandardTimestamp.getGroups(), (String)"hour");
        Intrinsics.checkNotNull((Object)matchGroup3);
        int n3 = Integer.parseInt(matchGroup3.getValue());
        MatchGroup matchGroup4 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$getStandardTimestamp.getGroups(), (String)"min");
        Intrinsics.checkNotNull((Object)matchGroup4);
        int n4 = Integer.parseInt(matchGroup4.getValue());
        MatchGroup matchGroup5 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$getStandardTimestamp.getGroups(), (String)"sec");
        Intrinsics.checkNotNull((Object)matchGroup5);
        int n5 = Integer.parseInt(matchGroup5.getValue());
        MatchGroup matchGroup6 = RegexExtensionsJDK8Kt.get((MatchGroupCollection)$this$getStandardTimestamp.getGroups(), (String)"milli");
        Intrinsics.checkNotNull((Object)matchGroup6);
        Instant instant = Instant.from(ZonedDateTime.of(defaultYear, n, n2, n3, n4, n5, (int)TimeUnit.MILLISECONDS.toNanos(Long.parseLong(matchGroup6.getValue())), defaultZoneId));
        Intrinsics.checkNotNullExpressionValue((Object)instant, (String)"from(\n    ZonedDateTime.\u2026  defaultZoneId\n    )\n  )");
        return instant;
    }

    private static final long parseEpochSeconds(String string) {
        long l;
        try {
            l = Long.parseLong(string);
        }
        catch (NumberFormatException exception) {
            l = 0L;
        }
        return l;
    }

    private static final int parsePid(String string) {
        int n;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException exception) {
            n = -1;
        }
        return n;
    }

    private static final int parseThreadId(String string) {
        int n;
        try {
            Integer n2 = Integer.decode(string);
            Intrinsics.checkNotNullExpressionValue((Object)n2, (String)"{\n    Integer.decode(string)\n  }");
            n = ((Number)n2).intValue();
        }
        catch (NumberFormatException exception) {
            n = -1;
        }
        return n;
    }

    public static final /* synthetic */ Regex access$getHEADER_EPOCH_REGEX$p() {
        return HEADER_EPOCH_REGEX;
    }

    public static final /* synthetic */ Regex access$getHEADER_STANDARD_REGEX$p() {
        return HEADER_STANDARD_REGEX;
    }

    public static final /* synthetic */ Instant access$getEpochTimestamp(MatchResult $receiver) {
        return LogcatHeaderParserKt.getEpochTimestamp($receiver);
    }

    public static final /* synthetic */ Instant access$getStandardTimestamp(MatchResult $receiver, int defaultYear, ZoneId defaultZoneId) {
        return LogcatHeaderParserKt.getStandardTimestamp($receiver, defaultYear, defaultZoneId);
    }

    public static final /* synthetic */ int access$parsePid(String string) {
        return LogcatHeaderParserKt.parsePid(string);
    }

    public static final /* synthetic */ int access$parseThreadId(String string) {
        return LogcatHeaderParserKt.parseThreadId(string);
    }
}

