/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.folding;

import com.android.tools.idea.logcat.folding.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\u001a\u0017\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\n\u001a\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a&\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\bH\u0002\u001a\u001e\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\u0005H\u0002\u001a\u001e\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00050\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\u0005H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"CAUSED_BY_LINE_PATTERN", "Lkotlin/text/Regex;", "ELIDED_LINE_PATTERN", "EXCEPTION_LINE_PATTERN", "EXPANDED_STACK_TRACE_MARKER", "", "SHOULD_BE_FOLDED", "getElidedFrameCount", "", "line", "(Ljava/lang/String;)Ljava/lang/Integer;", "handleCausedByLine", "", "context", "Lcom/android/tools/idea/logcat/folding/Context;", "handleElidedLine", "elidedCount", "handleElidedOrEndOfTrace", "handleFrameLine", "isCauseLine", "", "isFrameLine", "process", "intellij.android.logcat"})
public final class StackTraceExpanderKt {
    @NotNull
    private static final Regex EXCEPTION_LINE_PATTERN = new Regex("^\\s*at .+\\(.+\\)$");
    @NotNull
    private static final Regex ELIDED_LINE_PATTERN = new Regex("^\\s*... (\\d+) more$");
    @NotNull
    private static final Regex CAUSED_BY_LINE_PATTERN = new Regex("^\\s*Caused by:.+$");
    @NotNull
    private static final String EXPANDED_STACK_TRACE_MARKER = "\u00a0";
    @NotNull
    private static final Regex SHOULD_BE_FOLDED = new Regex("^\\s+at .+\u00a0$");

    private static final List<String> process(Context context2, String line2) {
        return StackTraceExpanderKt.isFrameLine(line2) ? StackTraceExpanderKt.handleFrameLine(context2, line2) : (!context2.isInTrace() ? CollectionsKt.listOf((Object)line2) : (StackTraceExpanderKt.isCauseLine(line2) ? StackTraceExpanderKt.handleCausedByLine(context2, line2) : StackTraceExpanderKt.handleElidedOrEndOfTrace(context2, line2)));
    }

    private static final List<String> handleFrameLine(Context context2, String line2) {
        context2.setInTrace(true);
        context2.getCurrentStack().add(line2);
        return CollectionsKt.listOf((Object)line2);
    }

    private static final List<String> handleCausedByLine(Context context2, String line2) {
        boolean bl = context2.isInTrace();
        if (_Assertions.ENABLED && !bl) {
            boolean bl2 = false;
            String string = "Unexpected line while parsing stack trace: %s";
            Object[] objectArray = new Object[]{line2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String string3 = string2;
            throw new AssertionError((Object)string3);
        }
        context2.swapStacks();
        return CollectionsKt.listOf((Object)line2);
    }

    private static final List<String> handleElidedOrEndOfTrace(Context context2, String line2) {
        List<String> list2;
        Integer count2 = StackTraceExpanderKt.getElidedFrameCount(line2);
        if (count2 != null) {
            list2 = StackTraceExpanderKt.handleElidedLine(context2, line2, count2);
        } else {
            context2.reset();
            list2 = CollectionsKt.listOf((Object)line2);
        }
        return list2;
    }

    private static final List<String> handleElidedLine(Context context2, String line2, int elidedCount) {
        boolean bl = context2.isInTrace();
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-StackTraceExpanderKt$handleElidedLine$22 = false;
            String string = "Unexpected line while parsing stack trace: %s";
            Object[] objectArray = new Object[]{line2};
            String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(format, *args)");
            String $i$a$-assert-StackTraceExpanderKt$handleElidedLine$22 = string2;
            throw new AssertionError((Object)$i$a$-assert-StackTraceExpanderKt$handleElidedLine$22);
        }
        boolean bl2 = bl = elidedCount > 0;
        if (_Assertions.ENABLED && !bl) {
            String $i$a$-assert-StackTraceExpanderKt$handleElidedLine$22 = "Assertion failed";
            throw new AssertionError((Object)$i$a$-assert-StackTraceExpanderKt$handleElidedLine$22);
        }
        List lines2 = new ArrayList();
        List<String> previousStack = context2.getPreviousStack();
        int startIndex = previousStack.size() - elidedCount;
        if (startIndex >= 0) {
            for (int i = 0; i < elidedCount; ++i) {
                String frame = previousStack.get(startIndex + i);
                lines2.add(frame + EXPANDED_STACK_TRACE_MARKER);
                context2.getCurrentStack().add(frame);
            }
        } else {
            lines2.add(line2);
        }
        return lines2;
    }

    private static final boolean isFrameLine(String line2) {
        CharSequence charSequence = line2;
        return EXCEPTION_LINE_PATTERN.matches(charSequence);
    }

    private static final boolean isCauseLine(String line2) {
        CharSequence charSequence = line2;
        return CAUSED_BY_LINE_PATTERN.matches(charSequence);
    }

    private static final Integer getElidedFrameCount(String line2) {
        Object object = ELIDED_LINE_PATTERN.matchEntire((CharSequence)line2);
        return object != null && (object = object.getGroupValues()) != null && (object = (String)object.get(1)) != null ? StringsKt.toIntOrNull((String)object) : null;
    }

    public static final /* synthetic */ Regex access$getSHOULD_BE_FOLDED$p() {
        return SHOULD_BE_FOLDED;
    }

    public static final /* synthetic */ List access$process(Context context2, String line2) {
        return StackTraceExpanderKt.process(context2, line2);
    }
}

