/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.folding;

import com.android.annotations.concurrency.UiThread;
import com.android.tools.idea.logcat.folding.EditorFoldingDetectorKt;
import com.android.tools.idea.logcat.folding.ExceptionFolding;
import com.android.tools.idea.logcat.folding.FoldingDetector;
import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.impl.EditorHyperlinkSupport;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.project.Project;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.IntIterator;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\b\u0000\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u000e\b\u0002\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\u0002\u0010\tJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0002J\u0018\u0010\u0014\u001a\u00020\u000f2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0012H\u0017J\u0015\u0010\u0015\u001a\u00070\u0016\u00a2\u0006\u0002\b\r2\u0006\u0010\u0017\u001a\u00020\u0012H\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0010\u001a\u00020\b2\u0006\u0010\u0017\u001a\u00020\u0012H\u0002R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/logcat/folding/EditorFoldingDetector;", "Lcom/android/tools/idea/logcat/folding/FoldingDetector;", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "consoleFoldings", "", "Lcom/intellij/execution/ConsoleFolding;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/Editor;Ljava/util/List;)V", "activeConsoleFoldings", "document", "Lcom/intellij/openapi/editor/Document;", "Lorg/jetbrains/annotations/NotNull;", "addFoldRegion", "", "folding", "startLine", "", "endLine", "detectFoldings", "getLineText", "", "line", "shouldFoldLine", "", "intellij.android.logcat"})
public final class EditorFoldingDetector
implements FoldingDetector {
    @NotNull
    private final Project project;
    @NotNull
    private final Editor editor;
    @NotNull
    private final Document document;
    @NotNull
    private final List<ConsoleFolding> activeConsoleFoldings;

    /*
     * WARNING - void declaration
     */
    public EditorFoldingDetector(@NotNull Project project, @NotNull Editor editor, @NotNull List<? extends ConsoleFolding> consoleFoldings) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        Intrinsics.checkNotNullParameter(consoleFoldings, (String)"consoleFoldings");
        this.project = project;
        this.editor = editor;
        Document document2 = this.editor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
        this.document = document2;
        Iterable iterable = consoleFoldings;
        EditorFoldingDetector editorFoldingDetector = this;
        boolean $i$f$filter = false;
        void var6_7 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ConsoleFolding it = (ConsoleFolding)element$iv$iv;
            boolean bl = false;
            if (!it.isEnabledForConsole((ConsoleView)EditorFoldingDetectorKt.access$getConsoleView$p())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        editorFoldingDetector.activeConsoleFoldings = (List)destination$iv$iv;
    }

    public /* synthetic */ EditorFoldingDetector(Project project, Editor editor, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            List list3 = ConsoleFolding.EP_NAME.getExtensionList();
            Intrinsics.checkNotNullExpressionValue((Object)list3, (String)"EP_NAME.extensionList");
            list2 = CollectionsKt.plus((Collection)list3, (Object)((Object)new ExceptionFolding()));
        }
        this(project, editor, list2);
    }

    @Override
    @UiThread
    public void detectFoldings(int startLine, int endLine) {
        if (this.activeConsoleFoldings.isEmpty()) {
            return;
        }
        this.editor.getFoldingModel().runBatchFoldingOperation(new Runnable(this, startLine, endLine){
            final /* synthetic */ EditorFoldingDetector this$0;
            final /* synthetic */ int $startLine;
            final /* synthetic */ int $endLine;
            {
                this.this$0 = $receiver;
                this.$startLine = $startLine;
                this.$endLine = $endLine;
            }

            public final void run() {
                for (ConsoleFolding folding : EditorFoldingDetector.access$getActiveConsoleFoldings$p(this.this$0)) {
                    int line2 = this.$startLine;
                    while (line2 <= this.$endLine) {
                        if (!EditorFoldingDetector.access$shouldFoldLine(this.this$0, folding, line2)) {
                            ++line2;
                            continue;
                        }
                        int foldStartLine = line2++;
                        while (line2 <= this.$endLine && EditorFoldingDetector.access$shouldFoldLine(this.this$0, folding, line2)) {
                            ++line2;
                        }
                        EditorFoldingDetector.access$addFoldRegion(this.this$0, folding, foldStartLine, line2 - 1);
                    }
                }
            }
        });
    }

    private final boolean shouldFoldLine(ConsoleFolding folding, int line2) {
        return folding.shouldFoldLine(this.project, this.getLineText(line2));
    }

    /*
     * WARNING - void declaration
     */
    private final void addFoldRegion(ConsoleFolding folding, int startLine, int endLine) {
        block2: {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = (Iterable)new IntRange(startLine, endLine);
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            Iterator iterator2 = $this$mapTo$iv$iv.iterator();
            while (iterator2.hasNext()) {
                void p0;
                int item$iv$iv;
                int n = item$iv$iv = ((IntIterator)iterator2).nextInt();
                Collection collection2 = destination$iv$iv;
                boolean bl = false;
                collection2.add(this.getLineText((int)p0));
            }
            List lines2 = (List)destination$iv$iv;
            int it = this.document.getLineStartOffset(startLine);
            boolean bl = false;
            int startOffset = folding.shouldBeAttachedToThePreviousLine() && it > 0 ? it - 1 : it;
            int endOffset = this.document.getLineEndOffset(endLine);
            String string = folding.getPlaceholderText(this.project, lines2);
            if (string == null) {
                return;
            }
            String placeholder = string;
            FoldRegion foldRegion = this.editor.getFoldingModel().addFoldRegion(startOffset, endOffset, placeholder);
            if (foldRegion == null) break block2;
            FoldRegion it2 = foldRegion;
            boolean bl2 = false;
            it2.setExpanded(false);
        }
    }

    private final String getLineText(int line2) {
        String string = EditorHyperlinkSupport.getLineText((Document)this.document, (int)line2, (boolean)false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getLineText(document, li\u2026, /* includeEol */ false)");
        return string;
    }

    public static final /* synthetic */ List access$getActiveConsoleFoldings$p(EditorFoldingDetector $this) {
        return $this.activeConsoleFoldings;
    }

    public static final /* synthetic */ boolean access$shouldFoldLine(EditorFoldingDetector $this, ConsoleFolding folding, int line2) {
        return $this.shouldFoldLine(folding, line2);
    }

    public static final /* synthetic */ void access$addFoldRegion(EditorFoldingDetector $this, ConsoleFolding folding, int startLine, int endLine) {
        $this.addFoldRegion(folding, startLine, endLine);
    }
}

