/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.filters;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.PackageNamesProvider;
import com.android.tools.idea.logcat.filters.AgeFilter;
import com.android.tools.idea.logcat.filters.CrashFilter;
import com.android.tools.idea.logcat.filters.ExactStringFilter;
import com.android.tools.idea.logcat.filters.FilterType;
import com.android.tools.idea.logcat.filters.LevelFilter;
import com.android.tools.idea.logcat.filters.LogcatFilter;
import com.android.tools.idea.logcat.filters.LogcatFilterField;
import com.android.tools.idea.logcat.filters.LogcatFilterParseException;
import com.android.tools.idea.logcat.filters.NameFilter;
import com.android.tools.idea.logcat.filters.NegatedExactStringFilter;
import com.android.tools.idea.logcat.filters.NegatedRegexFilter;
import com.android.tools.idea.logcat.filters.NegatedStringFilter;
import com.android.tools.idea.logcat.filters.ProjectAppFilter;
import com.android.tools.idea.logcat.filters.RegexFilter;
import com.android.tools.idea.logcat.filters.StackTraceFilter;
import com.android.tools.idea.logcat.filters.StringFilter;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterAndExpression;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterExpression;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterLiteralExpression;
import com.android.tools.idea.logcat.filters.parser.LogcatFilterOrExpression;
import com.android.tools.idea.logcat.filters.parser.PsiExtensionsKt;
import com.android.tools.idea.logcat.message.LogLevel;
import com.android.tools.idea.logcat.util.AndroidProjectDetector;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.impl.source.tree.PsiErrorElementImpl;
import com.intellij.refactoring.suggested.UtilsKt;
import java.time.Clock;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000V\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u001a\f\u0010\u0007\u001a\u00020\b*\u00020\tH\u0002\u001a\u001c\u0010\n\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u001a\u0014\u0010\u0011\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\u0014\u0010\u0013\u001a\u00020\u0014*\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u001a\f\u0010\u0017\u001a\u00020\u0018*\u00020\u000eH\u0000\u001a\f\u0010\u0019\u001a\u00020\u0018*\u00020\u000eH\u0000\u001a\f\u0010\u001a\u001a\u00020\u0018*\u00020\u000eH\u0000\u001a$\u0010\u001b\u001a\u00020\u000b*\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006 "}, d2={"DURATION_RE", "Lkotlin/text/Regex;", "flattenAndExpression", "", "Lcom/android/tools/idea/logcat/filters/parser/LogcatFilterExpression;", "expression", "flattenOrExpression", "asLogLevel", "Lcom/android/tools/idea/logcat/message/LogLevel;", "Lcom/intellij/psi/PsiElement;", "createAgeFilter", "Lcom/android/tools/idea/logcat/filters/LogcatFilter;", "Lcom/android/tools/idea/logcat/filters/parser/LogcatFilterLiteralExpression;", "text", "", "clock", "Ljava/time/Clock;", "createIsFilter", "createNameFilter", "getFieldForImplicitOr", "Lcom/android/tools/idea/logcat/filters/FilterType;", "index", "", "isValidIsFilter", "", "isValidLogAge", "isValidLogLevel", "toKeyFilter", "packageNamesProvider", "Lcom/android/tools/idea/logcat/PackageNamesProvider;", "androidProjectDetector", "Lcom/android/tools/idea/logcat/util/AndroidProjectDetector;", "intellij.android.logcat"})
public final class LogcatFilterParserKt {
    @NotNull
    private static final Regex DURATION_RE = new Regex("\\d+[smhd]");

    private static final LogcatFilter toKeyFilter(LogcatFilterLiteralExpression $this$toKeyFilter, Clock clock, PackageNamesProvider packageNamesProvider, AndroidProjectDetector androidProjectDetector) {
        LogcatFilter logcatFilter;
        TextRange textRange = new TextRange(UtilsKt.getStartOffset((PsiElement)$this$toKeyFilter), UtilsKt.getEndOffset((PsiElement)$this$toKeyFilter));
        String string = $this$toKeyFilter.getFirstChild().getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"firstChild.text");
        char[] cArray = new char[]{':', '-', '~', '='};
        switch (StringsKt.trim((String)string, (char[])cArray)) {
            case "level": {
                PsiElement psiElement = $this$toKeyFilter.getLastChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"lastChild");
                logcatFilter = new LevelFilter(LogcatFilterParserKt.asLogLevel(psiElement), textRange);
                break;
            }
            case "age": {
                String string2 = $this$toKeyFilter.getLastChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lastChild.text");
                logcatFilter = LogcatFilterParserKt.createAgeFilter($this$toKeyFilter, string2, clock);
                break;
            }
            case "is": {
                String string3 = $this$toKeyFilter.getLastChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"lastChild.text");
                logcatFilter = LogcatFilterParserKt.createIsFilter($this$toKeyFilter, string3);
                break;
            }
            case "name": {
                PsiElement psiElement = $this$toKeyFilter.getLastChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"lastChild");
                logcatFilter = LogcatFilterParserKt.createNameFilter($this$toKeyFilter, PsiExtensionsKt.toText(psiElement));
                break;
            }
            default: {
                LogcatFilterField logcatFilterField;
                String key;
                PsiElement psiElement = $this$toKeyFilter.getLastChild();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"lastChild");
                String value2 = PsiExtensionsKt.toText(psiElement);
                String string4 = $this$toKeyFilter.getFirstChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"firstChild.text");
                boolean isNegated = StringsKt.startsWith$default((CharSequence)string4, (char)'-', (boolean)false, (int)2, null);
                String string5 = $this$toKeyFilter.getFirstChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"firstChild.text");
                boolean isRegex = StringsKt.endsWith$default((String)string5, (String)"~:", (boolean)false, (int)2, null);
                String string6 = $this$toKeyFilter.getFirstChild().getText();
                Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"firstChild.text");
                boolean isExact = StringsKt.endsWith$default((String)string6, (String)"=:", (boolean)false, (int)2, null);
                switch (key) {
                    case "tag": {
                        logcatFilterField = LogcatFilterField.TAG;
                        break;
                    }
                    case "package": {
                        logcatFilterField = LogcatFilterField.APP;
                        break;
                    }
                    case "process": {
                        logcatFilterField = LogcatFilterField.PROCESS;
                        break;
                    }
                    case "message": {
                        logcatFilterField = LogcatFilterField.MESSAGE;
                        break;
                    }
                    case "line": {
                        logcatFilterField = LogcatFilterField.LINE;
                        break;
                    }
                    default: {
                        throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid key: " + key));
                    }
                }
                LogcatFilterField field2 = logcatFilterField;
                logcatFilter = isNegated && isRegex ? (LogcatFilter)new NegatedRegexFilter(value2, field2, textRange) : (isNegated && isExact ? (LogcatFilter)new NegatedExactStringFilter(value2, field2, textRange) : (isNegated ? (LogcatFilter)new NegatedStringFilter(value2, field2, textRange) : (isRegex ? (LogcatFilter)new RegexFilter(value2, field2, textRange) : (isExact ? (LogcatFilter)new ExactStringFilter(value2, field2, textRange) : (Intrinsics.areEqual((Object)key, (Object)"package") && Intrinsics.areEqual((Object)value2, (Object)"mine") && LogcatFilterParserKt.toKeyFilter$isAndroidProject(androidProjectDetector, $this$toKeyFilter) ? (LogcatFilter)new ProjectAppFilter(packageNamesProvider, textRange) : (LogcatFilter)new StringFilter(value2, field2, textRange))))));
            }
        }
        return logcatFilter;
    }

    private static final LogcatFilter createAgeFilter(LogcatFilterLiteralExpression $this$createAgeFilter, String text2, Clock clock) {
        LogcatFilter logcatFilter;
        try {
            logcatFilter = new AgeFilter(text2, clock, new TextRange(UtilsKt.getStartOffset((PsiElement)$this$createAgeFilter), UtilsKt.getEndOffset((PsiElement)$this$createAgeFilter)));
        }
        catch (IllegalArgumentException e) {
            String string = e.getMessage();
            if (string == null) {
                string = "Parse error";
            }
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl(string));
        }
        return logcatFilter;
    }

    private static final LogcatFilter createIsFilter(LogcatFilterLiteralExpression $this$createIsFilter, String text2) {
        LogcatFilter logcatFilter;
        if (!((Boolean)StudioFlags.LOGCAT_IS_FILTER.get()).booleanValue()) {
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid key: is"));
        }
        if (Intrinsics.areEqual((Object)text2, (Object)"crash")) {
            logcatFilter = new CrashFilter(new TextRange(UtilsKt.getStartOffset((PsiElement)$this$createIsFilter), UtilsKt.getEndOffset((PsiElement)$this$createIsFilter)));
        } else if (Intrinsics.areEqual((Object)text2, (Object)"stacktrace")) {
            logcatFilter = new StackTraceFilter(new TextRange(UtilsKt.getStartOffset((PsiElement)$this$createIsFilter), UtilsKt.getEndOffset((PsiElement)$this$createIsFilter)));
        } else {
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid filter: is:" + text2));
        }
        return logcatFilter;
    }

    private static final LogcatFilter createNameFilter(LogcatFilterLiteralExpression $this$createNameFilter, String text2) {
        return new NameFilter(text2, new TextRange(UtilsKt.getStartOffset((PsiElement)$this$createNameFilter), UtilsKt.getEndOffset((PsiElement)$this$createNameFilter)));
    }

    private static final LogLevel asLogLevel(PsiElement $this$asLogLevel) {
        String string = $this$asLogLevel.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"text");
        String string2 = string.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        LogLevel logLevel = LogLevel.Companion.getByString(string2);
        if (logLevel == null) {
            throw new LogcatFilterParseException((PsiErrorElement)new PsiErrorElementImpl("Invalid Log Level: " + $this$asLogLevel.getText()));
        }
        return logLevel;
    }

    public static final boolean isValidLogLevel(@NotNull String $this$isValidLogLevel) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidLogLevel, (String)"<this>");
        String string = $this$isValidLogLevel.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase(Locale.ROOT)");
        return LogLevel.Companion.getByString(string) != null;
    }

    public static final boolean isValidIsFilter(@NotNull String $this$isValidIsFilter) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidIsFilter, (String)"<this>");
        return Intrinsics.areEqual((Object)$this$isValidIsFilter, (Object)"crash") || Intrinsics.areEqual((Object)$this$isValidIsFilter, (Object)"stacktrace");
    }

    public static final boolean isValidLogAge(@NotNull String $this$isValidLogAge) {
        Intrinsics.checkNotNullParameter((Object)$this$isValidLogAge, (String)"<this>");
        if (DURATION_RE.matchEntire((CharSequence)$this$isValidLogAge) == null) {
            return false;
        }
        try {
            String string = $this$isValidLogAge.substring(0, $this$isValidLogAge.length() - 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            Long.parseLong(string);
        }
        catch (NumberFormatException e) {
            return false;
        }
        return true;
    }

    private static final List<LogcatFilterExpression> flattenOrExpression(LogcatFilterExpression expression2) {
        List list2;
        if (expression2 instanceof LogcatFilterOrExpression) {
            LogcatFilterExpression logcatFilterExpression = ((LogcatFilterOrExpression)expression2).getExpressionList().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)logcatFilterExpression, (String)"expression.expressionList[0]");
            Collection collection2 = LogcatFilterParserKt.flattenOrExpression(logcatFilterExpression);
            LogcatFilterExpression logcatFilterExpression2 = ((LogcatFilterOrExpression)expression2).getExpressionList().get(1);
            Intrinsics.checkNotNullExpressionValue((Object)logcatFilterExpression2, (String)"expression.expressionList[1]");
            list2 = CollectionsKt.plus((Collection)collection2, (Iterable)LogcatFilterParserKt.flattenOrExpression(logcatFilterExpression2));
        } else {
            list2 = CollectionsKt.listOf((Object)expression2);
        }
        return list2;
    }

    private static final List<LogcatFilterExpression> flattenAndExpression(LogcatFilterExpression expression2) {
        List list2;
        if (expression2 instanceof LogcatFilterAndExpression) {
            LogcatFilterExpression logcatFilterExpression = ((LogcatFilterAndExpression)expression2).getExpressionList().get(0);
            Intrinsics.checkNotNullExpressionValue((Object)logcatFilterExpression, (String)"expression.expressionList[0]");
            Collection collection2 = LogcatFilterParserKt.flattenAndExpression(logcatFilterExpression);
            LogcatFilterExpression logcatFilterExpression2 = ((LogcatFilterAndExpression)expression2).getExpressionList().get(1);
            Intrinsics.checkNotNullExpressionValue((Object)logcatFilterExpression2, (String)"expression.expressionList[1]");
            list2 = CollectionsKt.plus((Collection)collection2, (Iterable)LogcatFilterParserKt.flattenAndExpression(logcatFilterExpression2));
        } else {
            list2 = CollectionsKt.listOf((Object)expression2);
        }
        return list2;
    }

    private static final FilterType getFieldForImplicitOr(LogcatFilter $this$getFieldForImplicitOr, int index2) {
        return $this$getFieldForImplicitOr instanceof StringFilter && ((StringFilter)$this$getFieldForImplicitOr).getField() != LogcatFilterField.IMPLICIT_LINE ? new FilterType((Object)((StringFilter)$this$getFieldForImplicitOr).getField()) : ($this$getFieldForImplicitOr instanceof RegexFilter ? new FilterType((Object)((RegexFilter)$this$getFieldForImplicitOr).getField()) : ($this$getFieldForImplicitOr instanceof ExactStringFilter ? new FilterType((Object)((ExactStringFilter)$this$getFieldForImplicitOr).getField()) : ($this$getFieldForImplicitOr instanceof LevelFilter ? new FilterType("level") : ($this$getFieldForImplicitOr instanceof AgeFilter ? new FilterType("age") : ($this$getFieldForImplicitOr instanceof CrashFilter ? new FilterType("is") : ($this$getFieldForImplicitOr instanceof StackTraceFilter ? new FilterType("is") : new FilterType(index2)))))));
    }

    private static final boolean toKeyFilter$isAndroidProject(AndroidProjectDetector $androidProjectDetector, LogcatFilterLiteralExpression $this_toKeyFilter) {
        Project project = $this_toKeyFilter.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        return $androidProjectDetector.isAndroidProject(project);
    }

    public static final /* synthetic */ List access$flattenAndExpression(LogcatFilterExpression expression2) {
        return LogcatFilterParserKt.flattenAndExpression(expression2);
    }

    public static final /* synthetic */ List access$flattenOrExpression(LogcatFilterExpression expression2) {
        return LogcatFilterParserKt.flattenOrExpression(expression2);
    }

    public static final /* synthetic */ LogcatFilter access$toKeyFilter(LogcatFilterLiteralExpression $receiver, Clock clock, PackageNamesProvider packageNamesProvider, AndroidProjectDetector androidProjectDetector) {
        return LogcatFilterParserKt.toKeyFilter($receiver, clock, packageNamesProvider, androidProjectDetector);
    }

    public static final /* synthetic */ FilterType access$getFieldForImplicitOr(LogcatFilter $receiver, int index2) {
        return LogcatFilterParserKt.getFieldForImplicitOr($receiver, index2);
    }
}

