/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat.actions;

import com.android.tools.idea.logcat.LogcatBundle;
import com.android.tools.idea.logcat.actions.CreateScratchFileActionKt;
import com.android.tools.idea.logcat.message.LogcatMessage;
import com.intellij.ide.scratch.ScratchFileCreationHelper;
import com.intellij.ide.scratch.ScratchFileService;
import com.intellij.ide.scratch.ScratchRootType;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.json.JsonLanguage;
import com.intellij.lang.Language;
import com.intellij.lang.xml.XMLLanguage;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.PathUtil;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u000e2\u00020\u0001:\u0003\u000e\u000f\u0010B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0010\u0010\r\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0006\u001a\u00070\u0007\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/android/tools/idea/logcat/actions/CreateScratchFileAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "()V", "navigationSupport", "Lcom/intellij/ide/util/PsiNavigationSupport;", "kotlin.jvm.PlatformType", "scratchRootType", "Lcom/intellij/ide/scratch/ScratchRootType;", "Lorg/jetbrains/annotations/NotNull;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "Companion", "EmbeddedData", "EmbeddedLanguage", "intellij.android.logcat"})
public final class CreateScratchFileAction
extends DumbAwareAction {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ScratchRootType scratchRootType;
    private final PsiNavigationSupport navigationSupport;

    public CreateScratchFileAction() {
        super("Create a Scratch File from JSON/XML");
        ScratchRootType scratchRootType = ScratchRootType.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)scratchRootType, (String)"getInstance()");
        this.scratchRootType = scratchRootType;
        this.navigationSupport = PsiNavigationSupport.getInstance();
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        e.getPresentation().setVisible(false);
        EmbeddedData embeddedData = Companion.findEmbeddedData$intellij_android_logcat(e);
        if (embeddedData == null) {
            return;
        }
        Language language = embeddedData.component2();
        Presentation presentation = e.getPresentation();
        Object[] objectArray = new Object[1];
        Intrinsics.checkNotNullExpressionValue((Object)language.getDisplayName(), (String)"language.displayName");
        presentation.setText(LogcatBundle.message("logcat.open.embedded.data.text", objectArray));
        LanguageFileType languageFileType = language.getAssociatedFileType();
        e.getPresentation().setIcon(languageFileType != null ? languageFileType.getIcon() : null);
        e.getPresentation().setVisible(true);
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Project project = e.getProject();
        if (project == null) {
            return;
        }
        Project project2 = project;
        EmbeddedData embeddedData = Companion.findEmbeddedData$intellij_android_logcat(e);
        if (embeddedData == null) {
            return;
        }
        EmbeddedData embeddedData2 = embeddedData;
        String text2 = embeddedData2.component1();
        Language language = embeddedData2.component2();
        String string = ScratchFileCreationHelper.reformat((Project)project2, (Language)language, (String)text2);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"reformat(project, language, text)");
        String formatted = string;
        Object object = language.getAssociatedFileType();
        if (object == null || (object = object.getDefaultExtension()) == null) {
            object = "";
        }
        Object fileExtension = object;
        String string2 = PathUtil.makeFileName((String)"logcat", (String)fileExtension);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"makeFileName(\"logcat\", fileExtension)");
        String fileName = string2;
        VirtualFile virtualFile = this.scratchRootType.createScratchFile(project2, fileName, language, formatted, ScratchFileService.Option.create_new_always);
        if (virtualFile == null) {
            return;
        }
        VirtualFile file2 = virtualFile;
        this.navigationSupport.createNavigatable(project2, file2, 0).navigate(true);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0010\u000b\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B3\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\u0002\u0010\u000bJ\u0010\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\tR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u001d\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\rj\u0002\b\u0015j\u0002\b\u0016\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/logcat/actions/CreateScratchFileAction$EmbeddedLanguage;", "", "language", "Lcom/intellij/lang/Language;", "startChar", "", "endChar", "isValid", "Lkotlin/Function1;", "", "", "(Ljava/lang/String;ILcom/intellij/lang/Language;CCLkotlin/jvm/functions/Function1;)V", "getEndChar", "()C", "()Lkotlin/jvm/functions/Function1;", "getLanguage", "()Lcom/intellij/lang/Language;", "getStartChar", "findInText", "Lcom/android/tools/idea/logcat/actions/CreateScratchFileAction$EmbeddedData;", "text", "JSON", "XML", "intellij.android.logcat"})
    private static final class EmbeddedLanguage
    extends Enum<EmbeddedLanguage> {
        @NotNull
        private final Language language;
        private final char startChar;
        private final char endChar;
        @NotNull
        private final Function1<String, Boolean> isValid;
        public static final /* enum */ EmbeddedLanguage JSON;
        public static final /* enum */ EmbeddedLanguage XML;
        private static final /* synthetic */ EmbeddedLanguage[] $VALUES;

        private EmbeddedLanguage(Language language, char startChar, char endChar, Function1<? super String, Boolean> isValid2) {
            this.language = language;
            this.startChar = startChar;
            this.endChar = endChar;
            this.isValid = isValid2;
        }

        @NotNull
        public final Language getLanguage() {
            return this.language;
        }

        public final char getStartChar() {
            return this.startChar;
        }

        public final char getEndChar() {
            return this.endChar;
        }

        @NotNull
        public final Function1<String, Boolean> isValid() {
            return this.isValid;
        }

        @Nullable
        public final EmbeddedData findInText(@NotNull String text2) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            int start2 = StringsKt.indexOf$default((CharSequence)text2, (char)this.startChar, (int)0, (boolean)false, (int)6, null);
            if (start2 < 0) {
                return null;
            }
            int end = StringsKt.lastIndexOf$default((CharSequence)text2, (char)this.endChar, (int)0, (boolean)false, (int)6, null);
            if (end < 0) {
                return null;
            }
            String string = text2.substring(start2, end + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String data2 = string;
            return (Boolean)this.isValid.invoke((Object)data2) != false ? new EmbeddedData(data2, this.language) : null;
        }

        public static EmbeddedLanguage[] values() {
            return (EmbeddedLanguage[])$VALUES.clone();
        }

        public static EmbeddedLanguage valueOf(String value2) {
            return Enum.valueOf(EmbeddedLanguage.class, value2);
        }

        static {
            JsonLanguage jsonLanguage = JsonLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)jsonLanguage, (String)"INSTANCE");
            JSON = new EmbeddedLanguage((Language)jsonLanguage, '{', '}', (Function1<? super String, Boolean>)((Function1)1.INSTANCE));
            XMLLanguage xMLLanguage = XMLLanguage.INSTANCE;
            Intrinsics.checkNotNullExpressionValue((Object)xMLLanguage, (String)"INSTANCE");
            XML = new EmbeddedLanguage((Language)xMLLanguage, '<', '>', (Function1<? super String, Boolean>)((Function1)2.INSTANCE));
            $VALUES = embeddedLanguageArray = new EmbeddedLanguage[]{EmbeddedLanguage.JSON, EmbeddedLanguage.XML};
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0081\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0014"}, d2={"Lcom/android/tools/idea/logcat/actions/CreateScratchFileAction$EmbeddedData;", "", "text", "", "language", "Lcom/intellij/lang/Language;", "(Ljava/lang/String;Lcom/intellij/lang/Language;)V", "getLanguage", "()Lcom/intellij/lang/Language;", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toString", "intellij.android.logcat"})
    @VisibleForTesting
    public static final class EmbeddedData {
        @NotNull
        private final String text;
        @NotNull
        private final Language language;

        public EmbeddedData(@NotNull String text2, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            this.text = text2;
            this.language = language;
        }

        @NotNull
        public final String getText() {
            return this.text;
        }

        @NotNull
        public final Language getLanguage() {
            return this.language;
        }

        @NotNull
        public final String component1() {
            return this.text;
        }

        @NotNull
        public final Language component2() {
            return this.language;
        }

        @NotNull
        public final EmbeddedData copy(@NotNull String text2, @NotNull Language language) {
            Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
            Intrinsics.checkNotNullParameter((Object)language, (String)"language");
            return new EmbeddedData(text2, language);
        }

        public static /* synthetic */ EmbeddedData copy$default(EmbeddedData embeddedData, String string, Language language, int n, Object object) {
            if ((n & 1) != 0) {
                string = embeddedData.text;
            }
            if ((n & 2) != 0) {
                language = embeddedData.language;
            }
            return embeddedData.copy(string, language);
        }

        @NotNull
        public String toString() {
            return "EmbeddedData(text=" + this.text + ", language=" + this.language + ")";
        }

        public int hashCode() {
            int result2 = this.text.hashCode();
            result2 = result2 * 31 + this.language.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof EmbeddedData)) {
                return false;
            }
            EmbeddedData embeddedData = (EmbeddedData)other;
            if (!Intrinsics.areEqual((Object)this.text, (Object)embeddedData.text)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.language, (Object)embeddedData.language);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004*\u00020\u0005H\u0001\u00a2\u0006\u0002\b\u0006\u00a8\u0006\u0007"}, d2={"Lcom/android/tools/idea/logcat/actions/CreateScratchFileAction$Companion;", "", "()V", "findEmbeddedData", "Lcom/android/tools/idea/logcat/actions/CreateScratchFileAction$EmbeddedData;", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "findEmbeddedData$intellij_android_logcat", "intellij.android.logcat"})
    public static final class Companion {
        private Companion() {
        }

        @VisibleForTesting
        @Nullable
        public final EmbeddedData findEmbeddedData$intellij_android_logcat(@NotNull AnActionEvent $this$findEmbeddedData) {
            Intrinsics.checkNotNullParameter((Object)$this$findEmbeddedData, (String)"<this>");
            Object object = CreateScratchFileActionKt.access$getLogcatMessage($this$findEmbeddedData);
            if (object == null || (object = ((LogcatMessage)object).getMessage()) == null) {
                return null;
            }
            Object message2 = object;
            EmbeddedLanguage[] $this$forEach$iv = EmbeddedLanguage.values();
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                EmbeddedLanguage element$iv;
                EmbeddedLanguage it = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                EmbeddedData data2 = it.findInText((String)message2);
                if (data2 == null) continue;
                return data2;
            }
            return null;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

