/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogConsole;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.logcat.LogcatJson;
import com.android.tools.idea.logcat.SafeAlarm;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.util.Alarm;
import org.jetbrains.annotations.NotNull;

final class ViewListener
implements AndroidLogcatService.LogcatListener {
    private static final int DELAY_MS = 500;
    private final AndroidLogcatView myView;
    private final SafeAlarm myAlarm;

    ViewListener(@NotNull AndroidLogcatView view) {
        this.myView = view;
        this.myAlarm = new SafeAlarm(Alarm.ThreadToUse.SWING_THREAD, view.parentDisposable);
    }

    @Override
    public void onLogLineReceived(@NotNull LogCatMessage line2) {
        this.myView.getLogConsole().addLogLine(LogcatJson.toJson(line2));
        this.myAlarm.addRequestIfNotEmpty(() -> ((ActionToolbar)this.myView.getToolbar()).updateActionsImmediately(), 500L);
    }

    @Override
    public void onCleared() {
        this.myView.getLogFilterModel().beginRejectingOldMessages();
        AndroidLogConsole console = this.myView.getLogConsole();
        if (console.getConsole() == null) {
            return;
        }
        console.clear();
    }
}

