/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatGlobalPreferences;
import com.android.tools.idea.logcat.SuppressLogTagsDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J&\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\r0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0011H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/logcat/SuppressLogTagsMenuAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "onRefresh", "Ljava/lang/Runnable;", "(Ljava/lang/Runnable;)V", "preferences", "Lcom/android/tools/idea/logcat/AndroidLogcatGlobalPreferences;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "extractLogTagsFromDocument", "", "", "document", "Lcom/intellij/openapi/editor/Document;", "offsetStart", "", "offsetEnd", "intellij.android.core"})
public final class SuppressLogTagsMenuAction
extends DumbAwareAction {
    @NotNull
    private final Runnable onRefresh;
    @NotNull
    private final AndroidLogcatGlobalPreferences preferences;

    public SuppressLogTagsMenuAction(@NotNull Runnable onRefresh) {
        Intrinsics.checkNotNullParameter((Object)onRefresh, (String)"onRefresh");
        super(AndroidBundle.message("android.configure.logcat.suppress.single.tag.text", new Object[0]), AndroidBundle.message("android.configure.logcat.suppress.single.tag.description", new Object[0]), AllIcons.RunConfigurations.ShowIgnored);
        this.onRefresh = onRefresh;
        this.preferences = AndroidLogcatGlobalPreferences.Companion.getInstance();
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Set<String> tags;
        Set<String> set;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            throw new IllegalArgumentException("AnActionEvent Data Context is missing required Editor");
        }
        Editor editor2 = editor;
        Document document2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
        Document document3 = document2;
        SelectionModel selectionModel = editor2.getSelectionModel();
        Intrinsics.checkNotNullExpressionValue((Object)selectionModel, (String)"editor.selectionModel");
        SelectionModel selectionModel2 = selectionModel;
        if (selectionModel2.hasSelection()) {
            set = this.extractLogTagsFromDocument(document3, selectionModel2.getSelectionStart(), selectionModel2.getSelectionEnd());
        } else {
            int offset = editor2.getCaretModel().getOffset();
            set = tags = this.extractLogTagsFromDocument(document3, offset, offset);
        }
        if (tags.size() <= 1) {
            this.preferences.getSuppressedLogTags().addAll((Collection<String>)tags);
            this.onRefresh.run();
        } else {
            Set<String> selectedTags;
            Project project = (Project)e.getData(CommonDataKeys.PROJECT);
            if (project == null) {
                throw new IllegalArgumentException("AnActionEvent Data Context is missing required Project");
            }
            Project project2 = project;
            SuppressLogTagsDialog confirmDialog = SuppressLogTagsDialog.Companion.newConfirmTagsDialog(project2, tags);
            if (confirmDialog.getDialogWrapper().showAndGet() && !((Collection)(selectedTags = confirmDialog.getSelectedTags())).isEmpty()) {
                this.preferences.getSuppressedLogTags().addAll((Collection<String>)selectedTags);
                this.onRefresh.run();
            }
        }
    }

    private final Set<String> extractLogTagsFromDocument(Document document2, int offsetStart, int offsetEnd) {
        Set tags = new LinkedHashSet();
        if (offsetEnd <= document2.getTextLength()) {
            int start2 = document2.getLineStartOffset(document2.getLineNumber(offsetStart));
            int end = document2.getLineEndOffset(document2.getLineNumber(offsetEnd));
            String string = document2.getText();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.text");
            String string2 = string.substring(start2, end);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String[] lines2 = StringUtil.splitByLines((String)((Object)StringsKt.trim((CharSequence)string2)).toString());
            Intrinsics.checkNotNullExpressionValue((Object)lines2, (String)"lines");
            for (String line2 : lines2) {
                Matcher matcher = AndroidLogcatFormatter.TAG_PATTERN.matcher(line2);
                if (!matcher.find()) continue;
                String string3 = matcher.group("tag");
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"matcher.group(AndroidLog\u2026r.TAG_PATTERN_GROUP_NAME)");
                tags.add(string3);
            }
        }
        return tags;
    }
}

