/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.AbstractDeviceAction;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatGlobalPreferences;
import com.android.tools.idea.logcat.SuppressLogTagsDialog;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0014R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/logcat/SuppressLogTagsAction;", "Lcom/android/tools/idea/ddms/actions/AbstractDeviceAction;", "context", "Lcom/android/tools/idea/ddms/DeviceContext;", "onRefresh", "Ljava/lang/Runnable;", "(Lcom/android/tools/idea/ddms/DeviceContext;Ljava/lang/Runnable;)V", "performAction", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "device", "Lcom/android/ddmlib/IDevice;", "intellij.android.core"})
public final class SuppressLogTagsAction
extends AbstractDeviceAction {
    @NotNull
    private final Runnable onRefresh;

    public SuppressLogTagsAction(@NotNull DeviceContext context2, @NotNull Runnable onRefresh) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        Intrinsics.checkNotNullParameter((Object)onRefresh, (String)"onRefresh");
        super(context2, AndroidBundle.message("android.configure.logcat.suppress.tags.text", new Object[0]), AndroidBundle.message("android.configure.logcat.suppress.tags.description", new Object[0]), AllIcons.RunConfigurations.ShowIgnored);
        this.onRefresh = onRefresh;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void performAction(@NotNull AnActionEvent e, @NotNull IDevice device2) {
        Set<String> selectedTags;
        void $this$mapTo$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Collection collection2;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
        AndroidLogcatGlobalPreferences preferences = AndroidLogcatGlobalPreferences.Companion.getInstance();
        HashSet<String> suppressedLogTags = preferences.getSuppressedLogTags();
        Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (editor == null) {
            throw new IllegalArgumentException("AnActionEvent Data Context is missing required Editor");
        }
        Editor editor2 = editor;
        String[] stringArray = StringUtil.splitByLines((String)editor2.getDocument().getText());
        Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"splitByLines(editor.document.text)");
        Object[] objectArray = stringArray;
        boolean $i$f$map = false;
        void var9_9 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(AndroidLogcatFormatter.TAG_PATTERN.matcher((CharSequence)it));
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            Matcher it = (Matcher)element$iv$iv;
            boolean bl = false;
            if (!it.find()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        Collection destination$iv = new HashSet();
        boolean $i$f$mapTo2 = false;
        for (Object item$iv : $this$mapTo$iv) {
            void it;
            Matcher matcher = (Matcher)item$iv;
            collection2 = destination$iv;
            boolean bl = false;
            collection2.add(it.group("tag"));
        }
        Set tagsFromLogcat = CollectionsKt.subtract((Iterable)destination$iv, (Iterable)suppressedLogTags);
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            throw new IllegalArgumentException("AnActionEvent Data Context is missing required Project");
        }
        Project project2 = project;
        SuppressLogTagsDialog dialog2 = SuppressLogTagsDialog.Companion.newManageTagsDialog(project2, (Set<String>)suppressedLogTags, tagsFromLogcat);
        dialog2.getDialogWrapper().setSize(preferences.getSuppressedLogTagsDialogDimension().width, preferences.getSuppressedLogTagsDialogDimension().height);
        if (dialog2.getDialogWrapper().showAndGet() && !Intrinsics.areEqual(selectedTags = dialog2.getSelectedTags(), suppressedLogTags)) {
            suppressedLogTags.clear();
            suppressedLogTags.addAll((Collection<String>)selectedTags);
            this.onRefresh.run();
        }
        Dimension dimension2 = dialog2.getDialogWrapper().getSize();
        Intrinsics.checkNotNullExpressionValue((Object)dimension2, (String)"dialog.dialogWrapper.size");
        preferences.setSuppressedLogTagsDialogDimension(dimension2);
    }
}

