/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="AndroidConfiguredLogFilters", storages={@Storage(value="$WORKSPACE_FILE$")})
public final class PersistentAndroidLogFilters
implements PersistentStateComponent<PersistentAndroidLogFilters> {
    private List<FilterData> myFilters = new ArrayList<FilterData>();

    public PersistentAndroidLogFilters getState() {
        return this;
    }

    public void loadState(@NotNull PersistentAndroidLogFilters state2) {
        XmlSerializerUtil.copyBean((Object)state2, (Object)this);
    }

    public static PersistentAndroidLogFilters getInstance(Project project) {
        return (PersistentAndroidLogFilters)project.getService(PersistentAndroidLogFilters.class);
    }

    @XCollection(style=XCollection.Style.v2)
    public List<FilterData> getFilters() {
        return this.myFilters.stream().map(FilterData::new).collect(Collectors.toList());
    }

    public void setFilters(List<FilterData> filterEntries) {
        this.myFilters = filterEntries;
    }

    @Tag(value="filter")
    static final class FilterData {
        @Nullable
        private String myName;
        @Nullable
        private String myLogMessagePattern;
        private boolean myLogMessageIsRegex = true;
        @Nullable
        private String myExpression;
        @Nullable
        private String myLogLevel;
        @Nullable
        private String myLogTagPattern;
        private boolean myLogTagIsRegex = true;
        @Nullable
        private String myPid;
        @Nullable
        private String myPackageNamePattern;
        private boolean myPackageNameIsRegex = true;

        public FilterData() {
        }

        public FilterData(@NotNull FilterData otherEntry) {
            this.myName = otherEntry.myName;
            this.myExpression = otherEntry.myExpression;
            this.myLogMessagePattern = otherEntry.myLogMessagePattern;
            this.myLogMessageIsRegex = otherEntry.myLogMessageIsRegex;
            this.myLogLevel = otherEntry.myLogLevel;
            this.myLogTagPattern = otherEntry.myLogTagPattern;
            this.myLogTagIsRegex = otherEntry.myLogTagIsRegex;
            this.myPid = otherEntry.myPid;
            this.myPackageNamePattern = otherEntry.myPackageNamePattern;
            this.myPackageNameIsRegex = otherEntry.myPackageNameIsRegex;
        }

        @Nullable
        public String getName() {
            return this.myName;
        }

        @Nullable
        public String getExpression() {
            return this.myExpression;
        }

        @Nullable
        public String getLogMessagePattern() {
            return this.myLogMessagePattern;
        }

        public boolean getLogMessageIsRegex() {
            return this.myLogMessageIsRegex;
        }

        @Nullable
        public String getLogLevel() {
            return this.myLogLevel;
        }

        @Nullable
        public String getLogTagPattern() {
            return this.myLogTagPattern;
        }

        public boolean getLogTagIsRegex() {
            return this.myLogTagIsRegex;
        }

        @Nullable
        public String getPid() {
            return this.myPid;
        }

        public void setName(@Nullable String name) {
            this.myName = name;
        }

        public void setExpression(@Nullable String expression2) {
            this.myExpression = expression2;
        }

        public void setLogMessagePattern(@Nullable String logMessagePattern) {
            this.myLogMessagePattern = logMessagePattern;
        }

        public void setLogMessageIsRegex(boolean logMessageIsRegex) {
            this.myLogMessageIsRegex = logMessageIsRegex;
        }

        public void setLogLevel(@Nullable String logLevel) {
            this.myLogLevel = logLevel;
        }

        public void setLogTagPattern(@Nullable String logTagPattern) {
            this.myLogTagPattern = logTagPattern;
        }

        public void setLogTagIsRegex(boolean logTagIsRegex) {
            this.myLogTagIsRegex = logTagIsRegex;
        }

        public void setPid(@Nullable String pid) {
            this.myPid = pid;
        }

        @Nullable
        public String getPackageNamePattern() {
            return this.myPackageNamePattern;
        }

        public boolean getPackageNameIsRegex() {
            return this.myPackageNameIsRegex;
        }

        public void setPackageNamePattern(@Nullable String packageNamePattern) {
            this.myPackageNamePattern = packageNamePattern;
        }

        public void setPackageNameIsRegex(boolean logPackageNameIsRegex) {
            this.myPackageNameIsRegex = logPackageNameIsRegex;
        }
    }
}

