/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.logcat.DeviceAndSearchPanel;
import com.android.tools.idea.run.ClearLogcatListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.components.JBLoadingPanel;
import java.awt.BorderLayout;
import java.awt.LayoutManager;
import org.jetbrains.annotations.NotNull;

public final class LogcatPanel
extends JBLoadingPanel {
    private final DevicePanel myDevicePanel;
    private final AndroidLogcatView myLogcatView;

    public LogcatPanel(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        super((LayoutManager)new BorderLayout(), (Disposable)project);
        DeviceContext context2 = new DeviceContext();
        this.myDevicePanel = new DevicePanel(project, context2);
        this.myLogcatView = new AndroidLogcatView(project, context2, toolWindow.getDisposable());
        this.add(new DeviceAndSearchPanel(this.myDevicePanel, this.myLogcatView), "North");
        this.add(this.myLogcatView.getContentPanel(), "Center");
        project.getMessageBus().connect((Disposable)project).subscribe(ClearLogcatListener.TOPIC, serialNumber -> {
            IDevice device2 = this.myLogcatView.getSelectedDevice();
            if (device2 != null && device2.getSerialNumber().equals(serialNumber)) {
                AndroidLogcatService.getInstance().clearLogcat(device2, this.myLogcatView.getProject());
            }
        });
    }

    @NotNull
    public DevicePanel getDevicePanel() {
        return this.myDevicePanel;
    }

    @NotNull
    public AndroidLogcatView getLogcatView() {
        return this.myLogcatView;
    }
}

