/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.LogcatHeaderFormatKt;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\b\u0018\u00002\u00020\u0001:\u0001\"B\u0007\b\u0016\u00a2\u0006\u0002\u0010\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0012\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0006H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0006H\u00c6\u0003J1\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00062\b\b\u0002\u0010\u0007\u001a\u00020\u00062\b\b\u0002\u0010\b\u001a\u00020\u0006H\u00c6\u0001J\b\u0010\u0017\u001a\u00020\u000bH\u0002J\u0013\u0010\u0018\u001a\u00020\u00062\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0016\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eJ\t\u0010\u001f\u001a\u00020 H\u00d6\u0001J\t\u0010!\u001a\u00020\u000bH\u00d6\u0001R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\b\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006#"}, d2={"Lcom/android/tools/idea/logcat/LogcatHeaderFormat;", "", "()V", "timestampFormat", "Lcom/android/tools/idea/logcat/LogcatHeaderFormat$TimestampFormat;", "showProcessId", "", "showPackageName", "showTag", "(Lcom/android/tools/idea/logcat/LogcatHeaderFormat$TimestampFormat;ZZZ)V", "format", "", "getShowPackageName", "()Z", "getShowProcessId", "getShowTag", "getTimestampFormat", "()Lcom/android/tools/idea/logcat/LogcatHeaderFormat$TimestampFormat;", "component1", "component2", "component3", "component4", "copy", "createFormatString", "equals", "other", "formatMessage", "logCatMessage", "Lcom/android/ddmlib/logcat/LogCatMessage;", "zoneId", "Ljava/time/ZoneId;", "hashCode", "", "toString", "TimestampFormat", "intellij.android.core"})
public final class LogcatHeaderFormat {
    @NotNull
    private final TimestampFormat timestampFormat;
    private final boolean showProcessId;
    private final boolean showPackageName;
    private final boolean showTag;
    @NotNull
    private final String format;

    public LogcatHeaderFormat(@NotNull TimestampFormat timestampFormat, boolean showProcessId, boolean showPackageName2, boolean showTag2) {
        Intrinsics.checkNotNullParameter((Object)((Object)timestampFormat), (String)"timestampFormat");
        this.timestampFormat = timestampFormat;
        this.showProcessId = showProcessId;
        this.showPackageName = showPackageName2;
        this.showTag = showTag2;
        this.format = this.createFormatString();
    }

    @NotNull
    public final TimestampFormat getTimestampFormat() {
        return this.timestampFormat;
    }

    public final boolean getShowProcessId() {
        return this.showProcessId;
    }

    public final boolean getShowPackageName() {
        return this.showPackageName;
    }

    public final boolean getShowTag() {
        return this.showTag;
    }

    public LogcatHeaderFormat() {
        this(TimestampFormat.DATETIME, true, true, true);
    }

    @NotNull
    public final String formatMessage(@NotNull LogCatMessage logCatMessage, @NotNull ZoneId zoneId) {
        String string;
        Intrinsics.checkNotNullParameter((Object)logCatMessage, (String)"logCatMessage");
        Intrinsics.checkNotNullParameter((Object)zoneId, (String)"zoneId");
        LogCatHeader header = logCatMessage.getHeader();
        Instant timestamp = header.getTimestamp();
        switch (WhenMappings.$EnumSwitchMapping$0[this.timestampFormat.ordinal()]) {
            case 1: {
                string = LogcatHeaderFormatKt.access$getEPOCH_TIME_FORMATTER$p().format(timestamp);
                break;
            }
            case 2: {
                string = LogcatHeaderFormatKt.access$getDATE_TIME_FORMATTER$p().format(LocalDateTime.ofInstant(timestamp, zoneId));
                break;
            }
            case 3: {
                string = null;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String timestampString = string;
        String processIdThreadId = header.getPid() + "-" + header.getTid();
        char priority = header.getLogLevel().getPriorityLetter();
        String string2 = header.getTag();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"header.tag");
        String tag = StringsKt.replace$default((String)string2, (char)' ', (char)'\u00a0', (boolean)false, (int)4, null);
        String string3 = this.format;
        Object[] objectArray = new Object[6];
        objectArray[0] = timestampString;
        objectArray[1] = processIdThreadId;
        objectArray[2] = header.getAppName();
        objectArray[3] = Character.valueOf(priority);
        objectArray[4] = tag;
        String string4 = logCatMessage.getMessage();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"logCatMessage.message");
        CharSequence charSequence = string4;
        Regex regex = new Regex("\n");
        String string5 = "\n    ";
        objectArray[5] = regex.replace(charSequence, string5);
        String string6 = String.format(string3, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"format(this, *args)");
        return string6;
    }

    private final String createFormatString() {
        StringBuilder builder2 = new StringBuilder();
        if (this.timestampFormat != TimestampFormat.NONE) {
            builder2.append("%1$s ");
        }
        if (this.showProcessId) {
            builder2.append("%2$s").append(this.showPackageName ? (char)'/' : ' ');
        }
        if (this.showPackageName) {
            builder2.append("%3$s ");
        }
        builder2.append("%4$c");
        if (this.showTag) {
            builder2.append("/%5$s");
        }
        builder2.append(": %6$s");
        String string = builder2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"builder.toString()");
        return string;
    }

    @NotNull
    public final TimestampFormat component1() {
        return this.timestampFormat;
    }

    public final boolean component2() {
        return this.showProcessId;
    }

    public final boolean component3() {
        return this.showPackageName;
    }

    public final boolean component4() {
        return this.showTag;
    }

    @NotNull
    public final LogcatHeaderFormat copy(@NotNull TimestampFormat timestampFormat, boolean showProcessId, boolean showPackageName2, boolean showTag2) {
        Intrinsics.checkNotNullParameter((Object)((Object)timestampFormat), (String)"timestampFormat");
        return new LogcatHeaderFormat(timestampFormat, showProcessId, showPackageName2, showTag2);
    }

    public static /* synthetic */ LogcatHeaderFormat copy$default(LogcatHeaderFormat logcatHeaderFormat, TimestampFormat timestampFormat, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 1) != 0) {
            timestampFormat = logcatHeaderFormat.timestampFormat;
        }
        if ((n & 2) != 0) {
            bl = logcatHeaderFormat.showProcessId;
        }
        if ((n & 4) != 0) {
            bl2 = logcatHeaderFormat.showPackageName;
        }
        if ((n & 8) != 0) {
            bl3 = logcatHeaderFormat.showTag;
        }
        return logcatHeaderFormat.copy(timestampFormat, bl, bl2, bl3);
    }

    @NotNull
    public String toString() {
        return "LogcatHeaderFormat(timestampFormat=" + this.timestampFormat + ", showProcessId=" + this.showProcessId + ", showPackageName=" + this.showPackageName + ", showTag=" + this.showTag + ")";
    }

    public int hashCode() {
        int result2 = this.timestampFormat.hashCode();
        int n = this.showProcessId ? 1 : 0;
        if (n != 0) {
            n = 1;
        }
        result2 = result2 * 31 + n;
        int n2 = this.showPackageName ? 1 : 0;
        if (n2 != 0) {
            n2 = 1;
        }
        result2 = result2 * 31 + n2;
        int n3 = this.showTag ? 1 : 0;
        if (n3 != 0) {
            n3 = 1;
        }
        result2 = result2 * 31 + n3;
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof LogcatHeaderFormat)) {
            return false;
        }
        LogcatHeaderFormat logcatHeaderFormat = (LogcatHeaderFormat)other;
        if (this.timestampFormat != logcatHeaderFormat.timestampFormat) {
            return false;
        }
        if (this.showProcessId != logcatHeaderFormat.showProcessId) {
            return false;
        }
        if (this.showPackageName != logcatHeaderFormat.showPackageName) {
            return false;
        }
        return this.showTag == logcatHeaderFormat.showTag;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcom/android/tools/idea/logcat/LogcatHeaderFormat$TimestampFormat;", "", "(Ljava/lang/String;I)V", "NONE", "EPOCH", "DATETIME", "intellij.android.core"})
    public static final class TimestampFormat
    extends Enum<TimestampFormat> {
        public static final /* enum */ TimestampFormat NONE = new TimestampFormat();
        public static final /* enum */ TimestampFormat EPOCH = new TimestampFormat();
        public static final /* enum */ TimestampFormat DATETIME = new TimestampFormat();
        private static final /* synthetic */ TimestampFormat[] $VALUES;

        public static TimestampFormat[] values() {
            return (TimestampFormat[])$VALUES.clone();
        }

        public static TimestampFormat valueOf(String value2) {
            return Enum.valueOf(TimestampFormat.class, value2);
        }

        static {
            $VALUES = timestampFormatArray = new TimestampFormat[]{TimestampFormat.NONE, TimestampFormat.EPOCH, TimestampFormat.DATETIME};
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TimestampFormat.values().length];
            nArray[TimestampFormat.EPOCH.ordinal()] = 1;
            nArray[TimestampFormat.DATETIME.ordinal()] = 2;
            nArray[TimestampFormat.NONE.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

