/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogConsole;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.SuppressLogTagsMenuAction;
import com.intellij.execution.actions.ClearConsoleAction;
import com.intellij.execution.actions.ConsoleActionsPostProcessor;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.editor.actions.ScrollToTheEndToolbarAction;
import com.intellij.openapi.project.DumbAwareAction;
import java.util.ArrayList;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class LogcatConsoleActionsPostProcessor
extends ConsoleActionsPostProcessor {
    @NotNull
    public @NotNull AnAction @NotNull [] postProcess(@NotNull ConsoleView console, AnAction @NotNull [] actions2) {
        if (!(console instanceof ConsoleViewImpl)) {
            return actions2;
        }
        ConsoleViewImpl consoleImpl = (ConsoleViewImpl)console;
        if (!(consoleImpl.getParent() instanceof AndroidLogConsole)) {
            return actions2;
        }
        return LogcatConsoleActionsPostProcessor.processActions((AndroidLogConsole)((Object)consoleImpl.getParent()), actions2);
    }

    @NotNull
    public @NotNull AnAction @NotNull [] postProcessPopupActions(@NotNull ConsoleView console, AnAction @NotNull [] actions2) {
        if (!(console instanceof ConsoleViewImpl)) {
            return actions2;
        }
        ConsoleViewImpl consoleImpl = (ConsoleViewImpl)console;
        if (!(consoleImpl.getParent() instanceof AndroidLogConsole)) {
            return actions2;
        }
        return LogcatConsoleActionsPostProcessor.processPopupActions((AndroidLogConsole)((Object)consoleImpl.getParent()), actions2);
    }

    @NotNull
    private static AnAction[] processActions(@NotNull AndroidLogConsole console, @NotNull AnAction[] actions2) {
        ArrayList<AnAction> actionList = new ArrayList<AnAction>(actions2.length);
        AnAction scrollToEndAction = null;
        for (AnAction a : actions2) {
            if (a instanceof ClearConsoleAction) continue;
            if (a instanceof ScrollToTheEndToolbarAction) {
                String message2 = "Scroll to the end. Clicking on a particular line stops scrolling and keeps that line visible.";
                a.getTemplatePresentation().setDescription(message2);
                a.getTemplatePresentation().setText(message2);
                scrollToEndAction = a;
                continue;
            }
            actionList.add(a);
        }
        if (scrollToEndAction != null) {
            actionList.add(0, scrollToEndAction);
        }
        actionList.add(0, AndroidLogConsole.registerAction(ActionManager.getInstance(), (AnAction)new ClearLogCatAction(console)));
        return actionList.toArray(AnAction.EMPTY_ARRAY);
    }

    @NotNull
    private static AnAction[] processPopupActions(@NotNull AndroidLogConsole console, @NotNull AnAction[] actions2) {
        ArrayList<DumbAwareAction> resultActions = new ArrayList<DumbAwareAction>();
        for (AnAction action2 : actions2) {
            if (action2 instanceof ClearConsoleAction) {
                resultActions.add(new ClearLogCatAction(console));
                continue;
            }
            resultActions.add((DumbAwareAction)action2);
        }
        AndroidLogcatPreferences preferences = AndroidLogcatPreferences.getInstance(console.getProject());
        if (((Boolean)StudioFlags.LOGCAT_SUPPRESSED_TAGS_ENABLE.get()).booleanValue() && preferences.LOGCAT_HEADER_FORMAT.getShowTag()) {
            resultActions.add(new SuppressLogTagsMenuAction(console::refresh));
        }
        return resultActions.toArray(new AnAction[0]);
    }

    private static final class ClearLogCatAction
    extends DumbAwareAction {
        private final AndroidLogConsole myConsole;

        private ClearLogCatAction(@NotNull AndroidLogConsole console) {
            super(AndroidBundle.message("android.logcat.clear.log.action.title", new Object[0]), AndroidBundle.message("android.logcat.clear.log.action.tooltip", new Object[0]), AllIcons.Actions.GC);
            this.myConsole = console;
        }

        public void update(@NotNull AnActionEvent e) {
            boolean enabled;
            boolean bl = enabled = e.getData(LangDataKeys.CONSOLE_VIEW) != null;
            if (this.myConsole.getOriginalDocument().length() == 0) {
                enabled = false;
            }
            if (this.myConsole.getSelectedDevice() == null || !this.myConsole.getSelectedDevice().isOnline()) {
                enabled = false;
            }
            e.getPresentation().setEnabled(enabled);
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myConsole.clearLogcat();
        }
    }
}

