/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.ExpressionFilterManager;
import com.android.tools.idea.logcat.PersistentAndroidLogFilters;
import com.android.tools.idea.logcat.RegexFilterComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DefaultAndroidLogcatFilter
implements AndroidLogcatFilter {
    @NotNull
    private static final ExpressionFilterManager EXPRESSION_FILTER_MANAGER = new ExpressionFilterManager();
    @NotNull
    private final String myName;
    @Nullable
    private final Pattern myMessagePattern;
    @Nullable
    private final Pattern myTagPattern;
    @Nullable
    private final Pattern myPkgNamePattern;
    @Nullable
    private final String myPid;
    @Nullable
    private final Log.LogLevel myLogLevel;
    @Nullable
    private String myExpression;

    private DefaultAndroidLogcatFilter(@NotNull String name, @Nullable Pattern messagePattern, @Nullable Pattern tagPattern, @Nullable Pattern pkgNamePattern, @Nullable String pid, @Nullable Log.LogLevel logLevel, @Nullable String expression2) {
        this.myName = name;
        this.myMessagePattern = messagePattern;
        this.myTagPattern = tagPattern;
        this.myPkgNamePattern = pkgNamePattern;
        this.myPid = pid;
        this.myLogLevel = logLevel;
        this.myExpression = expression2;
    }

    @Override
    public boolean isApplicable(@NotNull LogCatMessage logCatMessage) {
        LogCatHeader header = logCatMessage.getHeader();
        String message2 = logCatMessage.getMessage();
        Log.LogLevel logLevel = header.getLogLevel();
        String tag = header.getTag();
        String appName = header.getAppName();
        int pid = header.getPid();
        if (StringUtil.isNotEmpty((String)this.myExpression)) {
            try {
                if (!EXPRESSION_FILTER_MANAGER.eval(this.myExpression, logCatMessage)) {
                    return false;
                }
            }
            catch (ExpressionFilterManager.ExpressionException e) {
                Logger.getInstance(this.getClass()).warn("Error evaluating expression: " + this.myExpression);
                this.myExpression = null;
            }
        }
        if (this.myLogLevel != null && logLevel.getPriority() < this.myLogLevel.getPriority()) {
            return false;
        }
        if (this.myMessagePattern != null && !this.myMessagePattern.matcher(message2).find()) {
            return false;
        }
        if (this.myTagPattern != null && !this.myTagPattern.matcher(tag).find()) {
            return false;
        }
        if (this.myPkgNamePattern != null && !this.myPkgNamePattern.matcher(appName).find()) {
            return false;
        }
        return this.myPid == null || this.myPid.isEmpty() || this.myPid.equals(Integer.toString(pid));
    }

    @Override
    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public static DefaultAndroidLogcatFilter compile(@NotNull PersistentAndroidLogFilters.FilterData filterData, @NotNull String name) {
        Pattern logMessagePattern = RegexFilterComponent.pattern(filterData.getLogMessagePattern(), filterData.getLogMessageIsRegex());
        Pattern logTagPattern = RegexFilterComponent.pattern(filterData.getLogTagPattern(), filterData.getLogTagIsRegex());
        Pattern pkgNamePattern = RegexFilterComponent.pattern(filterData.getPackageNamePattern(), filterData.getPackageNameIsRegex());
        String expression2 = filterData.getExpression();
        String pid = filterData.getPid();
        Log.LogLevel logLevel = null;
        String logLevelStr = filterData.getLogLevel();
        if (logLevelStr != null && !logLevelStr.isEmpty()) {
            logLevel = Log.LogLevel.getByString((String)logLevelStr);
        }
        return new DefaultAndroidLogcatFilter(name, logMessagePattern, logTagPattern, pkgNamePattern, pid, logLevel, expression2);
    }
}

