/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.LogcatHeaderFormat;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.util.ui.JBFont;
import java.awt.Font;
import java.time.Instant;
import java.time.ZoneId;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

final class ConfigureLogcatHeaderDialog
extends DialogWrapper {
    private static final LogCatMessage SAMPLE = new LogCatMessage(new LogCatHeader(Log.LogLevel.INFO, 123, 456, "com.android.sample", "SampleTag", Instant.ofEpochMilli(1517955388555L)), "This is a sample message");
    private final ZoneId myTimeZone;
    private final AbstractButton myShowDateAndTimeCheckBox;
    private final AbstractButton myShowAsSecondsSinceEpochCheckBox;
    private final AbstractButton myShowProcessAndThreadIdsCheckBox;
    private final AbstractButton myShowPackageNameCheckBox;
    private final AbstractButton myShowTagCheckBox;
    private final JLabel mySampleLabel;

    ConfigureLogcatHeaderDialog(@NotNull Project project, @NotNull AndroidLogcatPreferences preferences, @NotNull ZoneId timeZone) {
        super(project, false, DialogWrapper.IdeModalityType.PROJECT);
        this.myTimeZone = timeZone;
        LogcatHeaderFormat format = preferences.LOGCAT_HEADER_FORMAT;
        this.myShowDateAndTimeCheckBox = this.createShowDateAndTimeCheckBox(format);
        this.myShowAsSecondsSinceEpochCheckBox = this.createCheckBox("Show as seconds since epoch", format.getTimestampFormat() == LogcatHeaderFormat.TimestampFormat.EPOCH, 8);
        this.myShowProcessAndThreadIdsCheckBox = this.createCheckBox("Show process and thread IDs", format.getShowProcessId(), 5);
        this.myShowPackageNameCheckBox = this.createCheckBox("Show package name", format.getShowPackageName(), 13);
        this.myShowTagCheckBox = this.createCheckBox("Show tag", format.getShowTag(), 7);
        this.mySampleLabel = this.createSampleLabel();
        this.init();
        this.setTitle(AndroidBundle.message("android.configure.logcat.header.title", new Object[0]));
    }

    @NotNull
    private AbstractButton createShowDateAndTimeCheckBox(LogcatHeaderFormat format) {
        JCheckBox checkBox2 = new JCheckBox("Show date and time", format.getTimestampFormat() != LogcatHeaderFormat.TimestampFormat.NONE);
        checkBox2.setDisplayedMnemonicIndex(14);
        checkBox2.addItemListener(event -> {
            this.myShowAsSecondsSinceEpochCheckBox.setVisible(this.myShowDateAndTimeCheckBox.isSelected());
            this.mySampleLabel.setText(this.formatSample());
        });
        return checkBox2;
    }

    @NotNull
    private AbstractButton createCheckBox(@NotNull String text2, boolean selected, int displayedMnemonicIndex) {
        JCheckBox checkBox2 = new JCheckBox(text2, selected);
        checkBox2.setDisplayedMnemonicIndex(displayedMnemonicIndex);
        checkBox2.addItemListener(event -> this.mySampleLabel.setText(this.formatSample()));
        return checkBox2;
    }

    @NotNull
    private JLabel createSampleLabel() {
        JLabel label = new JLabel(this.formatSample());
        label.setFont((Font)JBFont.create((Font)new Font("Monospaced", 0, 15)));
        return label;
    }

    @NotNull
    private String formatSample() {
        AndroidLogcatPreferences preferences = new AndroidLogcatPreferences();
        preferences.LOGCAT_HEADER_FORMAT = this.getFormat();
        return new AndroidLogcatFormatter(this.myTimeZone, preferences).formatMessage(SAMPLE);
    }

    LogcatHeaderFormat getFormat() {
        LogcatHeaderFormat.TimestampFormat timestampFormat = this.myShowDateAndTimeCheckBox.isSelected() ? (this.myShowAsSecondsSinceEpochCheckBox.isSelected() ? LogcatHeaderFormat.TimestampFormat.EPOCH : LogcatHeaderFormat.TimestampFormat.DATETIME) : LogcatHeaderFormat.TimestampFormat.NONE;
        return new LogcatHeaderFormat(timestampFormat, this.myShowProcessAndThreadIdsCheckBox.isSelected(), this.myShowPackageNameCheckBox.isSelected(), this.myShowTagCheckBox.isSelected());
    }

    @NotNull
    AbstractButton getShowDateAndTimeCheckBox() {
        return this.myShowDateAndTimeCheckBox;
    }

    @NotNull
    AbstractButton getShowAsSecondsSinceEpochCheckBox() {
        return this.myShowAsSecondsSinceEpochCheckBox;
    }

    @NotNull
    AbstractButton getShowProcessAndThreadIdsCheckBox() {
        return this.myShowProcessAndThreadIdsCheckBox;
    }

    @NotNull
    AbstractButton getShowPackageNameCheckBox() {
        return this.myShowPackageNameCheckBox;
    }

    @NotNull
    AbstractButton getShowTagCheckBox() {
        return this.myShowTagCheckBox;
    }

    @NotNull
    JLabel getSampleLabel() {
        return this.mySampleLabel;
    }

    @NotNull
    protected JComponent createCenterPanel() {
        JPanel panel2 = new JPanel(null);
        GroupLayout layout = new GroupLayout(panel2);
        GroupLayout.ParallelGroup horizontalGroup = layout.createParallelGroup().addComponent(this.myShowDateAndTimeCheckBox).addGroup(layout.createSequentialGroup().addPreferredGap(this.myShowDateAndTimeCheckBox, this.myShowAsSecondsSinceEpochCheckBox, LayoutStyle.ComponentPlacement.INDENT).addComponent(this.myShowAsSecondsSinceEpochCheckBox)).addComponent(this.myShowProcessAndThreadIdsCheckBox).addComponent(this.myShowPackageNameCheckBox).addComponent(this.myShowTagCheckBox).addComponent(this.mySampleLabel);
        GroupLayout.SequentialGroup verticalGroup = layout.createSequentialGroup().addComponent(this.myShowDateAndTimeCheckBox).addComponent(this.myShowAsSecondsSinceEpochCheckBox).addComponent(this.myShowProcessAndThreadIdsCheckBox).addComponent(this.myShowPackageNameCheckBox).addComponent(this.myShowTagCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.mySampleLabel);
        layout.setAutoCreateContainerGaps(true);
        layout.setAutoCreateGaps(true);
        layout.setHorizontalGroup(horizontalGroup);
        layout.setVerticalGroup(verticalGroup);
        panel2.setLayout(layout);
        return panel2;
    }
}

