/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Client;
import com.android.ddmlib.ClientData;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.logcat.AndroidLogConsole;
import com.android.tools.idea.logcat.AndroidLogFilterModel;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.ConfigureLogcatHeaderDialog;
import com.android.tools.idea.logcat.DefaultAndroidLogcatFilter;
import com.android.tools.idea.logcat.EditLogFilterDialog;
import com.android.tools.idea.logcat.LogcatExperimentalSettings;
import com.android.tools.idea.logcat.LogcatFilterProvider;
import com.android.tools.idea.logcat.MatchAllFilter;
import com.android.tools.idea.logcat.PersistentAndroidLogFilters;
import com.android.tools.idea.logcat.SelectedProcessFilter;
import com.android.tools.idea.logcat.ViewListener;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.diagnostic.logging.LogFormatter;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.components.BorderLayoutPanel;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.time.ZoneId;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListCellRenderer;
import javax.swing.ListModel;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLogcatView {
    static final AndroidLogcatFilter NO_FILTERS_ITEM = new MatchAllFilter(AndroidLogcatView.getNoFilters());
    static final AndroidLogcatFilter EDIT_FILTER_CONFIGURATION_ITEM = new MatchAllFilter(AndroidLogcatView.getEditFilterConfiguration());
    private final Project myProject;
    final Disposable parentDisposable;
    private final AndroidLogcatService.LogcatListener myLogcatReceiver;
    private final AndroidLogConsole myLogConsole;
    private final DeviceContext myDeviceContext;
    private final AndroidLogFilterModel myLogFilterModel;
    private volatile IDevice myDevice;
    private DefaultComboBoxModel<AndroidLogcatFilter> myFilterComboBoxModel;
    private ActionToolbar myToolbar;
    private JPanel myPanel;

    private void notifyDeviceUpdated(boolean forceReconnect) {
        UIUtil.invokeAndWaitIfNeeded(() -> {
            if (this.myProject.isDisposed()) {
                return;
            }
            if (forceReconnect) {
                if (this.myDevice != null) {
                    AndroidLogcatService.getInstance().removeListener(this.myDevice, this.myLogcatReceiver);
                }
                this.myDevice = null;
            }
            this.updateLogConsole();
        });
    }

    @NotNull
    public final Project getProject() {
        return this.myProject;
    }

    @NotNull
    public final AndroidLogConsole getLogConsole() {
        return this.myLogConsole;
    }

    @NotNull
    DeviceContext getDeviceContext() {
        return this.myDeviceContext;
    }

    @NotNull
    AndroidLogFilterModel getLogFilterModel() {
        return this.myLogFilterModel;
    }

    @VisibleForTesting
    @NotNull
    ListModel<AndroidLogcatFilter> getEditFiltersComboBoxModel() {
        return this.myFilterComboBoxModel;
    }

    @NotNull
    ActionToolbar getToolbar() {
        return this.myToolbar;
    }

    AndroidLogcatView(@NotNull Project project, @NotNull DeviceContext deviceContext, @NotNull Disposable parentDisposable) {
        LogcatExperimentalSettings logcatExperimentalSettings;
        this.myDeviceContext = deviceContext;
        this.myProject = project;
        this.parentDisposable = parentDisposable;
        this.$$$setupUI$$$();
        AndroidLogcatPreferences preferences = AndroidLogcatPreferences.getInstance(project);
        AndroidLogcatFormatter formatter = new AndroidLogcatFormatter(ZoneId.systemDefault(), preferences);
        this.myLogFilterModel = new AndroidLogFilterModel(formatter, preferences);
        this.myLogConsole = new AndroidLogConsole(project, this.myLogFilterModel, (LogFormatter)formatter, this);
        this.myLogcatReceiver = new ViewListener(this);
        Disposer.register((Disposable)parentDisposable, () -> {
            if (this.myDevice != null) {
                AndroidLogcatService.getInstance().removeListener(this.myDevice, this.myLogcatReceiver);
            }
        });
        DeviceContext.DeviceSelectionListener deviceSelectionListener = new DeviceContext.DeviceSelectionListener(){

            @Override
            public void deviceSelected(@Nullable IDevice device2) {
                AndroidLogcatView.this.notifyDeviceUpdated(false);
            }

            @Override
            public void deviceChanged(@NotNull IDevice device2, int changeMask) {
                if (device2 == AndroidLogcatView.this.myDevice && (changeMask & 1) == 1) {
                    AndroidLogcatView.this.notifyDeviceUpdated(true);
                }
            }

            @Override
            public void clientSelected(@Nullable Client c) {
                if (AndroidLogcatView.this.myFilterComboBoxModel == null) {
                    return;
                }
                AndroidLogcatFilter selected = (AndroidLogcatFilter)AndroidLogcatView.this.myFilterComboBoxModel.getSelectedItem();
                AndroidLogcatView.this.updateDefaultFilters(c != null ? c.getClientData() : null);
                if (selected != null && AndroidLogcatView.this.myFilterComboBoxModel.getSelectedItem() != selected) {
                    AndroidLogcatView.this.selectFilterByName(selected.getName());
                }
                AndroidLogcatView.this.applySelectedFilter();
            }
        };
        deviceContext.addListener(deviceSelectionListener, parentDisposable);
        JComponent consoleComponent = this.myLogConsole.getComponent();
        ConsoleView console = this.myLogConsole.getConsole();
        if (console != null) {
            this.myToolbar = ActionManager.getInstance().createActionToolbar("AndroidLogcatView", this.myLogConsole.getOrCreateActions(), false);
            this.myToolbar.setTargetComponent(console.getComponent());
            this.myPanel.add((Component)this.myToolbar.getComponent(), "West");
        }
        if ((logcatExperimentalSettings = LogcatExperimentalSettings.getInstance()).getBannerDismissed()) {
            this.myPanel.add((Component)consoleComponent, "Center");
        } else {
            BorderLayoutPanel centerPanel2 = new BorderLayoutPanel();
            EditorNotificationPanel banner = new EditorNotificationPanel();
            banner.setText("Try the new Logcat with improved formatting and filtering options.");
            banner.createActionLabel("Enable", () -> {
                logcatExperimentalSettings.setLogcatV2Enabled(true);
                banner.clear();
                banner.setText("The new Logcat is enabled and will be visible after restarting the IDE.");
                banner.createActionLabel("Restart now", () -> ((ApplicationEx)ApplicationManager.getApplication()).restart(true));
                banner.createActionLabel("Dismiss", () -> centerPanel2.remove((Component)banner));
            });
            banner.createActionLabel("Dismiss", () -> {
                logcatExperimentalSettings.setBannerDismissed(true);
                centerPanel2.remove((Component)banner);
            });
            centerPanel2.addToTop((Component)banner);
            centerPanel2.addToCenter((Component)consoleComponent);
            this.myPanel.add((Component)centerPanel2, "Center");
        }
        Disposer.register((Disposable)parentDisposable, (Disposable)this.myLogConsole);
        this.updateLogConsole();
    }

    @NotNull
    public ComboBox<AndroidLogcatFilter> createEditFiltersComboBox() {
        final ComboBox editFiltersCombo = new ComboBox();
        this.myFilterComboBoxModel = new DefaultComboBoxModel();
        this.myFilterComboBoxModel.addElement(new SelectedProcessFilter(null));
        for (LogcatFilterProvider filterProvider : (LogcatFilterProvider[])LogcatFilterProvider.EP_NAME.getExtensions()) {
            this.myFilterComboBoxModel.addElement(filterProvider.getFilter());
        }
        this.myFilterComboBoxModel.addElement(NO_FILTERS_ITEM);
        this.myFilterComboBoxModel.addElement(EDIT_FILTER_CONFIGURATION_ITEM);
        this.updateUserFilters();
        String selectName = AndroidLogcatPreferences.getInstance((Project)this.myProject).TOOL_WINDOW_CONFIGURED_FILTER;
        if (StringUtil.isEmpty((String)selectName)) {
            selectName = this.myDeviceContext != null ? AndroidLogcatView.getSelectedAppFilter() : AndroidLogcatView.getNoFilters();
        }
        this.selectFilterByName(selectName);
        editFiltersCombo.setModel(this.myFilterComboBoxModel);
        this.applySelectedFilter();
        editFiltersCombo.addItemListener(new ItemListener(){
            @Nullable
            private AndroidLogcatFilter myLastSelected;

            @Override
            public void itemStateChanged(ItemEvent e) {
                Object item2 = e.getItem();
                if (e.getStateChange() == 2) {
                    if (item2 instanceof AndroidLogcatFilter) {
                        this.myLastSelected = (AndroidLogcatFilter)item2;
                    }
                } else if (e.getStateChange() == 1) {
                    if (item2.equals(EDIT_FILTER_CONFIGURATION_ITEM)) {
                        EditLogFilterDialog dialog2 = new EditLogFilterDialog(AndroidLogcatView.this, this.myLastSelected == null ? null : this.myLastSelected.getName());
                        dialog2.setTitle(AndroidBundle.message("android.logcat.new.filter.dialog.title", new Object[0]));
                        if (dialog2.showAndGet()) {
                            PersistentAndroidLogFilters.FilterData filterData = dialog2.getActiveFilter();
                            AndroidLogcatView.this.updateUserFilters();
                            if (filterData != null) {
                                AndroidLogcatView.this.selectFilterByName(filterData.getName());
                            }
                        } else {
                            editFiltersCombo.setSelectedItem((Object)this.myLastSelected);
                        }
                    } else {
                        AndroidLogcatView.this.applySelectedFilter();
                    }
                }
            }
        });
        editFiltersCombo.setRenderer((ListCellRenderer)new ColoredListCellRenderer<Object>(){

            protected void customizeCellRenderer(@NotNull JList list2, Object value2, int index2, boolean selected, boolean hasFocus) {
                if (value2 instanceof AndroidLogcatFilter) {
                    this.setBorder(null);
                    this.append(((AndroidLogcatFilter)value2).getName());
                } else {
                    this.setBorder(IdeBorderFactory.createBorder((int)8));
                    this.append(value2.toString());
                }
            }
        });
        return editFiltersCombo;
    }

    boolean isActive() {
        return Objects.requireNonNull(ToolWindowManager.getInstance((Project)this.myProject).getToolWindow("Logcat")).isVisible();
    }

    public final void activate() {
        if (this.isActive()) {
            this.updateLogConsole();
        }
        if (this.myLogConsole != null) {
            this.myLogConsole.activate();
        }
    }

    private void updateLogConsole() {
        IDevice device2 = this.getSelectedDevice();
        if (this.myDevice != device2) {
            AndroidLogcatService androidLogcatService = AndroidLogcatService.getInstance();
            if (this.myDevice != null) {
                androidLogcatService.removeListener(this.myDevice, this.myLogcatReceiver);
            }
            if (this.myLogConsole.getConsole() != null && device2 != null && device2.isOnline()) {
                this.myLogConsole.clear();
            }
            this.myDevice = device2;
            this.myLogFilterModel.processingStarted();
            androidLogcatService.addListener(this.myDevice, this.myLogcatReceiver, true);
        }
    }

    @Nullable
    IDevice getSelectedDevice() {
        if (this.myDeviceContext != null) {
            return this.myDeviceContext.getSelectedDevice();
        }
        return null;
    }

    private void applySelectedFilter() {
        final Object filter2 = this.myFilterComboBoxModel.getSelectedItem();
        if (filter2 instanceof AndroidLogcatFilter) {
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Applying filter..."){

                public void run(@NotNull ProgressIndicator indicator) {
                    AndroidLogcatView.this.myLogFilterModel.updateLogcatFilter((AndroidLogcatFilter)filter2);
                }
            });
        }
    }

    @VisibleForTesting
    void updateDefaultFilters(@Nullable ClientData client2) {
        for (int i = 0; i < this.myFilterComboBoxModel.getSize(); ++i) {
            this.myFilterComboBoxModel.getElementAt(i).setClient(client2);
        }
    }

    private void updateUserFilters() {
        int editFilterConfigurationItemIndex = this.myFilterComboBoxModel.getIndexOf(EDIT_FILTER_CONFIGURATION_ITEM);
        assert (editFilterConfigurationItemIndex != -1);
        int userFiltersStartIndex = editFilterConfigurationItemIndex + 1;
        while (this.myFilterComboBoxModel.getSize() > userFiltersStartIndex) {
            this.myFilterComboBoxModel.removeElementAt(userFiltersStartIndex);
        }
        List<PersistentAndroidLogFilters.FilterData> filters = PersistentAndroidLogFilters.getInstance(this.myProject).getFilters();
        for (PersistentAndroidLogFilters.FilterData filter2 : filters) {
            String name = filter2.getName();
            assert (name != null);
            DefaultAndroidLogcatFilter compiled = DefaultAndroidLogcatFilter.compile(filter2, name);
            this.myFilterComboBoxModel.addElement(compiled);
        }
    }

    private void selectFilterByName(String name) {
        Optional<AndroidLogcatFilter> optionalFilter = IntStream.range(0, this.myFilterComboBoxModel.getSize()).mapToObj(i -> this.myFilterComboBoxModel.getElementAt(i)).filter(filter2 -> filter2.getName().equals(name)).findFirst();
        optionalFilter.ifPresent(filter2 -> this.myFilterComboBoxModel.setSelectedItem(filter2));
    }

    @NotNull
    public final JPanel getContentPanel() {
        return this.myPanel;
    }

    static String getSelectedAppFilter() {
        return AndroidBundle.message("android.logcat.filters.selected", new Object[0]);
    }

    static String getNoFilters() {
        return AndroidBundle.message("android.logcat.filters.none", new Object[0]);
    }

    static String getEditFilterConfiguration() {
        return AndroidBundle.message("android.logcat.filters.edit", new Object[0]);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(-1, -1));
        ((Component)jPanel).setBackground(new Color(-1));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    static final class MyConfigureLogcatHeaderAction
    extends AnAction {
        private final AndroidLogcatView myView;

        MyConfigureLogcatHeaderAction(@NotNull AndroidLogcatView view) {
            super(AndroidBundle.message("android.configure.logcat.header.text", new Object[0]), AndroidBundle.message("android.configure.logcat.header.description", new Object[0]), AllIcons.General.GearPlain);
            this.myView = view;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            Project project = this.myView.myProject;
            AndroidLogcatPreferences preferences = AndroidLogcatPreferences.getInstance(project);
            ConfigureLogcatHeaderDialog dialog2 = new ConfigureLogcatHeaderDialog(project, preferences, ZoneId.systemDefault());
            if (dialog2.showAndGet()) {
                preferences.LOGCAT_HEADER_FORMAT = dialog2.getFormat();
                this.myView.myLogConsole.refresh();
            }
        }
    }

    static final class MyRestartAction
    extends AnAction {
        private final AndroidLogcatView myView;

        MyRestartAction(@NotNull AndroidLogcatView view) {
            super(AndroidBundle.message("android.restart.logcat.action.text", new Object[0]), AndroidBundle.message("android.restart.logcat.action.description", new Object[0]), AllIcons.Actions.Restart);
            this.myView = view;
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            this.myView.notifyDeviceUpdated(true);
        }
    }
}

