/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidLogcatConstants;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.Key;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.NotNull;

public final class AndroidLogcatUtils {
    private static final String EMPTY_TAG = AndroidBundle.message("android.configure.logcat.tag.empty", new Object[0]);

    private AndroidLogcatUtils() {
    }

    @NotNull
    public static Key<?> getProcessOutputType(@NotNull Log.LogLevel level) {
        switch (level) {
            case VERBOSE: {
                return AndroidLogcatConstants.VERBOSE;
            }
            case INFO: {
                return AndroidLogcatConstants.INFO;
            }
            case DEBUG: {
                return AndroidLogcatConstants.DEBUG;
            }
            case WARN: {
                return AndroidLogcatConstants.WARNING;
            }
            case ERROR: {
                return AndroidLogcatConstants.ERROR;
            }
            case ASSERT: {
                return AndroidLogcatConstants.ASSERT;
            }
        }
        return ProcessOutputTypes.STDOUT;
    }

    @NotNull
    public static String getTagDisplayText(@NotNull String tag) {
        return tag.isEmpty() ? EMPTY_TAG : tag;
    }

    @NotNull
    public static String getTagFromDisplayText(@NotNull String displayText) {
        return displayText.equals(EMPTY_TAG) ? "" : displayText;
    }
}

