/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.tools.idea.AndroidEnvironmentUtils;
import com.android.tools.idea.adb.AdbService;
import com.android.tools.idea.ddms.DevicePanel;
import com.android.tools.idea.logcat.AndroidLogcatColorPage;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.logcat.LogcatExperimentalSettings;
import com.android.tools.idea.logcat.LogcatPanel;
import com.android.tools.idea.run.ShowLogcatListener;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.intellij.ProjectTopics;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.options.colors.ColorSettingsPage;
import com.intellij.openapi.options.colors.ColorSettingsPages;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowFactory;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ToolWindowEx;
import com.intellij.openapi.wm.ex.ToolWindowManagerListener;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.messages.MessageBusConnection;
import java.awt.EventQueue;
import java.io.File;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.swing.JComponent;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidSdkUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLogcatToolWindowFactory
implements ToolWindowFactory,
DumbAware {
    public static final Key<DevicePanel> DEVICES_PANEL_KEY = Key.create((String)"DevicePanel");

    public AndroidLogcatToolWindowFactory() {
        if (!LogcatExperimentalSettings.getInstance().getLogcatV2Enabled()) {
            ColorSettingsPages.getInstance().registerPage((ColorSettingsPage)new AndroidLogcatColorPage());
        }
    }

    public void init(final @NotNull ToolWindow toolWindow) {
        Project project = ((ToolWindowEx)toolWindow).getProject();
        project.getMessageBus().connect((Disposable)project).subscribe(ShowLogcatListener.TOPIC, (Object)new ShowLogcatListener(){

            @Override
            public void showLogcat(@NotNull ShowLogcatListener.DeviceInfo deviceInfo, @Nullable String applicationId2) {
            }

            @Override
            public void showLogcat(@NotNull IDevice device2, @Nullable String applicationId2) {
                AndroidLogcatToolWindowFactory.this.showLogcat(toolWindow, device2, applicationId2);
            }
        });
    }

    public boolean isApplicable(@NotNull Project project) {
        return !LogcatExperimentalSettings.getInstance().getLogcatV2Enabled() && AndroidEnvironmentUtils.isAndroidEnvironment((Project)project);
    }

    public void createToolWindowContent(@NotNull Project project, @NotNull ToolWindow toolWindow) {
        RunContentManager.getInstance((Project)project);
        toolWindow.setAvailable(true);
        toolWindow.setToHideOnEmptyContent(true);
        final LogcatPanel logcatPanel = new LogcatPanel(project, toolWindow);
        AndroidLogcatView logcatView = logcatPanel.getLogcatView();
        MessageBusConnection busConnection = project.getMessageBus().connect(toolWindow.getDisposable());
        busConnection.subscribe(ToolWindowManagerListener.TOPIC, (Object)new MyToolWindowManagerListener(project, logcatView));
        busConnection.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new MyAndroidPlatformListener(logcatView));
        ContentManager contentManager = toolWindow.getContentManager();
        Content c = contentManager.getFactory().createContent((JComponent)((Object)logcatPanel), "", true);
        c.putUserData(DEVICES_PANEL_KEY, (Object)logcatPanel.getDevicePanel());
        contentManager.addContent(c);
        ApplicationManager.getApplication().invokeLater(() -> {
            ConsoleView console;
            logcatView.activate();
            ToolWindow window2 = ToolWindowManager.getInstance((Project)project).getToolWindow(AndroidLogcatToolWindowFactory.getToolWindowId());
            if (window2 != null && window2.isVisible() && (console = logcatView.getLogConsole().getConsole()) != null) {
                AndroidLogcatToolWindowFactory.checkFacetAndSdk(project, console);
            }
        }, project.getDisposed());
        final File adb = AndroidSdkUtils.getAdb(project);
        if (adb == null) {
            return;
        }
        logcatPanel.setLoadingText("Initializing ADB");
        logcatPanel.startLoading();
        ListenableFuture<AndroidDebugBridge> future2 = AdbService.getInstance().getDebugBridge(adb);
        Futures.addCallback(future2, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(@Nullable AndroidDebugBridge bridge) {
                AndroidLogcatToolWindowFactory.this.thisLogger().info("Successfully obtained debug bridge");
                logcatPanel.stopLoading();
            }

            public void onFailure(@NotNull Throwable t) {
                logcatPanel.stopLoading();
                AndroidLogcatToolWindowFactory.this.thisLogger().info("Unable to obtain debug bridge", t);
                Messages.showErrorDialog((String)AdbService.getDebugBridgeDiagnosticErrorMessage(t, adb), (String)"ADB Connection Error");
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    private void showLogcat(final @NotNull ToolWindow toolWindow, final @NotNull String serialNumber, final @Nullable String applicationId2) {
        File adb = AndroidSdkUtils.getAdb(toolWindow.getProject());
        if (adb == null) {
            this.thisLogger().warn("Failed to show Logcat for device: adb not found");
            return;
        }
        ListenableFuture<AndroidDebugBridge> future2 = AdbService.getInstance().getDebugBridge(adb);
        Futures.addCallback(future2, (FutureCallback)new FutureCallback<AndroidDebugBridge>(){

            public void onSuccess(AndroidDebugBridge bridge) {
                Optional<IDevice> device2 = Arrays.stream(bridge.getDevices()).findFirst();
                if (device2.isEmpty()) {
                    AndroidLogcatToolWindowFactory.this.thisLogger().info("Device not found: " + serialNumber);
                    return;
                }
                AndroidLogcatToolWindowFactory.this.showLogcat(toolWindow, device2.get(), applicationId2);
            }

            public void onFailure(@NotNull Throwable t) {
                AndroidLogcatToolWindowFactory.this.thisLogger().warn("Failed to show Logcat for device " + serialNumber, t);
            }
        }, (Executor)EdtExecutorService.getInstance());
    }

    private void showLogcat(@NotNull ToolWindow toolWindow, @NotNull IDevice device2, @Nullable String applicationId2) {
        EventQueue.invokeLater(() -> toolWindow.activate(() -> {
            int count2 = toolWindow.getContentManager().getContentCount();
            for (int i = 0; i < count2; ++i) {
                DevicePanel devicePanel;
                Content content2 = toolWindow.getContentManager().getContent(i);
                DevicePanel devicePanel2 = devicePanel = content2 == null ? null : (DevicePanel)content2.getUserData(DEVICES_PANEL_KEY);
                if (devicePanel == null) continue;
                devicePanel.selectDevice(device2);
                if (applicationId2 == null) break;
                devicePanel.selectClient(device2.getClient(applicationId2));
                break;
            }
        }));
    }

    @NotNull
    public static String getToolWindowId() {
        return "Logcat";
    }

    private static void checkFacetAndSdk(Project project, @NotNull ConsoleView console) {
        List facets = ProjectFacetManager.getInstance((Project)project).getFacets(AndroidFacet.ID);
        if (facets.isEmpty()) {
            return;
        }
        AndroidFacet facet2 = (AndroidFacet)facets.get(0);
        AndroidPlatform platform = AndroidPlatform.getInstance(facet2.getModule());
        if (platform == null) {
            console.clear();
            Module module2 = facet2.getModule();
            console.print("Please ", ConsoleViewContentType.ERROR_OUTPUT);
            console.printHyperlink("configure", p -> AndroidSdkUtils.openModuleDependenciesConfigurable(module2));
            console.print(" Android SDK\n", ConsoleViewContentType.ERROR_OUTPUT);
        }
    }

    @NotNull
    private Logger thisLogger() {
        return Logger.getInstance(AndroidLogcatToolWindowFactory.class);
    }

    private static class MyAndroidPlatformListener
    implements ModuleRootListener {
        private final Project myProject;
        private final AndroidLogcatView myView;
        private AndroidPlatform myPrevPlatform;

        private MyAndroidPlatformListener(@NotNull AndroidLogcatView view) {
            this.myProject = view.getProject();
            this.myView = view;
            this.myPrevPlatform = this.getPlatform();
        }

        public void rootsChanged(@NotNull ModuleRootEvent event) {
            ToolWindow window2 = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(AndroidLogcatToolWindowFactory.getToolWindowId());
            if (window2 == null) {
                return;
            }
            if (window2.isDisposed() || !window2.isVisible()) {
                return;
            }
            AndroidPlatform newPlatform = this.getPlatform();
            if (!Objects.equals(this.myPrevPlatform, newPlatform)) {
                this.myPrevPlatform = newPlatform;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (!window2.isDisposed() && window2.isVisible()) {
                        this.myView.activate();
                    }
                });
            }
        }

        @Nullable
        private AndroidPlatform getPlatform() {
            AndroidPlatform newPlatform = null;
            List facets = ProjectFacetManager.getInstance((Project)this.myProject).getFacets(AndroidFacet.ID);
            if (!facets.isEmpty()) {
                AndroidFacet facet2 = (AndroidFacet)facets.get(0);
                newPlatform = AndroidPlatform.getInstance(facet2.getModule());
            }
            return newPlatform;
        }
    }

    private static final class MyToolWindowManagerListener
    implements ToolWindowManagerListener {
        private final Project myProject;
        private final AndroidLogcatView myLogcatView;
        private boolean myToolWindowVisible;

        private MyToolWindowManagerListener(@NotNull Project project, @NotNull AndroidLogcatView logcatView) {
            this.myProject = project;
            this.myLogcatView = logcatView;
        }

        public void stateChanged(@NotNull ToolWindowManager toolWindowManager) {
            ToolWindow window2 = toolWindowManager.getToolWindow("Logcat");
            if (window2 == null) {
                return;
            }
            boolean visible = window2.isVisible();
            if (this.myToolWindowVisible == visible) {
                return;
            }
            this.myToolWindowVisible = visible;
            this.myLogcatView.activate();
            if (!visible) {
                return;
            }
            ConsoleView consoleView = this.myLogcatView.getLogConsole().getConsole();
            if (consoleView == null) {
                return;
            }
            AndroidLogcatToolWindowFactory.checkFacetAndSdk(this.myProject, consoleView);
        }
    }
}

