/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.AdbCommandRejectedException;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellEnabledDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.Log;
import com.android.ddmlib.MultiLineReceiver;
import com.android.ddmlib.ShellCommandUnresponsiveException;
import com.android.ddmlib.TimeoutException;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.IdeInfo;
import com.android.tools.idea.logcat.AndroidLogcatReceiver;
import com.android.tools.idea.logcat.LoggingReceiver;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import java.io.EOFException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@ThreadSafe
public final class AndroidLogcatService
implements AndroidDebugBridge.IDeviceChangeListener,
Disposable {
    private final Object myLock = new Object();
    @GuardedBy(value="myLock")
    private final Map<IDevice, AndroidLogcatReceiver> myLogReceivers = new HashMap<IDevice, AndroidLogcatReceiver>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, LogcatBuffer> myLogBuffers = new HashMap<IDevice, LogcatBuffer>();
    @GuardedBy(value="myLock")
    private final Map<IDevice, ExecutorService> myExecutors = new HashMap<IDevice, ExecutorService>();
    @GuardedBy(value="myLock")
    private final Multimap<IDevice, ListenerConnector> myDeviceToListenerMultimap = ArrayListMultimap.create();

    private static Logger getLog() {
        return Logger.getInstance(AndroidLogcatService.class);
    }

    @NotNull
    public static AndroidLogcatService getInstance() {
        return (AndroidLogcatService)ApplicationManager.getApplication().getService(AndroidLogcatService.class);
    }

    @TestOnly
    AndroidLogcatService() {
        AndroidDebugBridge.addDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startReceiving(@NotNull IDevice device2) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device2)) {
                return;
            }
            this.connect(device2);
            AndroidLogcatReceiver receiver2 = this.newAndroidLogcatReceiver(device2);
            Disposer.register((Disposable)this, (Disposable)receiver2);
            this.myLogReceivers.put(device2, receiver2);
            this.myLogBuffers.put(device2, new LogcatBuffer());
            this.myExecutors.get(device2).submit(() -> {
                String filename = System.getProperty("studio.logcat.debug.readFromFile");
                if (filename != null && SystemInfo.isUnix) {
                    AndroidLogcatService.executeDebugLogcatFromFile(filename, (IShellOutputReceiver)receiver2);
                } else {
                    AndroidLogcatService.executeLogcat((IShellEnabledDevice)device2, receiver2);
                }
            });
        }
    }

    @NotNull
    private AndroidLogcatReceiver newAndroidLogcatReceiver(final @NotNull IDevice device2) {
        return new AndroidLogcatReceiver(device2, new LogcatListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void onLogLineReceived(@NotNull LogCatMessage line2) {
                ImmutableList connectors;
                Object object = AndroidLogcatService.this.myLock;
                synchronized (object) {
                    connectors = ImmutableList.copyOf((Collection)AndroidLogcatService.this.myDeviceToListenerMultimap.get((Object)device2));
                    LogcatBuffer buffer = AndroidLogcatService.this.myLogBuffers.get(device2);
                    if (buffer != null) {
                        buffer.addMessage(line2);
                    }
                }
                connectors.forEach(connector -> connector.onLogLineReceived(line2));
            }
        });
    }

    private static void executeLogcat(@NotNull IShellEnabledDevice device2, @NotNull AndroidLogcatReceiver receiver2) {
        try {
            AndroidLogcatService.execute(device2, AndroidLogcatService.supportsEpochFormatModifier(device2) ? "logcat -v long -v epoch" : "logcat -v long", receiver2, Duration.ZERO);
        }
        catch (EOFException e) {
            AndroidLogcatService.getLog().info("Logcat process terminated");
        }
        catch (Throwable throwable) {
            AndroidLogcatService.getLog().warn(throwable);
            String app = IdeInfo.getInstance().isAndroidStudio() ? "com.android.studio" : "com.jetbrains.idea";
            receiver2.notifyLogcatMessage(new LogCatHeader(Log.LogLevel.ERROR, 0, 0, app, "AndroidLogcatService", Instant.now()), throwable.toString());
        }
    }

    private static void executeDebugLogcatFromFile(@NotNull String filename, IShellOutputReceiver receiver2) {
        if (!new File(filename).exists()) {
            AndroidLogcatService.getLog().warn(String.format("Failed to load logcat from %s. File does not exist", filename));
        }
        try {
            Process process2 = new ProcessBuilder("tail", "-n", "+1", "-f", filename).start();
            InputStream inputStream = process2.getInputStream();
            byte[] buf = new byte[16384];
            while (!receiver2.isCancelled()) {
                if (inputStream.available() > 0) {
                    int n = inputStream.read(buf);
                    if (n < 0) break;
                    receiver2.addOutput(buf, 0, n);
                    continue;
                }
                Thread.sleep(25L);
            }
            receiver2.flush();
        }
        catch (IOException e) {
            AndroidLogcatService.getLog().warn("Failed to load logcat from " + filename);
        }
        catch (InterruptedException e) {
            AndroidLogcatService.getLog().warn("Logcat loading from file interrupted");
        }
    }

    private static boolean supportsEpochFormatModifier(@NotNull IShellEnabledDevice device2) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        LogcatHelpReceiver receiver2 = new LogcatHelpReceiver();
        device2.executeShellCommand("logcat --help", (IShellOutputReceiver)receiver2, 10L, TimeUnit.SECONDS);
        return receiver2.mySupportsEpochFormatModifier;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connect(@NotNull IDevice device2) {
        Object object = this.myLock;
        synchronized (object) {
            if (!this.myExecutors.containsKey(device2)) {
                ThreadFactory factory2 = new ThreadFactoryBuilder().setNameFormat("Android Logcat Service Thread %s for Device Serial Number " + device2).build();
                this.myExecutors.put(device2, Executors.newSingleThreadExecutor(factory2));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void disconnect(@NotNull IDevice device2) {
        Object object = this.myLock;
        synchronized (object) {
            this.stopReceiving(device2);
            this.myExecutors.remove(device2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopReceiving(@NotNull IDevice device2) {
        Object object = this.myLock;
        synchronized (object) {
            if (this.myLogReceivers.containsKey(device2)) {
                AndroidLogcatReceiver receiver2 = this.myLogReceivers.get(device2);
                receiver2.cancel();
                Disposer.dispose((Disposable)receiver2);
                this.myLogReceivers.remove(device2);
                this.myLogBuffers.remove(device2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearLogcat(@NotNull IDevice device2, @NotNull Project project) {
        Object object = this.myLock;
        synchronized (object) {
            ExecutorService executor2 = this.myExecutors.get(device2);
            if (executor2 == null) {
                this.notifyThatLogcatWasCleared(device2);
                return;
            }
            this.stopReceiving(device2);
            executor2.submit(() -> {
                try {
                    AndroidLogcatService.execute((IShellEnabledDevice)device2, "logcat -c", new LoggingReceiver(AndroidLogcatService.getLog()), Duration.ofSeconds(5L));
                }
                catch (Exception exception) {
                    AndroidLogcatService.getLog().warn((Throwable)exception);
                    ApplicationManager.getApplication().invokeLater(() -> Notifications.Bus.notify((Notification)new Notification("Logcat", AndroidBundle.message("android.logcat.error.title", new Object[0]), AndroidBundle.message("android.logcat.error.clearLogcat", new Object[0]), NotificationType.ERROR)));
                }
                this.notifyThatLogcatWasCleared(device2);
            });
            this.startReceiving(device2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyThatLogcatWasCleared(@NotNull IDevice device2) {
        ImmutableList connectors;
        Object object = this.myLock;
        synchronized (object) {
            connectors = ImmutableList.copyOf((Collection)this.myDeviceToListenerMultimap.get((Object)device2));
        }
        connectors.forEach(ListenerConnector::onCleared);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(@NotNull IDevice device2, @NotNull LogcatListener listener2, boolean addOldLogs) {
        Object object = this.myLock;
        synchronized (object) {
            ImmutableList oldMessages = addOldLogs && this.myLogBuffers.containsKey(device2) ? this.myLogBuffers.get(device2).getMessages() : ImmutableList.of();
            ListenerConnector listenerConnector = new ListenerConnector(listener2, (Collection<LogCatMessage>)oldMessages);
            this.myDeviceToListenerMultimap.put((Object)device2, (Object)listenerConnector);
            if (device2.isOnline()) {
                this.startReceiving(device2);
            }
            if (!oldMessages.isEmpty()) {
                ExecutorService executor2 = this.myExecutors.get(device2);
                assert (executor2 != null);
                executor2.submit(listenerConnector::processBacklog);
            }
        }
    }

    public void addListener(@NotNull IDevice device2, @NotNull LogcatListener listener2) {
        this.addListener(device2, listener2, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeListener(@NotNull IDevice device2, @NotNull LogcatListener listener2) {
        Object object = this.myLock;
        synchronized (object) {
            Collection connectors = this.myDeviceToListenerMultimap.get((Object)device2);
            if (connectors.isEmpty()) {
                return;
            }
            Iterator iter = connectors.iterator();
            while (iter.hasNext()) {
                ListenerConnector connector = (ListenerConnector)iter.next();
                if (!connector.isConnectedTo(listener2)) continue;
                connector.disconnectListener();
                iter.remove();
                break;
            }
            if (connectors.isEmpty()) {
                this.stopReceiving(device2);
                this.myDeviceToListenerMultimap.removeAll((Object)device2);
            }
        }
    }

    public void deviceConnected(@NotNull IDevice device2) {
        if (device2.isOnline()) {
            this.startReceiving(device2);
        }
    }

    public void deviceDisconnected(@NotNull IDevice device2) {
        this.disconnect(device2);
    }

    public void deviceChanged(@NotNull IDevice device2, int changeMask) {
        if ((changeMask & 1) == 0) {
            return;
        }
        if (device2.isOnline()) {
            this.startReceiving(device2);
        } else {
            this.disconnect(device2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        AndroidDebugBridge.removeDeviceChangeListener((AndroidDebugBridge.IDeviceChangeListener)this);
        Object object = this.myLock;
        synchronized (object) {
            for (AndroidLogcatReceiver receiver2 : this.myLogReceivers.values()) {
                receiver2.cancel();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    public void shutdown() {
        Disposer.dispose((Disposable)this);
        Object object = this.myLock;
        synchronized (object) {
            this.myExecutors.values().forEach(executor2 -> {
                try {
                    executor2.shutdownNow();
                    boolean terminated = executor2.awaitTermination(5000L, TimeUnit.MILLISECONDS);
                    if (!terminated) {
                        AndroidLogcatService.getLog().info("Timed out shutting down executor");
                    }
                }
                catch (InterruptedException e) {
                    AndroidLogcatService.getLog().info("Error shutting down executor", (Throwable)e);
                }
            });
        }
    }

    private static void execute(@NotNull IShellEnabledDevice device2, @NotNull String command2, @NotNull AndroidOutputReceiver receiver2, @NotNull Duration duration2) throws TimeoutException, AdbCommandRejectedException, ShellCommandUnresponsiveException, IOException {
        device2.executeShellCommand(command2, (IShellOutputReceiver)receiver2, duration2.toMillis(), TimeUnit.MILLISECONDS);
        if (receiver2.isCancelled()) {
            return;
        }
        receiver2.invalidate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestOnly
    void waitForIdle(IDevice device2) throws InterruptedException {
        AndroidLogcatReceiver receiver2;
        Object object = this.myLock;
        synchronized (object) {
            receiver2 = this.myLogReceivers.get(device2);
        }
        receiver2.waitForIdle();
    }

    private static final class LogcatHelpReceiver
    extends MultiLineReceiver {
        private boolean mySupportsEpochFormatModifier;
        private boolean myCancelled;

        private LogcatHelpReceiver() {
        }

        public void processNewLines(String[] lines2) {
            if (this.mySupportsEpochFormatModifier) {
                this.myCancelled = true;
                return;
            }
            this.mySupportsEpochFormatModifier = Arrays.stream(lines2).anyMatch(line2 -> line2.contains("epoch"));
        }

        public boolean isCancelled() {
            return this.myCancelled;
        }
    }

    public static interface LogcatListener {
        default public void onLogLineReceived(@NotNull LogCatMessage line2) {
        }

        default public void onCleared() {
        }
    }

    private static class ListenerConnector
    implements LogcatListener {
        @GuardedBy(value="myListenerLock")
        @Nullable
        private LogcatListener myListener;
        @GuardedBy(value="myBacklogLock")
        @Nullable
        private Queue<LogCatMessage> myBacklog;
        @NotNull
        private final Object myListenerLock = new Object();
        @NotNull
        private final Object myBacklogLock = new Object();

        ListenerConnector(@NotNull LogcatListener listener2, @NotNull Collection<LogCatMessage> messageBacklog) {
            this.myListener = listener2;
            this.myBacklog = messageBacklog.isEmpty() ? null : new ArrayDeque<LogCatMessage>(messageBacklog);
        }

        @Override
        public void onLogLineReceived(@NotNull LogCatMessage message2) {
            this.processBacklog();
            this.dispatchMessage(message2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onCleared() {
            Object object = this.myBacklogLock;
            synchronized (object) {
                this.myBacklog = null;
            }
            object = this.myListenerLock;
            synchronized (object) {
                if (this.myListener != null) {
                    this.myListener.onCleared();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean isConnectedTo(@NotNull LogcatListener listener2) {
            Object object = this.myListenerLock;
            synchronized (object) {
                return listener2 == this.myListener;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void disconnectListener() {
            Object object = this.myListenerLock;
            synchronized (object) {
                this.myListener = null;
            }
            object = this.myBacklogLock;
            synchronized (object) {
                this.myBacklog = null;
            }
        }

        void processBacklog() {
            LogCatMessage message2;
            while ((message2 = this.getMessageFromBacklog()) != null) {
                this.dispatchMessage(message2);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void dispatchMessage(@NotNull LogCatMessage message2) {
            Object object = this.myListenerLock;
            synchronized (object) {
                if (this.myListener != null) {
                    this.myListener.onLogLineReceived(message2);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Nullable
        private LogCatMessage getMessageFromBacklog() {
            Object object = this.myBacklogLock;
            synchronized (object) {
                if (this.myBacklog == null) {
                    return null;
                }
                LogCatMessage message2 = this.myBacklog.remove();
                if (this.myBacklog.isEmpty()) {
                    this.myBacklog = null;
                }
                return message2;
            }
        }
    }

    private static class LogcatBuffer {
        private int myBufferSize;
        private final LinkedList<LogCatMessage> myMessages = new LinkedList();

        private LogcatBuffer() {
        }

        public void addMessage(@NotNull LogCatMessage message2) {
            this.myMessages.add(message2);
            this.myBufferSize += message2.getMessage().length();
            if (ConsoleBuffer.useCycleBuffer()) {
                while (this.myBufferSize > ConsoleBuffer.getCycleBufferSize()) {
                    this.myBufferSize -= this.myMessages.removeFirst().getMessage().length();
                }
            }
        }

        @NotNull
        public List<LogCatMessage> getMessages() {
            return this.myMessages;
        }
    }
}

