/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatHeaderParser;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.SafeAlarm;
import com.android.tools.idea.logcat.StackTraceExpander;
import com.google.common.util.concurrent.MoreExecutors;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Alarm;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.regex.Pattern;
import org.jetbrains.android.util.AndroidOutputReceiver;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

public final class AndroidLogcatReceiver
extends AndroidOutputReceiver
implements Disposable {
    @VisibleForTesting
    static final int DELAY_MILLIS = 100;
    private static final String STACK_TRACE_LINE_PREFIX = StringUtil.repeatSymbol((char)' ', (int)4);
    private static final String STACK_TRACE_CAUSE_LINE_PREFIX = Character.toString(' ');
    private static final Pattern CARRIAGE_RETURN = Pattern.compile("\r", 16);
    @NotNull
    private final LogCatHeaderParser myLogCatHeaderParser;
    @NotNull
    private final IDevice myDevice;
    @NotNull
    private final StackTraceExpander myStackTraceExpander;
    @NotNull
    private final AndroidLogcatService.LogcatListener myLogcatListener;
    private volatile boolean myCanceled;
    @NotNull
    private final Executor mySequentialExecutor = MoreExecutors.newSequentialExecutor((Executor)AppExecutorUtil.getAppExecutorService());
    @NotNull
    private final SafeAlarm myAlarm;
    @Nullable
    private LogCatHeader myPreviousHeader;
    @NotNull
    private @NotNull List<@NotNull String> myPreviousLines = new ArrayList<String>();
    @Nullable
    private LogCatMessage myPendingMessage;

    AndroidLogcatReceiver(@NotNull IDevice device2, @NotNull AndroidLogcatService.LogcatListener listener2) {
        this.myLogCatHeaderParser = new LogCatHeaderParser();
        this.myDevice = device2;
        this.myStackTraceExpander = new StackTraceExpander(STACK_TRACE_LINE_PREFIX, STACK_TRACE_CAUSE_LINE_PREFIX);
        this.myLogcatListener = listener2;
        this.myAlarm = new SafeAlarm(Alarm.ThreadToUse.POOLED_THREAD, this);
    }

    @Override
    protected void processNewLines(@NotNull @NotNull List<@NotNull String> newLines) {
        AndroidLogcatReceiver.executeAndWait(this.mySequentialExecutor, () -> {
            this.myPendingMessage = null;
            Batch batch = this.parseNewLines(this.myPreviousHeader, this.myPreviousLines, newLines);
            for (LogCatMessage message2 : batch.myMessages) {
                this.myLogcatListener.onLogLineReceived(message2);
            }
            this.myPreviousHeader = batch.myLastHeader;
            this.myPreviousLines = batch.myLastLines;
            if (this.myPreviousHeader != null && !this.myPreviousLines.isEmpty()) {
                this.myPendingMessage = new LogCatMessage(this.myPreviousHeader, AndroidLogcatReceiver.joinLines(this.myPreviousLines));
                this.myAlarm.addRequest(this::processPendingMessage, 100L);
            }
        });
    }

    private static void executeAndWait(Executor executor2, Runnable action2) {
        CountDownLatch latch = new CountDownLatch(1);
        executor2.execute(() -> {
            try {
                action2.run();
            }
            finally {
                latch.countDown();
            }
        });
        try {
            latch.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void processPendingMessage() {
        this.mySequentialExecutor.execute(() -> {
            if (this.myPendingMessage != null) {
                this.myLogcatListener.onLogLineReceived(this.myPendingMessage);
                this.myPendingMessage = null;
                this.myPreviousHeader = null;
                this.myPreviousLines.clear();
            }
        });
    }

    @VisibleForTesting
    Batch parseNewLines(@Nullable LogCatHeader activeHeader, @NotNull List<String> activeLines, @NotNull List<String> newLines) {
        ArrayList<LogCatMessage> batchMessages = new ArrayList<LogCatMessage>();
        for (String line2 : newLines) {
            LogCatHeader header = this.myLogCatHeaderParser.parseHeader(line2 = AndroidLogcatReceiver.fixLine(line2), this.myDevice);
            if (header != null) {
                this.myStackTraceExpander.reset();
                if (!activeLines.isEmpty()) {
                    if (activeHeader != null) {
                        batchMessages.add(new LogCatMessage(activeHeader, AndroidLogcatReceiver.joinLines(activeLines)));
                    }
                    activeLines.clear();
                }
                activeHeader = header;
                continue;
            }
            activeLines.addAll(this.myStackTraceExpander.process(line2));
        }
        return new Batch(batchMessages, activeHeader, activeLines);
    }

    void notifyLogcatMessage(@NotNull LogCatHeader header, @NotNull String msg) {
        this.myLogcatListener.onLogLineReceived(new LogCatMessage(header, msg));
    }

    @NotNull
    private static String joinLines(@NotNull @NotNull List<@NotNull String> activeLines) {
        return StringUtil.trim((String)String.join((CharSequence)"\n", activeLines), ch -> ch != '\n');
    }

    public boolean isCancelled() {
        return this.myCanceled;
    }

    public void dispose() {
        this.cancel();
    }

    public void cancel() {
        this.myCanceled = true;
    }

    @NotNull
    private static String fixLine(@NotNull String line2) {
        return CARRIAGE_RETURN.matcher(line2).replaceAll("");
    }

    @TestOnly
    void waitForIdle() throws InterruptedException {
        CountDownLatch latch = new CountDownLatch(1);
        this.mySequentialExecutor.execute(() -> this.myAlarm.addRequest(() -> this.mySequentialExecutor.execute(latch::countDown), 100L));
        latch.await();
    }

    @VisibleForTesting
    static final class Batch {
        final List<LogCatMessage> myMessages;
        final LogCatHeader myLastHeader;
        final List<String> myLastLines;

        private Batch(List<LogCatMessage> messages, LogCatHeader header, List<String> lines2) {
            this.myMessages = messages;
            this.myLastHeader = header;
            this.myLastLines = lines2;
        }
    }
}

