/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.LogcatHeaderFormat;
import com.android.tools.idea.logcat.LogcatJson;
import com.intellij.diagnostic.logging.DefaultLogFormatter;
import java.time.ZoneId;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;

public final class AndroidLogcatFormatter
extends DefaultLogFormatter {
    public static final String TAG_PATTERN_GROUP_NAME = "tag";
    public static final Pattern TAG_PATTERN = Pattern.compile(" [VDIWEA]/(?<tag>.*?): ");
    @NotNull
    private final ZoneId myTimeZone;
    private final AndroidLogcatPreferences myPreferences;

    public AndroidLogcatFormatter(@NotNull ZoneId timeZone, @NotNull AndroidLogcatPreferences preferences) {
        this.myTimeZone = timeZone;
        this.myPreferences = preferences;
    }

    @NotNull
    public String formatMessage(@NotNull String message2) {
        return this.formatMessage(LogcatJson.fromJson(message2));
    }

    @NotNull
    String formatMessage(@NotNull LogCatMessage message2) {
        return this.myPreferences.LOGCAT_HEADER_FORMAT.formatMessage(message2, this.myTimeZone);
    }

    @NotNull
    public String formatMessage(@NotNull LogcatHeaderFormat format, @NotNull LogCatHeader header, @NotNull String message2) {
        return format.formatMessage(new LogCatMessage(header, message2), this.myTimeZone);
    }
}

