/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.Log;
import com.android.ddmlib.logcat.LogCatHeader;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.AndroidLogcatFormatter;
import com.android.tools.idea.logcat.AndroidLogcatGlobalPreferences;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatUtils;
import com.android.tools.idea.logcat.LogcatJson;
import com.google.common.collect.ImmutableList;
import com.intellij.diagnostic.logging.LogFilter;
import com.intellij.diagnostic.logging.LogFilterListener;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AndroidLogFilterModel
extends LogFilterModel {
    private final List<LogFilterListener> myListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    @Nullable
    private LogCatHeader myPrevHeader;
    @Nullable
    private LogCatHeader myRejectBeforeHeader;
    @Nullable
    private Pattern myCustomPattern;
    @Nullable
    private AndroidLogcatFilter myConfiguredFilter;
    @NotNull
    private final ImmutableList<AndroidLogLevelFilter> myLogLevelFilters;
    @NotNull
    private final AndroidLogcatPreferences myPreferences;
    @NotNull
    private final AndroidLogcatGlobalPreferences myGlobalPreferences = AndroidLogcatGlobalPreferences.getInstance();
    @NotNull
    private final AndroidLogcatFormatter myFormatter;

    AndroidLogFilterModel(@NotNull AndroidLogcatFormatter formatter, @NotNull AndroidLogcatPreferences preferences) {
        ImmutableList.Builder builder2 = ImmutableList.builder();
        for (Log.LogLevel logLevel : Log.LogLevel.values()) {
            builder2.add((Object)new AndroidLogLevelFilter(logLevel));
        }
        this.myLogLevelFilters = builder2.build();
        this.myPreferences = preferences;
        this.myFormatter = formatter;
    }

    public String getCustomFilter() {
        return "";
    }

    public void updateCustomPattern(@Nullable Pattern pattern) {
        this.myCustomPattern = pattern;
        this.fireTextFilterChange();
    }

    public final void updateLogcatFilter(@Nullable AndroidLogcatFilter filter2) {
        this.myPreferences.TOOL_WINDOW_CONFIGURED_FILTER = filter2 != null ? filter2.getName() : "";
        this.myConfiguredFilter = filter2;
        this.fireTextFilterChange();
    }

    public final void addFilterListener(LogFilterListener listener2) {
        this.myListeners.add(listener2);
    }

    public final void removeFilterListener(LogFilterListener listener2) {
        this.myListeners.remove(listener2);
    }

    public void beginRejectingOldMessages() {
        if (this.myPrevHeader == null) {
            return;
        }
        this.myRejectBeforeHeader = this.myPrevHeader;
    }

    private void fireTextFilterChange() {
        for (LogFilterListener listener2 : this.myListeners) {
            listener2.onTextFilterChange();
        }
    }

    private void fireFilterChange(@NotNull LogFilter filter2) {
        for (LogFilterListener listener2 : this.myListeners) {
            listener2.onFilterStateChange(filter2);
        }
    }

    public final boolean isApplicable(@Nullable String line2) {
        if (line2 == null) {
            return false;
        }
        return this.isApplicable(LogcatJson.fromJson(line2));
    }

    private boolean isApplicable(@NotNull LogCatMessage logCatMessage) {
        if (((Boolean)StudioFlags.LOGCAT_SUPPRESSED_TAGS_ENABLE.get()).booleanValue() && this.myGlobalPreferences.getSuppressedLogTags().contains(logCatMessage.getHeader().getTag())) {
            return false;
        }
        if (this.myCustomPattern != null && !this.myCustomPattern.matcher(this.myFormatter.formatMessage(logCatMessage)).find()) {
            return false;
        }
        AndroidLogLevelFilter selectedLogLevelFilter = this.getSelectedLogLevelFilter();
        return selectedLogLevelFilter == null || selectedLogLevelFilter.isAcceptable(logCatMessage);
    }

    private boolean isApplicableByConfiguredFilter(@NotNull LogCatMessage logCatMessage) {
        if (this.myConfiguredFilter == null) {
            return true;
        }
        return this.myConfiguredFilter.isApplicable(logCatMessage);
    }

    public final List<? extends LogFilter> getLogFilters() {
        return this.myLogLevelFilters;
    }

    @Nullable
    private AndroidLogLevelFilter getSelectedLogLevelFilter() {
        String filterName = this.myPreferences.TOOL_WINDOW_LOG_LEVEL;
        if (filterName != null) {
            for (AndroidLogLevelFilter logFilter : this.myLogLevelFilters) {
                if (!filterName.equals(logFilter.myLogLevel.getStringValue())) continue;
                return logFilter;
            }
        }
        return null;
    }

    public boolean isFilterSelected(LogFilter filter2) {
        return filter2 == this.getSelectedLogLevelFilter();
    }

    public void selectFilter(LogFilter filter2) {
        if (!(filter2 instanceof AndroidLogLevelFilter)) {
            return;
        }
        String newFilterName = ((AndroidLogLevelFilter)filter2).myLogLevel.getStringValue();
        if (!Objects.equals(newFilterName, this.myPreferences.TOOL_WINDOW_LOG_LEVEL)) {
            this.myPreferences.TOOL_WINDOW_LOG_LEVEL = newFilterName;
            this.fireFilterChange(filter2);
        }
    }

    public void processingStarted() {
        this.myRejectBeforeHeader = null;
    }

    @NotNull
    public final LogFilterModel.MyProcessingResult processLine(String line2) {
        LogCatHeader rejectBeforeHeader;
        boolean isApplicable;
        LogCatHeader header;
        LogCatMessage logCatMessage = LogcatJson.fromJson(line2);
        if (logCatMessage == null) {
            return new LogFilterModel.MyProcessingResult(ProcessOutputTypes.STDOUT, false, null);
        }
        this.myPrevHeader = header = logCatMessage.getHeader();
        boolean bl = isApplicable = this.isApplicable(logCatMessage) && this.isApplicableByConfiguredFilter(logCatMessage);
        if (isApplicable && (rejectBeforeHeader = this.myRejectBeforeHeader) != null) {
            isApplicable = !header.getTimestamp().isBefore(this.myRejectBeforeHeader.getTimestamp());
        }
        return new LogFilterModel.MyProcessingResult(AndroidLogcatUtils.getProcessOutputType(header.getLogLevel()), isApplicable, null);
    }

    private static final class AndroidLogLevelFilter
    extends LogFilter {
        final Log.LogLevel myLogLevel;

        private AndroidLogLevelFilter(Log.LogLevel logLevel) {
            super(StringUtil.capitalize((String)logLevel.getStringValue()));
            this.myLogLevel = logLevel;
        }

        public boolean isAcceptable(@Nullable String line2) {
            if (line2 == null) {
                return false;
            }
            return this.isAcceptable(LogcatJson.fromJson(line2));
        }

        public boolean isAcceptable(@NotNull LogCatMessage logCatMessage) {
            return logCatMessage.getHeader().getLogLevel().getPriority() >= this.myLogLevel.getPriority();
        }
    }
}

