/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.logcat;

import com.android.ddmlib.IDevice;
import com.android.tools.idea.actions.BrowserHelpAction;
import com.android.tools.idea.ddms.DeviceContext;
import com.android.tools.idea.ddms.actions.DeviceScreenshotAction;
import com.android.tools.idea.ddms.actions.ScreenRecorderAction;
import com.android.tools.idea.ddms.actions.TerminateVMAction;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.logcat.AndroidLogFilterModel;
import com.android.tools.idea.logcat.AndroidLogcatPreferences;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.logcat.AndroidLogcatView;
import com.android.tools.idea.logcat.RegexFilterComponent;
import com.android.tools.idea.logcat.SuppressLogTagsAction;
import com.intellij.diagnostic.logging.LogConsoleBase;
import com.intellij.diagnostic.logging.LogFilterModel;
import com.intellij.diagnostic.logging.LogFormatter;
import com.intellij.execution.impl.ConsoleViewImpl;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.Separator;
import com.intellij.openapi.extensions.PluginId;
import com.intellij.openapi.project.Project;
import com.intellij.psi.search.GlobalSearchScope;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class AndroidLogConsole
extends LogConsoleBase {
    private static final String ACTION_ID_PREFIX = AndroidLogConsole.class.getSimpleName() + ".";
    private static final PluginId PLUGIN_ID = PluginId.getId((String)"org.jetbrains.android");
    private final AndroidLogcatView myView;
    private final RegexFilterComponent myRegexFilterComponent = new RegexFilterComponent("LOG_FILTER_HISTORY", 5);
    private final AndroidLogcatPreferences myPreferences;
    @NotNull
    private final Project myProject;

    AndroidLogConsole(@NotNull Project project, @NotNull AndroidLogFilterModel model2, @NotNull LogFormatter formatter, @NotNull AndroidLogcatView view) {
        super(project, null, "", false, (LogFilterModel)model2, GlobalSearchScope.allScope((Project)project), formatter);
        this.myProject = project;
        ConsoleView console = this.getConsole();
        ActionManager actionManager = ActionManager.getInstance();
        if (console instanceof ConsoleViewImpl) {
            ConsoleViewImpl c = (ConsoleViewImpl)console;
            DeviceContext context2 = view.getDeviceContext();
            c.addCustomConsoleAction((AnAction)new Separator());
            c.addCustomConsoleAction(AndroidLogConsole.registerAction(actionManager, new AndroidLogcatView.MyRestartAction(view)));
            c.addCustomConsoleAction(AndroidLogConsole.registerAction(actionManager, new AndroidLogcatView.MyConfigureLogcatHeaderAction(view)));
            if (((Boolean)StudioFlags.LOGCAT_SUPPRESSED_TAGS_ENABLE.get()).booleanValue()) {
                c.addCustomConsoleAction(AndroidLogConsole.registerAction(actionManager, new SuppressLogTagsAction(context2, this::refresh)));
            }
            c.addCustomConsoleAction((AnAction)new Separator());
            c.addCustomConsoleAction(AndroidLogConsole.registerAction(actionManager, new DeviceScreenshotAction(project, context2)));
            c.addCustomConsoleAction(AndroidLogConsole.registerAction(actionManager, new ScreenRecorderAction(project, context2)));
            c.addCustomConsoleAction((AnAction)new Separator());
            c.addCustomConsoleAction(AndroidLogConsole.registerAction(actionManager, new TerminateVMAction(context2)));
            c.addCustomConsoleAction((AnAction)new Separator());
            c.addCustomConsoleAction(AndroidLogConsole.registerAction(actionManager, new BrowserHelpAction("logcat", "http://developer.android.com/r/studio-ui/am-logcat.html")));
        }
        this.myView = view;
        this.myPreferences = AndroidLogcatPreferences.getInstance(project);
        this.myRegexFilterComponent.setFilter(this.myPreferences.TOOL_WINDOW_CUSTOM_FILTER);
        this.myRegexFilterComponent.setIsRegex(this.myPreferences.TOOL_WINDOW_REGEXP_FILTER);
        this.myRegexFilterComponent.addRegexListener(filter2 -> {
            this.myPreferences.TOOL_WINDOW_CUSTOM_FILTER = filter2.getFilter();
            this.myPreferences.TOOL_WINDOW_REGEXP_FILTER = filter2.isRegex();
            model2.updateCustomPattern(filter2.getPattern());
        });
    }

    @NotNull
    public Project getProject() {
        return this.myProject;
    }

    static AnAction registerAction(ActionManager actionManager, AnAction action2) {
        String id2 = ACTION_ID_PREFIX + action2.getClass().getSimpleName();
        if (actionManager.getAction(id2) != null) {
            actionManager.unregisterAction(id2);
        }
        actionManager.registerAction(id2, action2, PLUGIN_ID);
        return action2;
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public void dispose() {
        super.dispose();
        ActionManager actionManager = ActionManager.getInstance();
        @NonNls List actions2 = actionManager.getActionIdList(ACTION_ID_PREFIX);
        for (String action2 : actions2) {
            actionManager.unregisterAction(action2);
        }
    }

    public boolean isActive() {
        return this.myView.isActive();
    }

    @Nullable
    public IDevice getSelectedDevice() {
        return this.myView.getSelectedDevice();
    }

    public void clearLogcat() {
        IDevice device2 = this.myView.getSelectedDevice();
        if (device2 == null) {
            return;
        }
        AndroidLogcatService.getInstance().clearLogcat(device2, this.myView.getProject());
    }

    @NotNull
    public Component getLogFilterComboBox() {
        JComponent component2 = this.getSearchComponent();
        assert (component2 != null);
        return component2.getComponent(0);
    }

    @NotNull
    public Component getTextFilterComponent() {
        return this.myRegexFilterComponent;
    }

    public void addLogLine(@NotNull String line2) {
        super.addMessage(line2);
    }

    public void refresh() {
        this.onTextFilterChange();
    }
}

