/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.AndroidPsiUtils;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.lint.checks.FontDetector;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UpgradeAppCompatV7Fix
extends DefaultLintQuickFix {
    public UpgradeAppCompatV7Fix() {
        super("Upgrade appcompat-v7 to recommended version");
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
        Module module2 = AndroidPsiUtils.getModuleSafely((PsiElement)startElement);
        UpgradeAppCompatV7Fix.apply(module2);
    }

    public static void apply(@Nullable Module module2) {
        if (module2 != null) {
            LintIdeSupport.get().updateToLatest(module2, FontDetector.MIN_APPSUPPORT_VERSION);
        }
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return true;
    }
}

