/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParcelableQuickFix
extends DefaultLintQuickFix {
    private static final String CREATOR = "public static final android.os.Parcelable.Creator<%1$s> CREATOR = new android.os.Parcelable.Creator<%1$s>() {\n  @Override\n  public %1$s createFromParcel(android.os.Parcel in) {\n    return new %1$s(in);\n  }\n\n  @Override\n  public %1$s[] newArray(int size) {\n    return new %1$s[size];\n  }\n};\n";
    private static final String CONSTRUCTOR = "protected %1$s(android.os.Parcel in) {\n}\n";
    private static final String CONSTRUCTOR_WITH_SUPER = "protected %1$s(android.os.Parcel in) {\n  super(in);\n}\n";
    private static final String DESCRIBE_CONTENTS = "@Override\npublic int describeContents() {\n  return 0;\n}\n";
    private static final String WRITE_TO_PARCEL = "@Override\npublic void writeToParcel(android.os.Parcel dest, int flags) {\n}\n";
    private static final String WRITE_TO_PARCEL_WITH_SUPER = "@Override\npublic void writeToParcel(android.os.Parcel dest, int flags) {\n  super.writeToParcel(dest, flags);\n}\n";
    private static final String CLASS_T = "T";
    private static final String CLASS_T_ARRAY = "T[]";
    private final Operation myOperation;

    public ParcelableQuickFix(String name, Operation operation) {
        super(name);
        this.myOperation = operation;
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        PsiClass parcelable = this.getClassOfSupportedElement(startElement);
        if (parcelable == null || ParcelableQuickFix.findParcelableFromImplementsList(parcelable) == null) {
            return false;
        }
        switch (this.myOperation) {
            case IMPLEMENT: {
                return parcelable.findFieldByName("CREATOR", false) == null;
            }
            case REIMPLEMENT: {
                return parcelable.findFieldByName("CREATOR", false) != null;
            }
            case REMOVE: {
                return true;
            }
        }
        return false;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
        PsiClass parcelable = this.getClassOfSupportedElement(startElement);
        if (parcelable == null) {
            return;
        }
        QuickFixWorker worker = new QuickFixWorker(parcelable);
        switch (this.myOperation) {
            case IMPLEMENT: {
                worker.implement();
                break;
            }
            case REMOVE: {
                worker.remove();
                break;
            }
            case REIMPLEMENT: {
                worker.reimplement();
            }
        }
    }

    @Nullable
    private PsiClass getClassOfSupportedElement(@NotNull PsiElement element2) {
        PsiJavaCodeReferenceElement reference;
        if (element2 instanceof PsiIdentifier && element2.getParent() instanceof PsiClass) {
            return (PsiClass)element2.getParent();
        }
        if (element2 instanceof PsiClass && this.myOperation != Operation.IMPLEMENT) {
            return (PsiClass)element2;
        }
        if (element2 instanceof PsiJavaCodeReferenceElement && (reference = (PsiJavaCodeReferenceElement)element2).getCanonicalText().equals("android.os.Parcelable") && reference.getParent() instanceof PsiReferenceList && reference.getParent().getParent() instanceof PsiClass) {
            return (PsiClass)reference.getParent().getParent();
        }
        return null;
    }

    @Nullable
    private static PsiElement findParcelableFromImplementsList(@NotNull PsiClass parcelable) {
        PsiReferenceList implementsList = parcelable.getImplementsList();
        if (implementsList != null) {
            for (PsiJavaCodeReferenceElement element2 : implementsList.getReferenceElements()) {
                if (!"android.os.Parcelable".equals(element2.getQualifiedName())) continue;
                return element2;
            }
        }
        return null;
    }

    private static class ShortOrCharObjectFieldPersistence
    implements QuickFixWorker.FieldPersistence {
        private String myCast;

        public ShortOrCharObjectFieldPersistence(String cast) {
            this.myCast = cast;
        }

        @Override
        public String[] formatWrite(@NotNull PsiField field2, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
            return new String[]{String.format("%1$s.writeInt(%2$s != null ? (int)%2$s : Integer.MAX_VALUE);", parcelVariableName, field2.getName())};
        }

        @Override
        public String[] formatRead(@NotNull PsiField field2, @NotNull String parcelVariableName) {
            String fieldName = field2.getName();
            assert (fieldName != null);
            String var = "tmp" + StringUtil.capitalize((String)fieldName);
            return new String[]{String.format("int %1$s = %2$s.readInt();", var, parcelVariableName), String.format("%1$s = %2$s != Integer.MAX_VALUE ? (%3$s) %2$s : null;", fieldName, var, this.myCast)};
        }
    }

    private static class ShortOrCharFieldPersistence
    implements QuickFixWorker.FieldPersistence {
        private String myCast;

        public ShortOrCharFieldPersistence(String cast) {
            this.myCast = cast;
        }

        @Override
        public String[] formatWrite(@NotNull PsiField field2, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
            return new String[]{String.format("%1$s.writeInt((int)%2$s);", parcelVariableName, field2.getName())};
        }

        @Override
        public String[] formatRead(@NotNull PsiField field2, @NotNull String parcelVariableName) {
            return new String[]{String.format("%1$s = (%2$s)%3$s.readInt();", field2.getName(), this.myCast, parcelVariableName)};
        }
    }

    private static class BooleanObjectFieldPersistence
    implements QuickFixWorker.FieldPersistence {
        private BooleanObjectFieldPersistence() {
        }

        @Override
        public String[] formatWrite(@NotNull PsiField field2, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
            return new String[]{String.format("%1$s.writeByte((byte)(%2$s == null ? 0 : %2$s ? 1 : 2));\n", parcelVariableName, field2.getName())};
        }

        @Override
        public String[] formatRead(@NotNull PsiField field2, @NotNull String parcelVariableName) {
            String fieldName = field2.getName();
            assert (fieldName != null);
            String var = "tmp" + StringUtil.capitalize((String)fieldName);
            return new String[]{String.format("byte %1$s = %2$s.readByte();", var, parcelVariableName), String.format("%1$s = %2$s == 0 ? null : %2$s == 1;\n", fieldName, var)};
        }
    }

    private static class QuickFixWorker {
        private final Project myProject;
        private final JavaPsiFacade myFacade;
        private final PsiElementFactory myFactory;
        private final PsiClass myParcelable;
        private final PsiClassType myParcelableType;
        private final PsiClassType myListType;
        private final PsiClass myList;
        private final PsiClassType myTType;
        private final PsiClassType myTArrayType;
        private final PsiClassType myTListType;
        private final Map<PsiType, FieldPersistence> myPersistenceMap;
        private final Set<String> myIgnoredMethods;

        private QuickFixWorker(@NotNull PsiClass parcelable) {
            this.myProject = parcelable.getProject();
            this.myFacade = JavaPsiFacade.getInstance((Project)this.myProject);
            this.myFactory = this.myFacade.getElementFactory();
            this.myParcelable = parcelable;
            this.myParcelableType = PsiType.getTypeByName((String)"android.os.Parcelable", (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            this.myListType = PsiType.getTypeByName((String)"java.util.List", (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            this.myList = this.myListType.resolve();
            assert (this.myList != null);
            this.myTType = PsiType.getTypeByName((String)ParcelableQuickFix.CLASS_T, (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            this.myTArrayType = PsiType.getTypeByName((String)ParcelableQuickFix.CLASS_T_ARRAY, (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject));
            this.myTListType = this.myFactory.createType(this.myList, (PsiType)this.myTType);
            this.myPersistenceMap = new HashMap<PsiType, FieldPersistence>();
            this.myIgnoredMethods = new HashSet<String>();
            this.populateIgnoredMethods();
            this.populateFieldPersistenceByType();
        }

        private void implement() {
            this.findOrCreateParcelableFromImplementsList();
            PsiMethod constructor = this.findOrCreateConstructor();
            this.addFieldReadsToConstructor(constructor);
            PsiMethod writeToParcel = this.findOrCreateWriteToParcel();
            this.addFieldWrites(writeToParcel);
            PsiMethod describeContents = this.findOrCreateDescribeContents();
            PsiField creator = this.findOrCreateCreator();
            PsiElement insertionPoint = this.findInsertionPoint();
            QuickFixWorker.addBefore((PsiElement)this.myParcelable, (PsiElement)constructor, insertionPoint);
            QuickFixWorker.addBefore((PsiElement)this.myParcelable, (PsiElement)writeToParcel, insertionPoint);
            QuickFixWorker.addBefore((PsiElement)this.myParcelable, (PsiElement)describeContents, insertionPoint);
            QuickFixWorker.addBefore((PsiElement)this.myParcelable, (PsiElement)creator, insertionPoint);
            this.save();
        }

        private void remove() {
            QuickFixWorker.delete((PsiElement)this.findConstructor());
            QuickFixWorker.delete((PsiElement)this.findWriteToParcel());
            QuickFixWorker.delete((PsiElement)this.findDescribeContents());
            QuickFixWorker.delete((PsiElement)this.findCreator());
            QuickFixWorker.delete(ParcelableQuickFix.findParcelableFromImplementsList(this.myParcelable));
            QuickFixWorker.delete(this.findImportOfClass("android.os.Parcel"));
            QuickFixWorker.delete(this.findImportOfClass("android.os.Parcelable"));
            this.save();
        }

        private void reimplement() {
            QuickFixWorker.delete((PsiElement)this.findConstructor());
            QuickFixWorker.delete((PsiElement)this.findWriteToParcel());
            QuickFixWorker.delete((PsiElement)this.findDescribeContents());
            QuickFixWorker.delete((PsiElement)this.findCreator());
            this.implement();
            this.save();
        }

        private void save() {
            Document document2;
            PsiFile file2 = this.myParcelable.getContainingFile();
            if (file2.isPhysical() && (document2 = FileDocumentManager.getInstance().getDocument(file2.getVirtualFile())) != null) {
                PsiDocumentManager.getInstance((Project)this.myProject).commitDocument(document2);
            }
        }

        @Nullable
        private PsiField findCreator() {
            return this.myParcelable.findFieldByName("CREATOR", false);
        }

        @NotNull
        private PsiField findOrCreateCreator() {
            PsiField field2 = this.findCreator();
            if (field2 == null) {
                field2 = this.myFactory.createFieldFromText(String.format(ParcelableQuickFix.CREATOR, this.myParcelable.getName()), (PsiElement)this.myParcelable);
            }
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)field2);
            return field2;
        }

        @Nullable
        private PsiMethod findConstructor() {
            for (PsiMethod method2 : this.myParcelable.getConstructors()) {
                if (!QuickFixWorker.isConstructorWithParcelParameter(method2)) continue;
                return method2;
            }
            return null;
        }

        @NotNull
        private PsiMethod findOrCreateConstructor() {
            PsiMethod method2 = this.findConstructor();
            if (method2 == null) {
                String fmt = this.doesSuperClassImplementParcelable() ? ParcelableQuickFix.CONSTRUCTOR_WITH_SUPER : ParcelableQuickFix.CONSTRUCTOR;
                method2 = this.createMethodWithShortClassReferences(String.format(fmt, this.myParcelable.getName()));
            }
            return method2;
        }

        @Nullable
        private PsiMethod findDescribeContents() {
            for (PsiMethod method2 : this.myParcelable.getMethods()) {
                PsiParameterList params2 = method2.getParameterList();
                if (!method2.getName().equals("describeContents") || params2.getParametersCount() != 0) continue;
                return method2;
            }
            return null;
        }

        @NotNull
        private PsiMethod findOrCreateDescribeContents() {
            PsiMethod method2 = this.findDescribeContents();
            if (method2 == null) {
                method2 = this.createMethodWithShortClassReferences(ParcelableQuickFix.DESCRIBE_CONTENTS);
            }
            return method2;
        }

        @Nullable
        private PsiMethod findWriteToParcel() {
            for (PsiMethod method2 : this.myParcelable.getMethods()) {
                if (!QuickFixWorker.isWriteToParcelMethod(method2)) continue;
                return method2;
            }
            return null;
        }

        @NotNull
        private PsiMethod findOrCreateWriteToParcel() {
            PsiMethod method2 = this.findWriteToParcel();
            if (method2 == null) {
                String text2 = this.doesSuperClassImplementParcelable() ? ParcelableQuickFix.WRITE_TO_PARCEL_WITH_SUPER : ParcelableQuickFix.WRITE_TO_PARCEL;
                method2 = this.createMethodWithShortClassReferences(text2);
            }
            return method2;
        }

        private void findOrCreateParcelableFromImplementsList() {
            PsiReferenceList implementsList;
            PsiElement element2 = ParcelableQuickFix.findParcelableFromImplementsList(this.myParcelable);
            if (element2 == null && (implementsList = this.myParcelable.getImplementsList()) != null) {
                PsiJavaCodeReferenceElement implementsParcelable = this.myFactory.createReferenceElementByFQClassName("android.os.Parcelable", this.myParcelable.getResolveScope());
                implementsList.add((PsiElement)implementsParcelable);
            }
        }

        @Nullable
        private PsiElement findImportOfClass(@NotNull String className) {
            PsiImportList importList;
            PsiFile file2 = this.myParcelable.getContainingFile();
            if (file2 != null && file2 instanceof PsiJavaFile && (importList = ((PsiJavaFile)file2).getImportList()) != null) {
                return importList.findSingleClassImportStatement(className);
            }
            return null;
        }

        private PsiMethod createMethodWithShortClassReferences(@NotNull String text2) {
            PsiMethod method2 = this.myFactory.createMethodFromText(text2, (PsiElement)this.myParcelable);
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)method2);
            return method2;
        }

        private static boolean isConstructorWithParcelParameter(@NotNull PsiMethod method2) {
            PsiParameterList params2 = method2.getParameterList();
            if (method2.isConstructor()) {
                PsiParameter parameter = params2.getParameter(0);
                return parameter != null && parameter.getType().equalsToText("android.os.Parcel");
            }
            return false;
        }

        private static boolean isWriteToParcelMethod(@NotNull PsiMethod method2) {
            PsiParameterList params2 = method2.getParameterList();
            return method2.getName().equals("writeToParcel") && params2.getParametersCount() == 2 && params2.getParameters()[0].getType().equalsToText("android.os.Parcel") && params2.getParameters()[1].getType().equalsToText(PsiType.INT.getCanonicalText());
        }

        private boolean doesSuperClassImplementParcelable() {
            PsiClass superClass = this.myParcelable.getSuperClass();
            if (superClass == null) {
                return false;
            }
            return ParcelableQuickFix.findParcelableFromImplementsList(superClass) != null;
        }

        private void addFieldReadsToConstructor(@NotNull PsiMethod constructor) {
            assert (QuickFixWorker.isConstructorWithParcelParameter(constructor));
            if (!this.isEmptyMethod(constructor)) {
                return;
            }
            this.removeInitialBlankLines(constructor);
            String paramName = constructor.getParameterList().getParameters()[0].getName();
            PsiCodeBlock body = constructor.getBody();
            assert (body != null);
            assert (paramName != null);
            for (PsiField field2 : this.myParcelable.getFields()) {
                FieldPersistence persistence = this.findFieldPersistence(field2);
                if (persistence == null) continue;
                this.createStatements(persistence.formatRead(field2, paramName), body, constructor);
            }
            JavaCodeStyleManager.getInstance((Project)this.myProject).shortenClassReferences((PsiElement)constructor);
        }

        private void addFieldWrites(@NotNull PsiMethod writeToParcel) {
            assert (QuickFixWorker.isWriteToParcelMethod(writeToParcel));
            if (!this.isEmptyMethod(writeToParcel)) {
                return;
            }
            this.removeInitialBlankLines(writeToParcel);
            String parcelName = writeToParcel.getParameterList().getParameters()[0].getName();
            String flagsName = writeToParcel.getParameterList().getParameters()[1].getName();
            PsiCodeBlock body = writeToParcel.getBody();
            assert (body != null);
            assert (parcelName != null);
            assert (flagsName != null);
            for (PsiField field2 : this.myParcelable.getFields()) {
                FieldPersistence persistence = this.findFieldPersistence(field2);
                if (persistence == null) continue;
                this.createStatements(persistence.formatWrite(field2, parcelName, flagsName), body, writeToParcel);
            }
        }

        private boolean isEmptyMethod(@NotNull PsiMethod method2) {
            int expectedStatementCount = this.doesSuperClassImplementParcelable() ? 1 : 0;
            return method2.getBody() == null || method2.getBody().getStatements().length <= expectedStatementCount;
        }

        private void removeInitialBlankLines(@NotNull PsiMethod method2) {
            PsiWhiteSpace whiteSpace = (PsiWhiteSpace)PsiTreeUtil.getChildOfType((PsiElement)method2.getBody(), PsiWhiteSpace.class);
            if (whiteSpace != null && whiteSpace.getText().startsWith("\n\n")) {
                method2.getBody().replace((PsiElement)this.myFactory.createCodeBlock());
            }
        }

        private void createStatements(@NotNull String[] stmtText, @NotNull PsiCodeBlock body, @NotNull PsiMethod method2) {
            for (String text2 : stmtText) {
                PsiStatement stmt = this.myFactory.createStatementFromText(text2, (PsiElement)method2);
                body.add((PsiElement)stmt);
            }
        }

        @Nullable
        private FieldPersistence findFieldPersistence(@NotNull PsiField field2) {
            String qualifiedName;
            PsiType elemType;
            if (field2.hasModifierProperty("transient") || field2.hasModifierProperty("static")) {
                return null;
            }
            PsiType type = field2.getType();
            FieldPersistence persistence = this.myPersistenceMap.get(type);
            if (persistence != null) {
                return persistence;
            }
            if (this.myParcelableType.isAssignableFrom(type.getDeepComponentType()) && !this.myParcelableType.equals((Object)type.getDeepComponentType())) {
                PsiArrayType arrayType;
                if (type.equals(type.getDeepComponentType())) {
                    return this.myPersistenceMap.get(this.myTType);
                }
                if (type instanceof PsiArrayType && (arrayType = (PsiArrayType)type).getComponentType().equals(type.getDeepComponentType())) {
                    return this.myPersistenceMap.get(this.myTArrayType);
                }
            }
            if ((elemType = QuickFixWorker.getListElementType(type)) != null && this.myParcelableType.isAssignableFrom(elemType) && !this.myParcelableType.equals((Object)elemType)) {
                return this.myPersistenceMap.get(this.myTListType);
            }
            switch (qualifiedName = type.getCanonicalText()) {
                case "java.lang.Byte": {
                    return new NumberObjectPersistence("Byte");
                }
                case "java.lang.Double": {
                    return new NumberObjectPersistence("Double");
                }
                case "java.lang.Float": {
                    return new NumberObjectPersistence("Float");
                }
                case "java.lang.Integer": {
                    return new NumberObjectPersistence("Int");
                }
                case "java.lang.Long": {
                    return new NumberObjectPersistence("Long");
                }
                case "java.lang.Character": {
                    return new ShortOrCharObjectFieldPersistence("char");
                }
                case "java.lang.Short": {
                    return new ShortOrCharObjectFieldPersistence("short");
                }
                case "short": {
                    return new ShortOrCharFieldPersistence("short");
                }
                case "char": {
                    return new ShortOrCharFieldPersistence("char");
                }
                case "java.lang.Boolean": {
                    return new BooleanObjectFieldPersistence();
                }
            }
            return null;
        }

        @Nullable
        private PsiElement findInsertionPoint() {
            for (PsiMethod method2 : this.myParcelable.getMethods()) {
                if (method2.isConstructor()) continue;
                return method2;
            }
            return null;
        }

        private static void addBefore(@NotNull PsiElement parent2, @NotNull PsiElement element2, @Nullable PsiElement insertionPoint) {
            if (element2.getParent() == parent2) {
                return;
            }
            parent2.addBefore(element2, insertionPoint);
        }

        private static void delete(@Nullable PsiElement element2) {
            if (element2 != null) {
                element2.delete();
            }
        }

        private void populateIgnoredMethods() {
            this.myIgnoredMethods.add("writeParcelable");
            this.myIgnoredMethods.add("readParcelable");
            this.myIgnoredMethods.add("writeParcelableArray");
            this.myIgnoredMethods.add("readParcelableArray");
            this.myIgnoredMethods.add("readSerializable");
            this.myIgnoredMethods.add("writeSerializable");
            this.myIgnoredMethods.add("readValue");
            this.myIgnoredMethods.add("writeValue");
            this.myIgnoredMethods.add("readArray");
            this.myIgnoredMethods.add("writeArray");
        }

        private void populateFieldPersistenceByType() {
            PsiClass parcel = this.myFacade.findClass("android.os.Parcel", GlobalSearchScope.allScope((Project)this.myProject));
            if (parcel == null) {
                return;
            }
            HashMap<PsiType, PsiMethod> setters = new HashMap<PsiType, PsiMethod>();
            HashMap<PsiType, PsiMethod> getters = new HashMap<PsiType, PsiMethod>();
            for (PsiMethod method2 : parcel.getMethods()) {
                PsiType type;
                if (this.myIgnoredMethods.contains(method2.getName())) continue;
                if (QuickFixWorker.isSimpleWrite(method2) || QuickFixWorker.isWriteWithParcelableFlags(method2)) {
                    type = method2.getParameterList().getParameters()[0].getType();
                    setters.put(type, method2);
                    continue;
                }
                if (!QuickFixWorker.isSimpleRead(method2)) continue;
                type = method2.getReturnType();
                getters.put(type, method2);
            }
            for (PsiType type : getters.keySet()) {
                SimpleFieldPersistence persistence;
                PsiType setterType = this.getTypicalSetterType(type);
                PsiMethod getter = (PsiMethod)getters.get(type);
                PsiMethod setter = (PsiMethod)setters.get(setterType);
                if (getter == null || setter == null) continue;
                if (QuickFixWorker.isSimpleWrite(setter)) {
                    persistence = new SimpleFieldPersistence(setter.getName(), getter.getName());
                } else {
                    if (!QuickFixWorker.isWriteWithParcelableFlags(setter)) continue;
                    persistence = new SimpleWithFlagsFieldPersistence(setter.getName(), getter.getName());
                }
                this.myPersistenceMap.put(type, persistence);
                this.myPersistenceMap.put(setterType, persistence);
            }
            this.myPersistenceMap.put((PsiType)this.myTType, new ParcelableFieldPersistence());
            this.myPersistenceMap.put((PsiType)this.myTArrayType, new EfficientParcelableArrayFieldPersistence());
            this.myPersistenceMap.put((PsiType)this.myTListType, new EfficientParcelableListFieldPersistence());
            this.myPersistenceMap.put((PsiType)PsiType.BOOLEAN, new BooleanFieldPersistence());
        }

        @NotNull
        private PsiType getTypicalSetterType(@NotNull PsiType type) {
            PsiType elemType = QuickFixWorker.getListElementType(type);
            return elemType == null ? type : this.myFactory.createType(this.myList, elemType);
        }

        @Nullable
        private static PsiType getListElementType(@NotNull PsiType type) {
            PsiClassReferenceType refType;
            PsiType[] elemTypes;
            if (type instanceof PsiClassReferenceType && (elemTypes = (refType = (PsiClassReferenceType)type).getParameters()).length == 1 && (type.getCanonicalText().startsWith("java.util.List") || type.getCanonicalText().startsWith("java.util.ArrayList"))) {
                return elemTypes[0];
            }
            return null;
        }

        private static boolean isSimpleWrite(@NotNull PsiMethod method2) {
            return method2.getName().startsWith("write") && method2.getParameterList().getParametersCount() == 1;
        }

        private static boolean isWriteWithParcelableFlags(@NotNull PsiMethod method2) {
            if (!method2.getName().startsWith("write") || method2.getParameterList().getParametersCount() != 2) {
                return false;
            }
            PsiParameter param = method2.getParameterList().getParameters()[1];
            return param.getType().equals(PsiType.INT) && Objects.equals(param.getName(), "parcelableFlags");
        }

        private static boolean isSimpleRead(@NotNull PsiMethod method2) {
            return (method2.getName().startsWith("read") || method2.getName().startsWith("create")) && method2.getParameterList().getParametersCount() == 0;
        }

        private static class NumberObjectPersistence
        implements FieldPersistence {
            private String myMethodSuffix;

            public NumberObjectPersistence(String methodSuffix) {
                this.myMethodSuffix = methodSuffix;
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field2, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                return new String[]{String.format("if (%2$s == null) { %1$s.writeByte((byte)0); } else { %1$s.writeByte((byte)1); %1$s.write%3$s(%2$s); }", parcelVariableName, field2.getName(), this.myMethodSuffix)};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field2, @NotNull String parcelVariableName) {
                return new String[]{String.format("if (%2$s.readByte() == 0) { %1$s = null; } else { %1$s = %2$s.read%3$s(); }", field2.getName(), parcelVariableName, this.myMethodSuffix)};
            }
        }

        private static class BooleanFieldPersistence
        implements FieldPersistence {
            private BooleanFieldPersistence() {
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field2, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                return new String[]{String.format("%1$s.writeByte((byte)(%2$s ? 1 : 0));\n", parcelVariableName, field2.getName())};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field2, @NotNull String parcelVariableName) {
                return new String[]{String.format("%1$s = %2$s.readByte() != 0;\n", field2.getName(), parcelVariableName)};
            }
        }

        private static class EfficientParcelableListFieldPersistence
        implements FieldPersistence {
            private EfficientParcelableListFieldPersistence() {
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field2, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                return new String[]{String.format("%1$s.writeTypedList(%2$s);\n", parcelVariableName, field2.getName())};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field2, @NotNull String parcelVariableName) {
                PsiType elemType = QuickFixWorker.getListElementType(field2.getType());
                assert (elemType != null);
                return new String[]{String.format("%1$s = %2$s.createTypedArrayList(%3$s.CREATOR);\n", field2.getName(), parcelVariableName, elemType.getCanonicalText())};
            }
        }

        private static class EfficientParcelableArrayFieldPersistence
        implements FieldPersistence {
            private EfficientParcelableArrayFieldPersistence() {
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field2, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                return new String[]{String.format("%1$s.writeTypedArray(%2$s, %3$s);\n", parcelVariableName, field2.getName(), flagsVariableName)};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field2, @NotNull String parcelVariableName) {
                String typeName = field2.getType().getDeepComponentType().getCanonicalText();
                return new String[]{String.format("%1$s = %2$s.createTypedArray(%3$s.CREATOR);\n", field2.getName(), parcelVariableName, typeName)};
            }
        }

        private static class ParcelableFieldPersistence
        implements FieldPersistence {
            private ParcelableFieldPersistence() {
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field2, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                return new String[]{String.format("%1$s.writeParcelable(%2$s, %3$s);\n", parcelVariableName, field2.getName(), flagsVariableName)};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field2, @NotNull String parcelVariableName) {
                return new String[]{String.format("%1$s = %2$s.readParcelable(%3$s.class.getClassLoader());\n", field2.getName(), parcelVariableName, field2.getType().getCanonicalText())};
            }
        }

        private static class SimpleWithFlagsFieldPersistence
        extends SimpleFieldPersistence {
            SimpleWithFlagsFieldPersistence(@NotNull String writeMethod, @NotNull String readMethod) {
                super(writeMethod, readMethod);
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field2, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                return new String[]{String.format("%1$s.%2$s(%3$s, %4$s);\n", parcelVariableName, this.myWriteMethodName, field2.getName(), flagsVariableName)};
            }
        }

        private static class SimpleFieldPersistence
        implements FieldPersistence {
            protected String myWriteMethodName;
            protected String myReadMethodName;

            SimpleFieldPersistence(@NotNull String writeMethod, @NotNull String readMethod) {
                this.myWriteMethodName = writeMethod;
                this.myReadMethodName = readMethod;
            }

            @Override
            public String[] formatWrite(@NotNull PsiField field2, @NotNull String parcelVariableName, @NotNull String flagsVariableName) {
                return new String[]{String.format("%1$s.%2$s(%3$s);\n", parcelVariableName, this.myWriteMethodName, field2.getName())};
            }

            @Override
            public String[] formatRead(@NotNull PsiField field2, @NotNull String parcelVariableName) {
                return new String[]{String.format("%1$s = %2$s.%3$s();\n", field2.getName(), parcelVariableName, this.myReadMethodName)};
            }
        }

        private static interface FieldPersistence {
            public String[] formatWrite(@NotNull PsiField var1, @NotNull String var2, @NotNull String var3);

            public String[] formatRead(@NotNull PsiField var1, @NotNull String var2);
        }
    }

    public static enum Operation {
        IMPLEMENT,
        REMOVE,
        REIMPLEMENT;

    }
}

