/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.resources.Density;
import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.intellij.codeInsight.intention.preview.IntentionPreviewInfo;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlTagValue;
import java.util.ArrayList;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConvertToDpQuickFix
extends DefaultLintQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.android.tools.idea.lint.quickFixes.ConvertToDpQuickFix");
    private static final Pattern PX_ATTR_VALUE_PATTERN = Pattern.compile("(\\d+)px");
    private static int ourPrevDpi = Density.DEFAULT_DENSITY;

    public ConvertToDpQuickFix() {
        super(AndroidLintBundle.message("android.lint.fix.convert.to.dp", new Object[0]));
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
        int dpi;
        if (context2 instanceof AndroidQuickfixContexts.BatchContext) {
            return;
        }
        XmlTag tag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class);
        ArrayList<Density> densities = new ArrayList<Density>();
        for (Density density : Density.values()) {
            if (!density.isValidValueForDevice()) continue;
            densities.add(density);
        }
        String[] densityPresentableNames = new String[densities.size()];
        String defaultValue = null;
        String initialValue = null;
        for (int i = 0; i < densities.size(); ++i) {
            Density density = (Density)densities.get(i);
            densityPresentableNames[i] = ConvertToDpQuickFix.getLabelForDensity(density);
            int dpi2 = density.getDpiValue();
            if (dpi2 == ourPrevDpi) {
                initialValue = densityPresentableNames[i];
                continue;
            }
            if (dpi2 != Density.DEFAULT_DENSITY) continue;
            defaultValue = densityPresentableNames[i];
        }
        if (initialValue == null) {
            initialValue = defaultValue;
        }
        if (initialValue == null) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || context2 instanceof AndroidQuickfixContexts.EditorPreviewContext) {
            dpi = Density.DEFAULT_DENSITY;
        } else {
            int selectedIndex = Messages.showChooseDialog((String)"What is the screen density the current px value works with?", (String)"Choose density", (String[])densityPresentableNames, initialValue, null);
            if (selectedIndex < 0) {
                return;
            }
            dpi = ((Density)densities.get(selectedIndex)).getDpiValue();
        }
        ourPrevDpi = dpi;
        Runnable runnable2 = () -> {
            String newValue;
            for (XmlAttribute attribute : tag.getAttributes()) {
                String newValue2;
                String value2 = attribute.getValue();
                if (value2 == null || !value2.endsWith("px") || (newValue2 = ConvertToDpQuickFix.convertToDp(value2, dpi)) == null) continue;
                attribute.setValue(newValue2);
            }
            XmlTagValue tagValueElement = tag.getValue();
            String tagValue = tagValueElement.getText();
            if (tagValue.endsWith("px") && (newValue = ConvertToDpQuickFix.convertToDp(tagValue, dpi)) != null) {
                tagValueElement.setText(newValue);
            }
        };
        if (context2 instanceof AndroidQuickfixContexts.EditorPreviewContext) {
            runnable2.run();
        } else {
            application.runWriteAction(runnable2);
        }
    }

    private static String convertToDp(String value2, int dpi) {
        String newValue = null;
        Matcher matcher = PX_ATTR_VALUE_PATTERN.matcher(value2);
        if (matcher.matches()) {
            String numberString = matcher.group(1);
            try {
                int px = Integer.parseInt(numberString);
                int dp = px * 160 / dpi;
                newValue = Integer.toString(dp) + "dp";
            }
            catch (NumberFormatException nufe) {
                LOG.error((Throwable)nufe);
            }
        }
        return newValue;
    }

    @NotNull
    private static String getLabelForDensity(@NotNull Density density) {
        return String.format(Locale.US, "%1$s (%2$d)", density.getShortDisplayValue(), density.getDpiValue());
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return contextType != AndroidQuickfixContexts.BatchContext.TYPE && PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class) != null;
    }

    @Nullable
    public IntentionPreviewInfo generatePreview(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file2) {
        PsiElement element2 = file2.findElementAt(editor.getCaretModel().getOffset());
        if (element2 != null) {
            this.apply(element2, element2, (AndroidQuickfixContexts.Context)new AndroidQuickfixContexts.EditorPreviewContext(editor, file2));
            return IntentionPreviewInfo.DIFF;
        }
        return null;
    }
}

