/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeUtilsKt;
import com.android.tools.lint.checks.ApiLookup;
import com.android.tools.lint.detector.api.ApiConstraint;
import com.android.tools.lint.detector.api.ExtensionSdk;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfSurrounder;
import com.intellij.codeInspection.JavaSuppressionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.KotlinLanguage;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.idea.codeInsight.surroundWith.statement.KotlinIfSurrounder;
import org.jetbrains.kotlin.idea.core.ShortenReferences;
import org.jetbrains.kotlin.idea.inspections.IntentionBasedInspectionKt;
import org.jetbrains.kotlin.psi.KtBlockExpression;
import org.jetbrains.kotlin.psi.KtClassInitializer;
import org.jetbrains.kotlin.psi.KtContainerNode;
import org.jetbrains.kotlin.psi.KtDestructuringDeclaration;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtPropertyAccessor;
import org.jetbrains.kotlin.psi.KtReturnExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.lazy.BodyResolveMode;
import org.jetbrains.kotlin.util.slicedMap.ReadOnlySlice;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000  2\u00020\u0001:\u0001 B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002J\u001a\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0012H\u0002J\u0012\u0010\u0018\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0015\u001a\u00020\rH\u0002J\u0018\u0010\u0019\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001a\u001a\u00020\u000b2\u0006\u0010\u0015\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u001d\u001a\u00020\u001eH\u0016J\f\u0010\u001f\u001a\u00020\u001c*\u00020\rH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/lint/quickFixes/AddTargetVersionCheckQuickFix;", "Lcom/android/tools/idea/lint/common/DefaultLintQuickFix;", "project", "Lcom/intellij/openapi/project/Project;", "api", "", "sdkId", "minSdk", "Lcom/android/tools/lint/detector/api/ApiConstraint;", "(Lcom/intellij/openapi/project/Project;IILcom/android/tools/lint/detector/api/ApiConstraint;)V", "apply", "", "startElement", "Lcom/intellij/psi/PsiElement;", "endElement", "context", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$Context;", "getExtensionCheckPrefix", "", "getKotlinSurrounder", "Lorg/jetbrains/kotlin/idea/codeInsight/surroundWith/statement/KotlinIfSurrounder;", "element", "Lorg/jetbrains/kotlin/psi/KtElement;", "todoText", "getKotlinTargetExpression", "handleJava", "handleKotlin", "isApplicable", "", "contextType", "Lcom/android/tools/idea/lint/common/AndroidQuickfixContexts$ContextType;", "isInvalidTargetExpression", "Companion", "intellij.android.lint"})
public final class AddTargetVersionCheckQuickFix
extends DefaultLintQuickFix {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int api;
    private final int sdkId;
    @NotNull
    private final ApiConstraint minSdk;

    /*
     * WARNING - void declaration
     */
    public AddTargetVersionCheckQuickFix(@NotNull Project project, int api, int sdkId, @NotNull ApiConstraint minSdk) {
        String string;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)minSdk, (String)"minSdk");
        AddTargetVersionCheckQuickFix addTargetVersionCheckQuickFix = this;
        if (sdkId == 0) {
            void it;
            String string2 = Companion.getVersionField(api, false);
            AddTargetVersionCheckQuickFix addTargetVersionCheckQuickFix2 = addTargetVersionCheckQuickFix;
            boolean bl = false;
            addTargetVersionCheckQuickFix = addTargetVersionCheckQuickFix2;
            string = "Surround with if (VERSION.SDK_INT >= " + (Character.isDigit(it.charAt(0)) ? it : "VERSION_CODES." + (String)it) + ") { ... }";
        } else {
            string = "Surround with if (SdkExtensions.getExtensionVersion(" + Companion.getSdkExtensionField(project, sdkId, false) + ")) >= " + api + ") { ... }";
        }
        super(string);
        this.api = api;
        this.sdkId = sdkId;
        this.minSdk = minSdk;
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        PsiExpression expression2;
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)contextType, (String)"contextType");
        if (AndroidFacet.getInstance((PsiElement)endElement) == null) {
            return false;
        }
        Language language = startElement.getLanguage();
        return Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE) ? (expression2 = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiExpression.class, (boolean)false)) != null : (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE) ? this.getKotlinTargetExpression(startElement) != null : false);
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
        Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
        Intrinsics.checkNotNullParameter((Object)endElement, (String)"endElement");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        if (!LintIdeUtilsKt.preparedToWrite((PsiElement)startElement)) {
            return;
        }
        Language language = startElement.getLanguage();
        if (Intrinsics.areEqual((Object)language, (Object)JavaLanguage.INSTANCE)) {
            this.handleJava(startElement, context2);
        } else if (Intrinsics.areEqual((Object)language, (Object)KotlinLanguage.INSTANCE)) {
            this.handleKotlin(startElement, context2);
        }
    }

    private final void handleKotlin(PsiElement element2, AndroidQuickfixContexts.Context context2) {
        KtElement ktElement = this.getKotlinTargetExpression(element2);
        if (ktElement == null) {
            return;
        }
        KtElement targetExpression = ktElement;
        Project project = targetExpression.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"targetExpression.project");
        Project project2 = project;
        IntentionBasedInspectionKt.findExistingEditor((PsiElement)((PsiElement)targetExpression));
        Editor editor = context2.getEditor(targetExpression.getContainingFile());
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        PsiFile file2 = targetExpression.getContainingFile();
        PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
        Document document2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
        Document document3 = document2;
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file");
        if (!LintIdeUtilsKt.preparedToWrite((PsiElement)((PsiElement)file2))) {
            return;
        }
        KotlinIfSurrounder surrounder = this.sdkId == 0 ? this.getKotlinSurrounder(targetExpression, "\"VERSION.SDK_INT < " + Companion.getVersionField(this.api, false) + "\"") : this.getKotlinSurrounder(targetExpression, "\"SdkExtensions.getExtensionVersion(" + Companion.getSdkExtensionField(project2, this.sdkId, false) + ") < " + this.api + "\"");
        KtElement[] ktElementArray = new KtElement[]{targetExpression};
        TextRange textRange = surrounder.surroundElements(project2, editor2, (PsiElement[])ktElementArray);
        if (textRange == null) {
            return;
        }
        TextRange conditionRange = textRange;
        String conditionText = this.sdkId == 0 ? "android.os.Build.VERSION.SDK_INT >= " + Companion.getVersionField(this.api, true) : this.getExtensionCheckPrefix() + "android.os.ext.SdkExtensions.getExtensionVersion(" + Companion.getSdkExtensionField(project2, this.sdkId, true) + ") >= " + this.api;
        document3.replaceString(conditionRange.getStartOffset(), conditionRange.getEndOffset(), (CharSequence)conditionText);
        documentManager.commitDocument(document3);
        PsiFile psiFile = documentManager.getPsiFile(document3);
        Intrinsics.checkNotNull((Object)psiFile, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.psi.KtFile");
        ShortenReferences.process$default((ShortenReferences)ShortenReferences.DEFAULT, (KtFile)((KtFile)psiFile), (int)conditionRange.getStartOffset(), (int)(conditionRange.getStartOffset() + conditionText.length()), null, (boolean)false, (int)24, null);
    }

    private final String getExtensionCheckPrefix() {
        return !Intrinsics.areEqual((Object)this.minSdk, (Object)ApiConstraint.UNKNOWN) && this.minSdk.isAtLeast((ApiConstraint)ApiConstraint.Companion.get(30, 0)) ? "" : "android.os.Build.VERSION.SDK_INT >= android.os.Build.VERSION_CODES.R && ";
    }

    private final void handleJava(PsiElement element2, AndroidQuickfixContexts.Context context2) {
        PsiExpression psiExpression = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiExpression.class, (boolean)false);
        if (psiExpression == null) {
            return;
        }
        PsiExpression expression2 = psiExpression;
        Editor editor = context2.getEditor(expression2.getContainingFile());
        if (editor == null) {
            return;
        }
        Editor editor2 = editor;
        PsiStatement psiStatement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)expression2), PsiStatement.class);
        if (psiStatement == null) {
            return;
        }
        PsiStatement anchorStatement = psiStatement;
        Project project = expression2.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"expression.project");
        Project project2 = project;
        Document document2 = editor2.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"editor.document");
        Document document3 = document2;
        PsiModifierListOwner owner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)element2, PsiModifierListOwner.class, (boolean)false);
        PsiElement[] psiElementArray = new PsiElement[]{(PsiElement)anchorStatement};
        PsiElement[] elements = psiElementArray;
        PsiElement prev = PsiTreeUtil.skipWhitespacesBackward((PsiElement)((PsiElement)anchorStatement));
        if (prev instanceof PsiComment && JavaSuppressionUtil.getSuppressedInspectionIdsIn((PsiElement)prev) != null) {
            PsiElement[] psiElementArray2 = new PsiElement[]{prev, (PsiElement)anchorStatement};
            elements = psiElementArray2;
        }
        try {
            TextRange textRange = new JavaWithIfSurrounder().surroundElements(project2, editor2, elements);
            if (textRange == null) {
                return;
            }
            TextRange textRange2 = textRange;
            String newText = this.sdkId == 0 ? "android.os.Build.VERSION.SDK_INT >= " + Companion.getVersionField(this.api, true) : this.getExtensionCheckPrefix() + "android.os.ext.SdkExtensions.getExtensionVersion(" + Companion.getSdkExtensionField(project2, this.sdkId, true) + ") >= " + this.api;
            document3.replaceString(textRange2.getStartOffset(), textRange2.getEndOffset(), (CharSequence)newText);
            PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project2);
            documentManager.commitDocument(document3);
            editor2.getCaretModel().moveToOffset(textRange2.getEndOffset() + newText.length());
            editor2.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
            if (owner != null && owner.isValid() && !ApplicationManager.getApplication().isUnitTestMode()) {
                JavaCodeStyleManager.getInstance((Project)project2).shortenClassReferences((PsiElement)owner);
            }
        }
        catch (IncorrectOperationException e) {
            Logger.getInstance(AddTargetVersionCheckQuickFix.class).error((Throwable)e);
        }
    }

    private final KtElement getKotlinTargetExpression(PsiElement element2) {
        KtElement current = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)element2, KtExpression.class);
        while (current != null) {
            PsiElement parent2;
            if (current.getParent() == null) {
                return current;
            }
            if (this.isInvalidTargetExpression(parent2)) break;
            current = (KtElement)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)current), KtExpression.class, (boolean)true);
        }
        return current;
    }

    private final KotlinIfSurrounder getKotlinSurrounder(KtElement element2, String todoText) {
        boolean used;
        Boolean bl = (Boolean)ResolutionUtils.analyze((KtElement)element2, (BodyResolveMode)BodyResolveMode.PARTIAL).get((ReadOnlySlice)BindingContext.USED_AS_EXPRESSION, (Object)element2);
        if (bl == null) {
            bl = false;
        }
        return (used = bl.booleanValue()) ? (KotlinIfSurrounder)new KotlinIfSurrounder(todoText){
            final /* synthetic */ String $todoText;
            {
                this.$todoText = $todoText;
            }

            @NotNull
            protected String getCodeTemplate() {
                String string = this.$todoText;
                if (string == null) {
                    string = "";
                }
                return "if (a) { \n} else {\nTODO(" + string + ")\n}";
            }
        } : new KotlinIfSurrounder();
    }

    private final boolean isInvalidTargetExpression(PsiElement $this$isInvalidTargetExpression) {
        return $this$isInvalidTargetExpression instanceof KtBlockExpression || $this$isInvalidTargetExpression instanceof KtContainerNode || $this$isInvalidTargetExpression instanceof KtWhenEntry || $this$isInvalidTargetExpression instanceof KtFunction || $this$isInvalidTargetExpression instanceof KtPropertyAccessor || $this$isInvalidTargetExpression instanceof KtProperty || $this$isInvalidTargetExpression instanceof KtReturnExpression || $this$isInvalidTargetExpression instanceof KtDestructuringDeclaration || $this$isInvalidTargetExpression instanceof KtClassInitializer;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u0016\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/lint/quickFixes/AddTargetVersionCheckQuickFix$Companion;", "", "()V", "getSdkExtensionField", "", "project", "Lcom/intellij/openapi/project/Project;", "sdkId", "", "fullyQualified", "", "getVersionField", "api", "intellij.android.lint"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getVersionField(int api, boolean fullyQualified) {
            return ExtensionSdk.Companion.getAndroidVersionField(api, fullyQualified);
        }

        @NotNull
        public final String getSdkExtensionField(@NotNull Project project, int sdkId, boolean fullyQualified) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            ApiLookup apiLookup = LintIdeClient.getApiLookup((Project)project);
            if (apiLookup != null) {
                String string = apiLookup.getSdkExtensionField(sdkId, fullyQualified);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"apiLookup.getSdkExtensio\u2026ld(sdkId, fullyQualified)");
                return string;
            }
            return ExtensionSdk.Companion.getSdkExtensionField(sdkId, fullyQualified);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

