/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.quickFixes;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlNamespaceHelper;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;

public class AddMissingPrefixQuickFix
extends DefaultLintQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.android.inspections.lint.AddMissingPrefixQuickFix");

    public AddMissingPrefixQuickFix() {
        super(AndroidLintBundle.message("android.lint.fix.add.android.prefix", new Object[0]));
    }

    public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
        XmlAttribute attribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false);
        if (attribute == null) {
            return;
        }
        XmlTag tag = attribute.getParent();
        if (tag == null) {
            LOG.debug("tag is null");
            return;
        }
        String androidNsPrefix = tag.getPrefixByNamespace("http://schemas.android.com/apk/res/android");
        if (androidNsPrefix == null) {
            PsiFile file2 = tag.getContainingFile();
            XmlNamespaceHelper extension = XmlNamespaceHelper.getHelper((PsiFile)file2);
            if (extension == null) {
                LOG.debug("Cannot get XmlNamespaceHelper for file + " + file2);
                return;
            }
            if (!(file2 instanceof XmlFile)) {
                LOG.debug(file2 + " is not XmlFile");
                return;
            }
            XmlFile xmlFile = (XmlFile)file2;
            String defaultPrefix = "android";
            extension.insertNamespaceDeclaration(xmlFile, null, Collections.singleton("http://schemas.android.com/apk/res/android"), "android", null);
            androidNsPrefix = "android";
        }
        String finalAndroidNsPrefix = androidNsPrefix;
        ApplicationManager.getApplication().runWriteAction(() -> attribute.setName(finalAndroidNsPrefix + ":" + attribute.getLocalName()));
    }

    public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
        return PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false) != null;
    }
}

