/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.intentions;

import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.quickFixes.ParcelableQuickFix;
import com.intellij.codeInsight.intention.AbstractIntentionAction;
import com.intellij.codeInsight.intention.HighPriorityAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.util.AndroidBundle;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ImplementParcelableAction
extends AbstractIntentionAction
implements HighPriorityAction {
    private final ParcelableQuickFix myQuickFix;

    public ImplementParcelableAction() {
        this(ParcelableQuickFix.Operation.IMPLEMENT);
    }

    protected ImplementParcelableAction(ParcelableQuickFix.Operation operation) {
        this.myQuickFix = new ParcelableQuickFix(this.getText(), operation);
    }

    @Nls
    @NotNull
    public String getText() {
        return AndroidBundle.message("implement.parcelable.intention.text", new Object[0]);
    }

    @NotNull
    public String getFamilyName() {
        return this.getText();
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, PsiFile file2) {
        PsiElement element2 = ImplementParcelableAction.getPsiElement(file2, editor);
        return element2 != null && this.myQuickFix.isApplicable(element2, element2, AndroidQuickfixContexts.DesignerContext.TYPE);
    }

    public void invoke(@NotNull Project project, Editor editor, PsiFile file2) throws IncorrectOperationException {
        PsiElement element2 = ImplementParcelableAction.getPsiElement(file2, editor);
        this.myQuickFix.apply(element2, element2, (AndroidQuickfixContexts.Context)AndroidQuickfixContexts.DesignerContext.getInstance());
    }

    @Nullable
    private static PsiElement getPsiElement(PsiFile file2, Editor editor) {
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)file2);
        if (facet2 == null) {
            return null;
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element2 = file2.findElementAt(offset);
        return element2 != null ? element2.getParent() : null;
    }

    public boolean startInWriteAction() {
        return true;
    }
}

