/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.rendering.webp.ConvertFromWebpAction;
import com.android.tools.lint.checks.IconDetector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;

public class AndroidLintWebpUnsupportedInspection
extends AndroidLintInspectionBase {
    public AndroidLintWebpUnsupportedInspection() {
        super(AndroidLintBundle.message("android.lint.inspections.webp.unsupported", new Object[0]), IconDetector.WEBP_UNSUPPORTED);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2) {
        return new LintIdeQuickFix[]{new ConvertWebpToPngFix()};
    }

    static class ConvertWebpToPngFix
    extends DefaultLintQuickFix {
        public ConvertWebpToPngFix() {
            super("Convert image to PNG");
        }

        public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
            VirtualFile file2 = startElement.getContainingFile().getVirtualFile();
            if (file2.exists()) {
                new ConvertFromWebpAction().perform(startElement.getProject(), new VirtualFile[]{file2}, true);
            }
        }
    }
}

