/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.lint.common.RenameAttributeQuickFix;
import com.android.tools.idea.lint.common.RenameXmlTagQuickFix;
import com.android.tools.lint.checks.NetworkSecurityConfigDetector;
import com.android.tools.lint.detector.api.LintFix;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AndroidLintNetworkSecurityConfigInspection
extends AndroidLintInspectionBase {
    public AndroidLintNetworkSecurityConfigInspection() {
        super(AndroidLintBundle.message("android.lint.inspections.network.security.config", new Object[0]), NetworkSecurityConfigDetector.ISSUE);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2, @Nullable LintFix fixData) {
        if (NetworkSecurityConfigDetector.isAttributeSpellingError((String)message2)) {
            XmlTag parentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            XmlAttribute currentAttr = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlAttribute.class, (boolean)false);
            assert (parentTag != null);
            assert (currentAttr != null);
            List suggestions2 = NetworkSecurityConfigDetector.getAttributeSpellingSuggestions((String)currentAttr.getName(), (String)parentTag.getName());
            LintIdeQuickFix[] attrFixes = new LintIdeQuickFix[suggestions2.size()];
            for (int i = 0; i < attrFixes.length; ++i) {
                attrFixes[i] = new RenameAttributeQuickFix(null, (String)suggestions2.get(i));
            }
            return attrFixes;
        }
        if (NetworkSecurityConfigDetector.isTagSpellingError((String)message2)) {
            XmlTag currentTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)startElement, XmlTag.class, (boolean)false);
            assert (currentTag != null);
            XmlTag parentTag = currentTag.getParentTag();
            assert (parentTag != null);
            List suggestions3 = NetworkSecurityConfigDetector.getTagSpellingSuggestions((String)currentTag.getName(), (String)parentTag.getName());
            LintIdeQuickFix[] elementQuickFixes = new LintIdeQuickFix[suggestions3.size()];
            for (int i = 0; i < elementQuickFixes.length; ++i) {
                elementQuickFixes[i] = new RenameXmlTagQuickFix((String)suggestions3.get(i));
            }
            return elementQuickFixes;
        }
        return super.getQuickFixes(startElement, endElement, message2, fixData);
    }
}

