/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint.inspections;

import com.android.tools.idea.lint.AndroidLintBundle;
import com.android.tools.idea.lint.common.AndroidLintInspectionBase;
import com.android.tools.idea.lint.common.AndroidQuickfixContexts;
import com.android.tools.idea.lint.common.DefaultLintQuickFix;
import com.android.tools.idea.lint.common.LintIdeQuickFix;
import com.android.tools.idea.model.AndroidModuleInfo;
import com.android.tools.idea.rendering.webp.ConvertToWebpAction;
import com.android.tools.lint.checks.IconDetector;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import java.util.List;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.ResourceFolderManager;
import org.jetbrains.annotations.NotNull;

public class AndroidLintConvertToWebpInspection
extends AndroidLintInspectionBase {
    public AndroidLintConvertToWebpInspection() {
        super(AndroidLintBundle.message("android.lint.inspections.convert.to.webp", new Object[0]), IconDetector.WEBP_ELIGIBLE);
    }

    @NotNull
    public LintIdeQuickFix[] getQuickFixes(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull String message2) {
        return new LintIdeQuickFix[]{new DefaultLintQuickFix("Convert images to WebP..."){

            public boolean isApplicable(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.ContextType contextType) {
                return AndroidFacet.getInstance((PsiElement)startElement) != null;
            }

            public boolean startInWriteAction() {
                return false;
            }

            public void apply(@NotNull PsiElement startElement, @NotNull PsiElement endElement, @NotNull AndroidQuickfixContexts.Context context2) {
                AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)startElement);
                if (facet2 != null) {
                    AndroidModuleInfo info2 = AndroidModuleInfo.getInstance(facet2);
                    int minSdkVersion2 = info2.getMinSdkVersion().getApiLevel();
                    List<VirtualFile> folders = ResourceFolderManager.getInstance(facet2).getFolders();
                    ConvertToWebpAction action2 = new ConvertToWebpAction();
                    action2.perform(startElement.getProject(), minSdkVersion2, folders.toArray(VirtualFile.EMPTY_ARRAY));
                }
            }
        }};
    }
}

