/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.lint;

import com.android.ide.common.repository.AgpVersion;
import com.android.ide.common.repository.GradleCoordinate;
import com.android.ide.common.repository.SdkMavenRepository;
import com.android.repository.api.ProgressIndicator;
import com.android.repository.api.RepoPackage;
import com.android.sdklib.repository.AndroidSdkHandler;
import com.android.tools.idea.gradle.model.IdeLintOptions;
import com.android.tools.idea.gradle.plugin.AndroidPluginInfo;
import com.android.tools.idea.gradle.plugin.LatestKnownPluginVersionProvider;
import com.android.tools.idea.gradle.project.model.GradleAndroidModel;
import com.android.tools.idea.gradle.project.upgrade.AssistantInvoker;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgrade;
import com.android.tools.idea.gradle.project.upgrade.GradlePluginUpgradeState;
import com.android.tools.idea.gradle.repositories.IdeGoogleMavenRepository;
import com.android.tools.idea.gradle.repositories.RepositoryUrlManager;
import com.android.tools.idea.lint.AndroidLintIdeClient;
import com.android.tools.idea.lint.AndroidLintIdeIssueRegistry;
import com.android.tools.idea.lint.AndroidLintIdeProject;
import com.android.tools.idea.lint.LintIdeAnalytics;
import com.android.tools.idea.lint.ProvideLintFeedbackFix;
import com.android.tools.idea.lint.ProvideLintFeedbackIntentionAction;
import com.android.tools.idea.lint.ProvideLintFeedbackPanel;
import com.android.tools.idea.lint.common.LintBatchResult;
import com.android.tools.idea.lint.common.LintEditorResult;
import com.android.tools.idea.lint.common.LintIdeClient;
import com.android.tools.idea.lint.common.LintIdeSupport;
import com.android.tools.idea.lint.common.LintIdeSupportKt;
import com.android.tools.idea.lint.common.LintResult;
import com.android.tools.idea.progress.StudioLoggerProgressIndicator;
import com.android.tools.idea.projectsystem.ProjectSystemSyncManager;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.android.tools.idea.res.AndroidFileChangeListener;
import com.android.tools.idea.res.IdeResourcesUtil;
import com.android.tools.idea.sdk.AndroidSdks;
import com.android.tools.idea.sdk.StudioSdkUtil;
import com.android.tools.lint.client.api.IssueRegistry;
import com.android.tools.lint.client.api.LintDriver;
import com.android.tools.lint.detector.api.Issue;
import com.android.tools.lint.detector.api.Platform;
import com.android.tools.lint.detector.api.Project;
import com.google.wireless.android.sdk.stats.LintSession;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.facet.ProjectFacetManager;
import com.intellij.ide.highlighter.JavaFileType;
import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import java.io.File;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeDefinitions;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.resourceManagers.FrameworkResourceManager;
import org.jetbrains.android.resourceManagers.ModuleResourceManagers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.plugins.gradle.config.GradleFileTypeKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u00cc\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0010\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010\u0010\u001a\u00020\r2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\rH\u0016J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0018\u0010\u001a\u001a\u00020\u00172\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u001bH\u0016J\u0010\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u001dH\u0016J?\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001f2\u0006\u0010!\u001a\u00020\u00172\u000e\u0010\"\u001a\n\u0012\u0004\u0012\u00020#\u0018\u00010\u001f2\u0012\u0010$\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00140%\"\u00020\u0014H\u0016\u00a2\u0006\u0002\u0010&J.\u0010'\u001a\u000e\u0012\u0004\u0012\u00020 \u0012\u0004\u0012\u00020 0(2\u0006\u0010!\u001a\u00020\u00172\b\u0010\u0011\u001a\u0004\u0018\u00010#2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\"\u0010)\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020*2\u0006\u0010+\u001a\u00020\b2\b\u0010,\u001a\u0004\u0018\u00010\bH\u0016J\u001a\u0010-\u001a\u0004\u0018\u00010.2\u0006\u0010!\u001a\u00020\u00172\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010/\u001a\u000200H\u0016J\u000e\u00101\u001a\b\u0012\u0004\u0012\u00020302H\u0016J\u001e\u00104\u001a\u0010\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u000206\u0018\u0001052\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0018\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\u0006\u0010\u0018\u001a\u00020\u001dH\u0016J\"\u00107\u001a\u0002082\u0006\u00109\u001a\u00020:2\b\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\u0012\u0010;\u001a\u0004\u0018\u00010<2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@H\u0016J\u0010\u0010A\u001a\u00020B2\u0006\u0010?\u001a\u00020@H\u0016J\u001a\u0010C\u001a\u0004\u0018\u00010\b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010D\u001a\u00020EH\u0016J\u0010\u0010F\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010G\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010H\u001a\u0002082\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0018\u0010I\u001a\u0002082\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010J\u001a\u00020\u000bH\u0016J\u0018\u0010K\u001a\u0002082\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010D\u001a\u00020EH\u0016R\u0016\u0010\u0003\u001a\u00020\u00048\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006L"}, d2={"Lcom/android/tools/idea/lint/AndroidLintIdeSupport;", "Lcom/android/tools/idea/lint/common/LintIdeSupport;", "()V", "random", "Ljava/util/Random;", "getRandom", "()Ljava/util/Random;", "askForAttributeValue", "", "attributeName", "context", "Lcom/intellij/psi/PsiElement;", "canAnalyze", "", "project", "Lcom/intellij/openapi/project/Project;", "canAnnotate", "file", "Lcom/intellij/psi/PsiFile;", "module", "Lcom/intellij/openapi/module/Module;", "canRequestFeedback", "createBatchClient", "Lcom/android/tools/idea/lint/common/LintIdeClient;", "lintResult", "Lcom/android/tools/idea/lint/common/LintBatchResult;", "createClient", "Lcom/android/tools/idea/lint/common/LintResult;", "createEditorClient", "Lcom/android/tools/idea/lint/common/LintEditorResult;", "createProject", "", "Lcom/android/tools/lint/detector/api/Project;", "client", "files", "Lcom/intellij/openapi/vfs/VirtualFile;", "modules", "", "(Lcom/android/tools/idea/lint/common/LintIdeClient;Ljava/util/List;[Lcom/intellij/openapi/module/Module;)Ljava/util/List;", "createProjectForSingleFile", "Lcom/intellij/openapi/util/Pair;", "ensureNamespaceImported", "Lcom/intellij/psi/xml/XmlFile;", "namespaceUri", "suggestedPrefix", "getBaselineFile", "Ljava/io/File;", "getIssueRegistry", "Lcom/android/tools/lint/client/api/IssueRegistry;", "getPlatforms", "Ljava/util/EnumSet;", "Lcom/android/tools/lint/detector/api/Platform;", "getSeverityOverrides", "", "", "logSession", "", "lint", "Lcom/android/tools/lint/client/api/LintDriver;", "recommendedAgpVersion", "Lcom/android/ide/common/repository/AgpVersion;", "requestFeedbackFix", "Lcom/intellij/codeInspection/LocalQuickFix;", "issue", "Lcom/android/tools/lint/detector/api/Issue;", "requestFeedbackIntentionAction", "Lcom/intellij/codeInsight/intention/IntentionAction;", "resolveDynamic", "gc", "Lcom/android/ide/common/repository/GradleCoordinate;", "shouldOfferUpgradeAssistantForDeprecatedConfigurations", "shouldRecommendUpdateAgpToLatest", "updateAgpToLatest", "updateDeprecatedConfigurations", "element", "updateToLatest", "intellij.android.lint"})
public final class AndroidLintIdeSupport
extends LintIdeSupport {
    @VisibleForTesting
    @NotNull
    private final Random random = new Random(0L);

    @NotNull
    public IssueRegistry getIssueRegistry() {
        return (IssueRegistry)new AndroidLintIdeIssueRegistry();
    }

    @Nullable
    public File getBaselineFile(@NotNull LintIdeClient client2, @NotNull Module module2) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
            Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
            GradleAndroidModel gradleAndroidModel = GradleAndroidModel.Companion.get(module2);
            if (gradleAndroidModel == null) {
                return null;
            }
            GradleAndroidModel model2 = gradleAndroidModel;
            AgpVersion agpVersion = model2.getAgpVersion();
            if (agpVersion == null) {
                return null;
            }
            AgpVersion version2 = agpVersion;
            if (version2.isAtLeast(2, 3, 1)) {
                IdeLintOptions options2 = model2.getAndroidProject().getLintOptions();
                try {
                    File baselineFile = options2.getBaselineFile();
                    if (baselineFile != null) {
                        return baselineFile;
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            File file2 = LintIdeSupportKt.getModuleDir((Module)module2);
            if (file2 == null) break block7;
            File dir = file2;
            boolean bl = false;
            Object object = client2.getConfiguration(dir);
            if (object != null && (object = object.getBaselineFile()) != null) {
                Object baseline = object;
                boolean bl2 = false;
                return baseline;
            }
        }
        return null;
    }

    @Nullable
    public Map<String, Integer> getSeverityOverrides(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        GradleAndroidModel gradleAndroidModel = GradleAndroidModel.Companion.get(module2);
        if (gradleAndroidModel == null) {
            return null;
        }
        GradleAndroidModel model2 = gradleAndroidModel;
        AgpVersion agpVersion = model2.getAgpVersion();
        if (agpVersion == null) {
            return null;
        }
        AgpVersion version2 = agpVersion;
        if (version2.isAtLeast(2, 3, 1)) {
            IdeLintOptions options2 = model2.getAndroidProject().getLintOptions();
            try {
                return options2.getSeverityOverrides();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return null;
    }

    @Nullable
    public String askForAttributeValue(@NotNull String attributeName, @NotNull PsiElement context2) {
        AttributeDefinition def;
        AttributeDefinitions attrDefs;
        FrameworkResourceManager srm;
        Intrinsics.checkNotNullParameter((Object)attributeName, (String)"attributeName");
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        AndroidFacet facet2 = AndroidFacet.getInstance((PsiElement)context2);
        String message2 = "Specify value of attribute '" + attributeName + "'";
        String title = "Set Attribute Value";
        if (facet2 != null && (srm = ModuleResourceManagers.getInstance(facet2).getFrameworkResourceManager()) != null && (attrDefs = srm.getAttributeDefinitions()) != null && (def = attrDefs.getAttrDefByName(attributeName)) != null) {
            String[] stringArray = def.getValues();
            Intrinsics.checkNotNullExpressionValue((Object)stringArray, (String)"def.values");
            String[] variants = stringArray;
            if (!(variants.length == 0)) {
                return Messages.showEditableChooseDialog((String)message2, (String)title, (Icon)Messages.getQuestionIcon(), (String[])variants, (String)variants[0], null);
            }
        }
        return Messages.showInputDialog((com.intellij.openapi.project.Project)context2.getProject(), (String)message2, (String)title, (Icon)Messages.getQuestionIcon());
    }

    public boolean canAnnotate(@NotNull PsiFile file2, @NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
        if (facet2 == null && !AndroidLintIdeProject.hasAndroidModule(module2.getProject())) {
            return false;
        }
        FileType fileType = file2.getFileType();
        Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"file.fileType");
        FileType fileType2 = fileType;
        if (fileType2 == JavaFileType.INSTANCE || fileType2 == KotlinFileType.INSTANCE || fileType2 == PropertiesFileType.INSTANCE) {
            return true;
        }
        if (fileType2 == XmlFileType.INSTANCE) {
            return facet2 != null && (ModuleResourceManagers.getInstance(facet2).getLocalResourceManager().getFileResourceFolderType(file2) != null || Intrinsics.areEqual((Object)"AndroidManifest.xml", (Object)file2.getName()));
        }
        if (fileType2 == FileTypes.PLAIN_TEXT) {
            return super.canAnnotate(file2, module2);
        }
        if (GradleFileTypeKt.isGradleFile((PsiFile)file2)) {
            com.intellij.openapi.project.Project project = file2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"file.project");
            com.intellij.openapi.project.Project project2 = project;
            if (ProjectSystemUtil.requiresAndroidModel(project2)) {
                AndroidFileChangeListener.getInstance(project2);
            }
            return true;
        }
        return false;
    }

    public boolean canAnalyze(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return ProjectFacetManager.getInstance((com.intellij.openapi.project.Project)project).hasFacets(AndroidFacet.ID);
    }

    @NotNull
    public List<Project> createProject(@NotNull LintIdeClient client2, @Nullable List<? extends VirtualFile> files2, Module ... modules2) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter((Object)modules2, (String)"modules");
        List<Project> list2 = AndroidLintIdeProject.create(client2, files2, Arrays.copyOf(modules2, modules2.length));
        Intrinsics.checkNotNullExpressionValue(list2, (String)"create(client, files, *modules)");
        return list2;
    }

    @NotNull
    public Pair<Project, Project> createProjectForSingleFile(@NotNull LintIdeClient client2, @Nullable VirtualFile file2, @NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Pair<Project, Project> pair = AndroidLintIdeProject.createForSingleFile(client2, file2, module2);
        Intrinsics.checkNotNullExpressionValue(pair, (String)"createForSingleFile(client, file, module)");
        return pair;
    }

    @NotNull
    public LintIdeClient createClient(@NotNull com.intellij.openapi.project.Project project, @NotNull LintResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        return new AndroidLintIdeClient(project, lintResult);
    }

    @NotNull
    public LintIdeClient createBatchClient(@NotNull LintBatchResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        return new AndroidLintIdeClient(lintResult.getProject(), (LintResult)lintResult);
    }

    @NotNull
    public LintIdeClient createEditorClient(@NotNull LintEditorResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        return new AndroidLintIdeClient(lintResult.getModule().getProject(), (LintResult)lintResult);
    }

    public void updateToLatest(@NotNull Module module2, @NotNull GradleCoordinate gc) {
        GradleCoordinate latest;
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        StudioSdkUtil.reloadRemoteSdkWithModalProgress();
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"getInstance().tryToChooseSdkHandler()");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        StudioLoggerProgressIndicator progress2 = new StudioLoggerProgressIndicator(AndroidLintIdeSupport.class);
        RepoPackage p = SdkMavenRepository.findLatestVersion((GradleCoordinate)gc, (AndroidSdkHandler)sdkHandler, null, (ProgressIndicator)((ProgressIndicator)progress2));
        if (p != null && (latest = SdkMavenRepository.getCoordinateFromSdkPath((String)p.getPath())) != null) {
            ProjectSystemUtil.getModuleSystem(module2).updateLibrariesToVersion(CollectionsKt.listOf((Object)latest));
            com.intellij.openapi.project.Project project = module2.getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"module.project");
            ProjectSystemUtil.getProjectSystem(project).getSyncManager().syncProject(ProjectSystemSyncManager.SyncReason.PROJECT_DEPENDENCY_UPDATED);
        }
    }

    @Nullable
    public AgpVersion recommendedAgpVersion(@NotNull com.intellij.openapi.project.Project project) {
        AgpVersion agpVersion;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        AndroidPluginInfo androidPluginInfo = GradlePluginUpgrade.findPluginInfo(project);
        if (androidPluginInfo == null || (androidPluginInfo = androidPluginInfo.getPluginVersion()) == null) {
            return null;
        }
        AndroidPluginInfo current = androidPluginInfo;
        String string = LatestKnownPluginVersionProvider.INSTANCE.get();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"INSTANCE.get()");
        AgpVersion latestKnown = AgpVersion.Companion.parse(string);
        Set published = IdeGoogleMavenRepository.INSTANCE.getAgpVersions();
        GradlePluginUpgradeState state2 = GradlePluginUpgrade.computeGradlePluginUpgradeState((AgpVersion)current, latestKnown, published);
        switch (WhenMappings.$EnumSwitchMapping$0[state2.getImportance().ordinal()]) {
            case 1: 
            case 2: {
                agpVersion = state2.getTarget();
                break;
            }
            default: {
                agpVersion = null;
            }
        }
        return agpVersion;
    }

    public boolean shouldRecommendUpdateAgpToLatest(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return GradlePluginUpgrade.shouldRecommendPluginUpgrade(project).getUpgrade();
    }

    public void updateAgpToLatest(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project){
            final /* synthetic */ com.intellij.openapi.project.Project $project;
            {
                this.$project = $project;
            }

            public final void run() {
                GradlePluginUpgrade.performRecommendedPluginUpgrade$default(this.$project, null, null, 6, null);
            }
        });
    }

    public boolean shouldOfferUpgradeAssistantForDeprecatedConfigurations(@NotNull com.intellij.openapi.project.Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return true;
    }

    public void updateDeprecatedConfigurations(@NotNull com.intellij.openapi.project.Project project, @NotNull PsiElement element2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        ApplicationManager.getApplication().executeOnPooledThread(new Runnable(project, element2){
            final /* synthetic */ com.intellij.openapi.project.Project $project;
            final /* synthetic */ PsiElement $element;
            {
                this.$project = $project;
                this.$element = $element;
            }

            public final void run() {
                ((AssistantInvoker)this.$project.getService(AssistantInvoker.class)).performDeprecatedConfigurationsUpgrade(this.$project, this.$element);
            }
        });
    }

    @Nullable
    public String resolveDynamic(@NotNull com.intellij.openapi.project.Project project, @NotNull GradleCoordinate gc) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)gc, (String)"gc");
        AndroidSdkHandler androidSdkHandler = AndroidSdks.getInstance().tryToChooseSdkHandler();
        Intrinsics.checkNotNullExpressionValue((Object)androidSdkHandler, (String)"getInstance().tryToChooseSdkHandler()");
        AndroidSdkHandler sdkHandler = androidSdkHandler;
        return RepositoryUrlManager.Companion.get().resolveDynamicCoordinateVersion(gc, project, sdkHandler);
    }

    @NotNull
    public EnumSet<Platform> getPlatforms() {
        return Platform.ANDROID_SET;
    }

    public boolean canRequestFeedback() {
        return ProvideLintFeedbackPanel.canRequestFeedback();
    }

    @NotNull
    public LocalQuickFix requestFeedbackFix(@NotNull Issue issue2) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        return new ProvideLintFeedbackFix(issue2.getId());
    }

    @NotNull
    public IntentionAction requestFeedbackIntentionAction(@NotNull Issue issue2) {
        Intrinsics.checkNotNullParameter((Object)issue2, (String)"issue");
        return new ProvideLintFeedbackIntentionAction(issue2.getId());
    }

    @NotNull
    public final Random getRandom() {
        return this.random;
    }

    public void logSession(@NotNull LintDriver lint, @NotNull LintEditorResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lint, (String)"lint");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        if (this.random.nextDouble() < 0.01) {
            com.intellij.openapi.project.Project project = lintResult.getModule().getProject();
            Intrinsics.checkNotNullExpressionValue((Object)project, (String)"lintResult.getModule().project");
            LintIdeAnalytics analytics = new LintIdeAnalytics(project);
            analytics.logSession(LintSession.AnalysisType.IDE_FILE, lint, lintResult.getModule(), lintResult.getProblems(), null);
        }
    }

    public void logSession(@NotNull LintDriver lint, @Nullable Module module2, @NotNull LintBatchResult lintResult) {
        Intrinsics.checkNotNullParameter((Object)lint, (String)"lint");
        Intrinsics.checkNotNullParameter((Object)lintResult, (String)"lintResult");
        LintIdeAnalytics analytics = new LintIdeAnalytics(lintResult.getProject());
        analytics.logSession(LintSession.AnalysisType.IDE_BATCH, lint, module2, null, lintResult.getProblemMap());
    }

    @NotNull
    public String ensureNamespaceImported(@NotNull XmlFile file2, @NotNull String namespaceUri, @Nullable String suggestedPrefix) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)namespaceUri, (String)"namespaceUri");
        return IdeResourcesUtil.ensureNamespaceImported(file2, namespaceUri, suggestedPrefix);
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[GradlePluginUpgradeState.Importance.values().length];
            nArray[GradlePluginUpgradeState.Importance.RECOMMEND.ordinal()] = 1;
            nArray[GradlePluginUpgradeState.Importance.STRONGLY_RECOMMEND.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

