/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.layoutinspector.ui.RenderModel;
import com.android.tools.idea.layoutinspector.ui.RenderModelKt;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDialog;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTypeDescriptor;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import icons.StudioIcons;
import java.awt.Image;
import java.io.IOException;
import javax.imageio.ImageIO;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0010\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u0010\f\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\r"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/ToggleOverlayAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "()V", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "loadImageFile", "Ljava/awt/Image;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "loadOverlay", "update", "intellij.android.layout-inspector"})
public final class ToggleOverlayAction
extends AnAction {
    @NotNull
    public static final ToggleOverlayAction INSTANCE = new ToggleOverlayAction();

    private ToggleOverlayAction() {
        super(StudioIcons.LayoutInspector.LOAD_OVERLAY);
    }

    public void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        super.update(e);
        RenderModel renderModel = (RenderModel)e.getData(RenderModelKt.getDEVICE_VIEW_MODEL_KEY());
        if (renderModel == null) {
            return;
        }
        RenderModel model2 = renderModel;
        if (model2.getOverlay() != null) {
            e.getPresentation().setIcon(StudioIcons.LayoutInspector.CLEAR_OVERLAY);
            e.getPresentation().setText("Clear Overlay");
        } else {
            e.getPresentation().setIcon(StudioIcons.LayoutInspector.LOAD_OVERLAY);
            e.getPresentation().setText("Load Overlay");
        }
        e.getPresentation().setEnabled(model2.isActive());
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        RenderModel renderModel = (RenderModel)e.getData(RenderModelKt.getDEVICE_VIEW_MODEL_KEY());
        if (renderModel == null) {
            return;
        }
        RenderModel model2 = renderModel;
        if (model2.getOverlay() != null) {
            model2.setOverlay(null);
        } else {
            this.loadOverlay(e);
        }
    }

    private final void loadOverlay(AnActionEvent e) {
        boolean bl;
        RenderModel renderModel = (RenderModel)e.getData(RenderModelKt.getDEVICE_VIEW_MODEL_KEY());
        if (renderModel == null) {
            return;
        }
        RenderModel model2 = renderModel;
        String[] stringArray = new String[]{"svg", "png", "jpg"};
        FileTypeDescriptor descriptor2 = new FileTypeDescriptor("Choose Overlay", stringArray);
        FileChooserDialog fileChooserDialog = FileChooserFactory.getInstance().createFileChooser((FileChooserDescriptor)descriptor2, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)fileChooserDialog, (String)"getInstance().createFile\u2026r(descriptor, null, null)");
        FileChooserDialog fileChooserDialog2 = fileChooserDialog;
        LocalFileSystem localFileSystem = LocalFileSystem.getInstance();
        Object object = e.getProject();
        if (object == null || (object = object.getBasePath()) == null) {
            object = "/";
        }
        VirtualFile toSelect = localFileSystem.refreshAndFindFileByPath((String)object);
        VirtualFile[] virtualFileArray = new VirtualFile[1];
        Intrinsics.checkNotNull((Object)toSelect);
        VirtualFile[] files2 = fileChooserDialog2.choose(null, virtualFileArray);
        Intrinsics.checkNotNullExpressionValue((Object)files2, (String)"files");
        if (files2.length == 0) {
            return;
        }
        boolean bl2 = bl = files2.length == 1;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        VirtualFile virtualFile = files2[0];
        Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"files[0]");
        model2.setOverlay(this.loadImageFile(virtualFile));
    }

    private final Image loadImageFile(VirtualFile file2) {
        Image image;
        try {
            image = ImageIO.read(file2.getInputStream());
        }
        catch (IOException e) {
            Messages.showErrorDialog((String)("Failed to read image from \"" + file2.getName() + "\" Error: " + e.getMessage()), (String)"Error");
            return null;
        }
        return image;
    }
}

