/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.ui.RenderModel;
import com.android.tools.idea.layoutinspector.ui.RenderModelKt;
import com.android.tools.idea.layoutinspector.ui.Toggle3dAction;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.actionSystem.ex.TooltipLinkProvider;
import icons.StudioIcons;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0012\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018H\u0016J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R,\u0010\u0005\u001a\u0010\u0012\f\u0012\n \b*\u0004\u0018\u00010\u00070\u00070\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000e0\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000f\u0010\n\"\u0004\b\u0010\u0010\f\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/Toggle3dAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/ex/TooltipLinkProvider;", "Lcom/intellij/openapi/actionSystem/ex/TooltipDescriptionProvider;", "()V", "executorFactory", "Lkotlin/Function0;", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "getExecutorFactory", "()Lkotlin/jvm/functions/Function0;", "setExecutorFactory", "(Lkotlin/jvm/functions/Function0;)V", "getCurrentTimeMillis", "", "getGetCurrentTimeMillis", "setGetCurrentTimeMillis", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getTooltipLink", "Lcom/intellij/openapi/actionSystem/ex/TooltipLinkProvider$TooltipLink;", "owner", "Ljavax/swing/JComponent;", "update", "intellij.android.layout-inspector"})
public final class Toggle3dAction
extends AnAction
implements TooltipLinkProvider,
TooltipDescriptionProvider {
    @NotNull
    public static final Toggle3dAction INSTANCE = new Toggle3dAction();
    @VisibleForTesting
    @NotNull
    private static Function0<? extends ScheduledExecutorService> executorFactory = executorFactory.1.INSTANCE;
    @VisibleForTesting
    @NotNull
    private static Function0<Long> getCurrentTimeMillis = getCurrentTimeMillis.1.INSTANCE;

    private Toggle3dAction() {
        super(StudioIcons.LayoutInspector.MODE_3D);
    }

    @NotNull
    public final Function0<ScheduledExecutorService> getExecutorFactory() {
        return executorFactory;
    }

    public final void setExecutorFactory(@NotNull Function0<? extends ScheduledExecutorService> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        executorFactory = function0;
    }

    @NotNull
    public final Function0<Long> getGetCurrentTimeMillis() {
        return getCurrentTimeMillis;
    }

    public final void setGetCurrentTimeMillis(@NotNull Function0<Long> function0) {
        Intrinsics.checkNotNullParameter(function0, (String)"<set-?>");
        getCurrentTimeMillis = function0;
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        InspectorClient client2;
        LayoutInspector inspector;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        RenderModel renderModel = (RenderModel)event.getData(RenderModelKt.getDEVICE_VIEW_MODEL_KEY());
        if (renderModel == null) {
            return;
        }
        RenderModel model2 = renderModel;
        LayoutInspector layoutInspector = inspector = LayoutInspector.Companion.get(event);
        InspectorClient inspectorClient = client2 = layoutInspector != null ? layoutInspector.getCurrentClient() : null;
        if (model2.isRotated()) {
            model2.resetRotation();
        } else {
            InspectorClient inspectorClient2 = client2;
            if (inspectorClient2 != null) {
                inspectorClient2.updateScreenshotType(AndroidWindow.ImageType.SKP, -1.0f);
            }
            long timerStart = ((Number)getCurrentTimeMillis.invoke()).longValue();
            ScheduledExecutorService executor2 = (ScheduledExecutorService)executorFactory.invoke();
            Ref.IntRef iteration = new Ref.IntRef();
            executor2.scheduleAtFixedRate(new Runnable(timerStart, executor2, inspector, iteration, model2){
                final /* synthetic */ long $timerStart;
                final /* synthetic */ ScheduledExecutorService $executor;
                final /* synthetic */ LayoutInspector $inspector;
                final /* synthetic */ Ref.IntRef $iteration;
                final /* synthetic */ RenderModel $model;
                {
                    this.$timerStart = $timerStart;
                    this.$executor = $executor;
                    this.$inspector = $inspector;
                    this.$iteration = $iteration;
                    this.$model = $model;
                }

                public final void run() {
                    InspectorModel inspectorModel;
                    long currentTime = ((Number)Toggle3dAction.INSTANCE.getGetCurrentTimeMillis().invoke()).longValue();
                    if (currentTime - this.$timerStart > 10000L) {
                        this.$executor.shutdown();
                        return;
                    }
                    LayoutInspector layoutInspector = this.$inspector;
                    InspectorModel inspectorModel2 = inspectorModel = layoutInspector != null ? layoutInspector.getLayoutInspectorModel() : null;
                    if ((inspectorModel2 != null ? inspectorModel2.getPictureType() : null) != AndroidWindow.ImageType.SKP) {
                        return;
                    }
                    int n = this.$iteration.element;
                    this.$iteration.element = n + 1;
                    if ((long)this.$iteration.element > 20L) {
                        this.$executor.shutdown();
                        return;
                    }
                    this.$model.setXOff((double)this.$iteration.element * 0.45 / (double)20L);
                    this.$model.setYOff((double)this.$iteration.element * 0.06 / (double)20L);
                    this.$model.refresh();
                }
            }, 0L, 15L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void update(@NotNull AnActionEvent event) {
        InspectorClient client2;
        RenderModel model2;
        block4: {
            block5: {
                LayoutInspector inspector;
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                super.update(event);
                model2 = (RenderModel)event.getData(RenderModelKt.getDEVICE_VIEW_MODEL_KEY());
                LayoutInspector layoutInspector = inspector = LayoutInspector.Companion.get(event);
                client2 = layoutInspector != null ? layoutInspector.getCurrentClient() : null;
                LayoutInspector layoutInspector2 = inspector;
                InspectorModel inspectorModel = layoutInspector2 != null ? layoutInspector2.getLayoutInspectorModel() : null;
                RenderModel renderModel = model2;
                event.getPresentation().setIcon((renderModel != null ? renderModel.isRotated() : false) ? StudioIcons.LayoutInspector.RESET_VIEW : StudioIcons.LayoutInspector.MODE_3D);
                if (model2 == null || model2.getOverlay() != null) break block4;
                Object object = client2;
                boolean bl = object != null && (object = object.getCapabilities()) != null ? object.contains((Object)InspectorClient.Capability.SUPPORTS_SKP) : false;
                if (!bl) break block4;
                if (client2.isCapturing()) break block5;
                InspectorModel inspectorModel2 = inspectorModel;
                if ((inspectorModel2 != null ? inspectorModel2.getPictureType() : null) != AndroidWindow.ImageType.SKP) break block4;
            }
            event.getPresentation().setEnabled(true);
            if (model2.isRotated()) {
                event.getPresentation().setText("2D Mode");
                event.getPresentation().setDescription("Inspect the layout in 2D mode. Enabling this mode has less impact on your device's runtime performance.");
                return;
            }
            event.getPresentation().setText("3D Mode");
            event.getPresentation().setDescription("Visually inspect the hierarchy by clicking and dragging to rotate the layout. Enabling this mode consumes more device resources and might impact runtime performance.");
            return;
        }
        event.getPresentation().setEnabled(false);
        boolean isLowerThenApi29 = client2 != null && client2.isConnected() && client2.getProcess().getDevice().getApiLevel() < 29;
        RenderModel renderModel = model2;
        event.getPresentation().setText((renderModel != null ? renderModel.getOverlay() : null) != null ? "Rotation not available when overlay is active" : (isLowerThenApi29 ? "Rotation not available for devices below API 29" : "Error while rendering device image, rotation not available"));
    }

    @NotNull
    public TooltipLinkProvider.TooltipLink getTooltipLink(@Nullable JComponent owner) {
        return new TooltipLinkProvider.TooltipLink("Learn More", (Runnable)getTooltipLink.1.INSTANCE);
    }
}

