/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.ComposeViewNode;
import com.android.tools.idea.layoutinspector.model.DrawViewChild;
import com.android.tools.idea.layoutinspector.model.DrawViewNode;
import com.android.tools.idea.layoutinspector.model.DrawViewNodeKt;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.RecompositionData;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.ui.RenderLogicKt;
import com.android.tools.idea.layoutinspector.ui.RenderModel;
import com.android.tools.idea.layoutinspector.ui.RenderSettings;
import com.android.tools.idea.layoutinspector.ui.ViewDrawInfo;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.ui.JBUI;
import icons.StudioIcons;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u001e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J \u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002J\u0018\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00162\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010\u0017\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/RenderLogic;", "", "renderModel", "Lcom/android/tools/idea/layoutinspector/ui/RenderModel;", "renderSettings", "Lcom/android/tools/idea/layoutinspector/ui/RenderSettings;", "(Lcom/android/tools/idea/layoutinspector/ui/RenderModel;Lcom/android/tools/idea/layoutinspector/ui/RenderSettings;)V", "inspectorModel", "Lcom/android/tools/idea/layoutinspector/model/InspectorModel;", "renderBorders", "", "g", "Ljava/awt/Graphics2D;", "drawInfo", "Lcom/android/tools/idea/layoutinspector/ui/ViewDrawInfo;", "component", "Ljava/awt/Component;", "foregroundColor", "Ljava/awt/Color;", "renderFold", "g2", "renderImages", "Ljava/awt/Graphics;", "renderOverlay", "intellij.android.layout-inspector"})
public final class RenderLogic {
    @NotNull
    private final RenderModel renderModel;
    @NotNull
    private final RenderSettings renderSettings;
    @NotNull
    private final InspectorModel inspectorModel;

    public RenderLogic(@NotNull RenderModel renderModel, @NotNull RenderSettings renderSettings) {
        Intrinsics.checkNotNullParameter((Object)renderModel, (String)"renderModel");
        Intrinsics.checkNotNullParameter((Object)renderSettings, (String)"renderSettings");
        this.renderModel = renderModel;
        this.renderSettings = renderSettings;
        this.inspectorModel = this.renderModel.getModel();
    }

    public final void renderImages(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Iterable $this$forEach$iv = this.renderModel.getHitRects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewDrawInfo it = (ViewDrawInfo)element$iv;
            boolean bl = false;
            this.renderImages(g, it);
        }
    }

    public final void renderBorders(@NotNull Graphics2D g, @NotNull Component component2, @NotNull Color foregroundColor) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)component2, (String)"component");
        Intrinsics.checkNotNullParameter((Object)foregroundColor, (String)"foregroundColor");
        Iterable $this$forEach$iv = this.renderModel.getHitRects();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ViewDrawInfo viewDrawInfo = (ViewDrawInfo)element$iv;
            boolean bl = false;
            this.renderBorders(g, viewDrawInfo, component2, foregroundColor);
        }
    }

    public final void renderOverlay(@NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        if (this.renderModel.getOverlay() == null) {
            return;
        }
        g.setComposite(AlphaComposite.SrcOver.derive(this.renderModel.getOverlayAlpha()));
        Rectangle bounds = this.renderModel.getHitRects().get(0).getBounds().getBounds();
        g.drawImage(this.renderModel.getOverlay(), bounds.x, bounds.y, bounds.width, bounds.height, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderImages(Graphics g, ViewDrawInfo drawInfo) {
        void $this$renderImages_u24lambda_u2d2;
        AffineTransform affineTransform;
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        g2.setRenderingHints(RenderLogicKt.access$getHQ_RENDERING_HINTS$p());
        AffineTransform affineTransform2 = affineTransform = g2.getTransform();
        Graphics2D graphics2D = g2;
        boolean bl = false;
        $this$renderImages_u24lambda_u2d2.concatenate(drawInfo.getTransform());
        graphics2D.setTransform(affineTransform);
        drawInfo.getNode().paint(g2, this.inspectorModel);
    }

    /*
     * WARNING - void declaration
     */
    private final void renderBorders(Graphics2D g, ViewDrawInfo drawInfo, Component component2, Color foregroundColor) {
        Graphics2D g2;
        ViewNode view;
        DrawViewNode drawView;
        block4: {
            ViewNode selection;
            ViewNode hoveredNode;
            block5: {
                void $this$renderBorders_u24lambda_u2d3;
                AffineTransform affineTransform;
                hoveredNode = this.inspectorModel.getHoveredNode();
                drawView = drawInfo.getNode();
                view = drawView.findFilteredOwner(this.renderModel.getTreeSettings());
                selection = this.inspectorModel.getSelection();
                Graphics graphics = g.create();
                Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
                g2 = (Graphics2D)graphics;
                g2.setRenderingHints(RenderLogicKt.access$getHQ_RENDERING_HINTS$p());
                AffineTransform affineTransform2 = affineTransform = g2.getTransform();
                Graphics2D graphics2D = g2;
                boolean bl = false;
                $this$renderBorders_u24lambda_u2d3.concatenate(drawInfo.getTransform());
                graphics2D.setTransform(affineTransform);
                if (drawInfo.isCollapsed()) break block4;
                if (this.renderSettings.getDrawBorders() || this.renderSettings.getDrawUntransformedBounds() || Intrinsics.areEqual((Object)view, (Object)selection) || Intrinsics.areEqual((Object)view, (Object)hoveredNode)) break block5;
                if (!this.renderModel.getTreeSettings().getShowRecompositions()) break block4;
                Object object = view instanceof ComposeViewNode ? (ComposeViewNode)view : null;
                boolean bl2 = object != null && (object = ((ComposeViewNode)object).getRecompositions()) != null ? ((RecompositionData)object).getHasHighlight() : false;
                if (!bl2 || this.inspectorModel.getMaxHighlight() == 0.0f) break block4;
            }
            drawView.paintBorder(g2, Intrinsics.areEqual((Object)view, (Object)selection), Intrinsics.areEqual((Object)view, (Object)hoveredNode), this.inspectorModel, this.renderSettings, this.renderModel.getTreeSettings());
        }
        if (this.renderSettings.getDrawFold() && !((Collection)this.renderModel.getHitRects()).isEmpty() && (this.renderModel.getHoveredDrawInfo() == null && this.inspectorModel.getSelection() == null && Intrinsics.areEqual((Object)drawInfo, (Object)CollectionsKt.first(this.renderModel.getHitRects())) || Intrinsics.areEqual((Object)this.renderModel.getHoveredDrawInfo(), (Object)drawInfo) || this.renderModel.getHoveredDrawInfo() == null && view != null && Intrinsics.areEqual((Object)this.inspectorModel.getSelection(), (Object)view) && drawView instanceof DrawViewChild)) {
            this.renderFold(g2, component2, foregroundColor);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void renderFold(Graphics2D g2, Component component2, Color foregroundColor) {
        Graphics2D it3;
        Object object;
        void $this$mapTo$iv$iv;
        Collection collection2;
        void $this$mapTo$iv$iv2;
        g2.setColor(new Color(255, 0, 255));
        g2.setStroke(DrawViewNodeKt.getFoldStroke(this.renderSettings.getScaleFraction()));
        InspectorModel.FoldInfo foldInfo = this.inspectorModel.getFoldInfo();
        if (foldInfo == null) {
            return;
        }
        InspectorModel.FoldInfo foldInfo2 = foldInfo;
        Collection<AndroidWindow> collection3 = this.inspectorModel.getWindows().values();
        Intrinsics.checkNotNullExpressionValue(collection3, (String)"inspectorModel.windows.values");
        Iterable $this$map$iv = collection3;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Iterable destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv2) {
            void it2;
            AndroidWindow androidWindow = (AndroidWindow)item$iv$iv;
            collection2 = destination$iv$iv;
            boolean bl = false;
            collection2.add(it2.getWidth());
        }
        Integer n = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv));
        int maxWidth = n != null ? n : 0;
        Collection<AndroidWindow> collection4 = this.inspectorModel.getWindows().values();
        Intrinsics.checkNotNullExpressionValue(collection4, (String)"inspectorModel.windows.values");
        Iterable $this$map$iv2 = collection4;
        boolean $i$f$map2 = false;
        destination$iv$iv = $this$map$iv2;
        Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
        boolean $i$f$mapTo2 = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it3;
            AndroidWindow bl = (AndroidWindow)item$iv$iv;
            collection2 = destination$iv$iv2;
            boolean bl2 = false;
            collection2.add(it3.getHeight());
        }
        Integer n2 = (Integer)CollectionsKt.maxOrNull((Iterable)((List)destination$iv$iv2));
        int maxHeight = n2 != null ? n2 : 0;
        float startX = 0.0f;
        float startY = 0.0f;
        float endX = 0.0f;
        float endY = 0.0f;
        if (foldInfo2.getAngle() == null) {
            object = "";
        } else {
            Integer n3 = foldInfo2.getAngle();
            object = (n3 != null ? n3.toString() : null) + "\u00b0";
        }
        String angleText = (String)object + " " + foldInfo2.getPosture();
        Point labelPosition = new Point();
        Icon icon2 = StudioIcons.LayoutInspector.DEGREE;
        g2.setFont((Font)JBUI.Fonts.label((float)10.0f));
        Graphics graphics = g2.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D $this$renderFold_u24lambda_u2d6 = it3 = (Graphics2D)graphics;
        boolean bl = false;
        $this$renderFold_u24lambda_u2d6.setTransform(new AffineTransform());
        Graphics2D labelGraphics = it3;
        int iconTextGap = JBUIScale.scale((int)4);
        int labelLineGap = JBUIScale.scale((int)7);
        float lineExtensionLength = JBUIScale.scale((float)70.0f);
        switch (WhenMappings.$EnumSwitchMapping$0[foldInfo2.getOrientation().ordinal()]) {
            case 1: {
                startX = -lineExtensionLength;
                endX = (float)maxWidth + lineExtensionLength;
                startY = (float)maxHeight / 2.0f;
                endY = (float)maxHeight / 2.0f;
                Point2D transformed = g2.getTransform().transform(new Point2D.Float(startX, startY), null);
                labelPosition.x = (int)transformed.getX() - labelGraphics.getFontMetrics().stringWidth(angleText) - icon2.getIconWidth() - iconTextGap - labelLineGap;
                labelPosition.y = (int)transformed.getY() - icon2.getIconHeight() / 2;
                break;
            }
            case 2: {
                startX = (float)maxWidth / 2.0f;
                endX = (float)maxWidth / 2.0f;
                startY = -lineExtensionLength;
                endY = (float)maxHeight + lineExtensionLength;
                Point2D transformed = g2.getTransform().transform(new Point2D.Float(startX, startY), null);
                labelPosition.x = (int)transformed.getX() - (labelGraphics.getFontMetrics().stringWidth(angleText) + icon2.getIconWidth() + iconTextGap) / 2;
                labelPosition.y = (int)transformed.getY() - icon2.getIconHeight() - labelLineGap;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        g2.draw(new Line2D.Float(startX, startY, endX, endY));
        labelGraphics.setColor((Color)JBColor.white);
        int labelBorder = JBUIScale.scale((int)3);
        labelGraphics.fillRoundRect(labelPosition.x - labelBorder, labelPosition.y - labelBorder, labelGraphics.getFontMetrics().stringWidth(angleText) + icon2.getIconWidth() + iconTextGap + labelBorder * 2, icon2.getIconHeight() + labelBorder * 2, JBUIScale.scale((int)5), JBUIScale.scale((int)5));
        labelGraphics.setColor(foregroundColor);
        icon2.paintIcon(component2, labelGraphics, labelPosition.x, labelPosition.y);
        labelGraphics.drawString(angleText, labelPosition.x + icon2.getIconWidth() + iconTextGap, labelPosition.y + labelGraphics.getFontMetrics().getMaxAscent());
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[InspectorModel.FoldOrientation.values().length];
            nArray[InspectorModel.FoldOrientation.HORIZONTAL.ordinal()] = 1;
            nArray[InspectorModel.FoldOrientation.VERTICAL.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

