/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.android.tools.idea.layoutinspector.tree.TreeViewNode;
import com.intellij.ui.JBColor;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.ui.tree.ui.Control;
import com.intellij.ui.treeStructure.Tree;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\u0002\u0010\u0003J(\u0010\u0006\u001a\u00020\u00072\r\b\u0001\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0096\u0001J$\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0007J(\u0010\u0015\u001a\u00020\u00072\r\b\u0001\u0010\b\u001a\u00070\t\u00a2\u0006\u0002\b\n2\u0006\u0010\u000b\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\rH\u0096\u0001J\u0010\u0010\u0016\u001a\u00020\u000f2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J`\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010!\u001a\u00020\u00072\u0006\u0010\"\u001a\u00020\u00072\u0006\u0010#\u001a\u00020\t2\u0006\u0010$\u001a\u00020\u00072\u0006\u0010%\u001a\u00020\r2\u0006\u0010&\u001a\u00020\r2\u0006\u0010'\u001a\u00020\rH\u0016R\u0011\u0010\u0002\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0004\u0010\u0005\u00a8\u0006("}, d2={"Lcom/android/tools/idea/layoutinspector/ui/LinePainter;", "Lcom/intellij/ui/tree/ui/Control$Painter;", "basePainter", "(Lcom/intellij/ui/tree/ui/Control$Painter;)V", "getBasePainter", "()Lcom/intellij/ui/tree/ui/Control$Painter;", "getControlOffset", "", "p0", "Lcom/intellij/ui/tree/ui/Control;", "Lorg/jetbrains/annotations/NotNull;", "p1", "p2", "", "getLastOfMultipleChildren", "Lcom/android/tools/idea/layoutinspector/tree/TreeViewNode;", "model", "Ljavax/swing/tree/TreeModel;", "treeSettings", "Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "node", "getRendererOffset", "nodeOf", "path", "Ljavax/swing/tree/TreePath;", "paint", "", "c", "Ljava/awt/Component;", "g", "Ljava/awt/Graphics;", "x", "y", "width", "height", "control", "depth", "leaf", "expanded", "selected", "intellij.android.layout-inspector"})
public final class LinePainter
implements Control.Painter {
    @NotNull
    private final Control.Painter basePainter;

    public LinePainter(@NotNull Control.Painter basePainter) {
        Intrinsics.checkNotNullParameter((Object)basePainter, (String)"basePainter");
        this.basePainter = basePainter;
    }

    @NotNull
    public final Control.Painter getBasePainter() {
        return this.basePainter;
    }

    public int getControlOffset(@NotNull Control p0, int p1, boolean p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return this.basePainter.getControlOffset(p0, p1, p2);
    }

    public int getRendererOffset(@NotNull Control p0, int p1, boolean p2) {
        Intrinsics.checkNotNullParameter((Object)p0, (String)"p0");
        return this.basePainter.getRendererOffset(p0, p1, p2);
    }

    public void paint(@NotNull Component c, @NotNull Graphics g, int x, int y, int width, int height, @NotNull Control control, int depth, boolean leaf, boolean expanded, boolean selected) {
        Intrinsics.checkNotNullParameter((Object)c, (String)"c");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Intrinsics.checkNotNullParameter((Object)control, (String)"control");
        Tree tree2 = (Tree)c;
        LayoutInspector layoutInspector = LayoutInspector.Companion.get((Component)tree2);
        TreeSettings treeSettings2 = layoutInspector != null ? layoutInspector.getTreeSettings() : null;
        TreePath treePath = tree2.getClosestPathForLocation(x + width / 2, y + height / 2);
        if (treePath == null) {
            return;
        }
        TreePath path2 = treePath;
        this.basePainter.paint(c, g, x, y, width, height, control, depth, leaf, expanded, selected);
        g.setColor((Color)JBColor.GRAY);
        TreeModel model2 = tree2.getModel();
        if ((depth == 0 || depth == 1 && !tree2.isRootVisible()) && !tree2.getShowsRootHandles()) {
            return;
        }
        TreeViewNode node = this.nodeOf(path2);
        TreePath parent2 = path2.getParentPath();
        Intrinsics.checkNotNullExpressionValue((Object)model2, (String)"model");
        TreePath treePath2 = parent2;
        Intrinsics.checkNotNullExpressionValue((Object)treePath2, (String)"parent");
        TreeViewNode lastNode = this.getLastOfMultipleChildren(model2, treeSettings2, this.nodeOf(treePath2));
        int indent = this.getControlOffset(control, 2, false) - this.getControlOffset(control, 1, false);
        int spaceForControlLine = indent - control.getWidth() / 2 - JBUIScale.scale((int)4);
        if (depth > 1 && lastNode != null && spaceForControlLine > JBUIScale.scale((int)4)) {
            int rightX;
            int lineY = y + height / 2;
            int leftX = x + this.getControlOffset(control, depth - 1, false) + control.getWidth() / 2;
            if (leftX < (rightX = x + (leaf ? this.getRendererOffset(control, depth, true) : this.getControlOffset(control, depth, false)) - JBUIScale.scale((int)4))) {
                g.drawLine(leftX, lineY, rightX, lineY);
            }
        }
        boolean directChild = true;
        for (int lineDepth = depth - 1; parent2 != null && lineDepth > 0; --lineDepth) {
            if (lastNode != null && (node != lastNode || directChild)) {
                int xMid = x + this.getControlOffset(control, lineDepth, false) + control.getWidth() / 2;
                int bottom = node == lastNode ? y + height / 2 : y + height;
                g.drawLine(xMid, y, xMid, bottom);
            }
            node = this.nodeOf(parent2);
            TreePath treePath3 = parent2 = parent2.getParentPath();
            Intrinsics.checkNotNullExpressionValue((Object)treePath3, (String)"parent");
            lastNode = this.getLastOfMultipleChildren(model2, treeSettings2, this.nodeOf(treePath3));
            directChild = false;
        }
    }

    private final TreeViewNode nodeOf(TreePath path2) {
        Object object = path2.getLastPathComponent();
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.layoutinspector.tree.TreeViewNode");
        return (TreeViewNode)object;
    }

    @VisibleForTesting
    @Nullable
    public final TreeViewNode getLastOfMultipleChildren(@NotNull TreeModel model2, @Nullable TreeSettings treeSettings2, @NotNull TreeViewNode node) {
        TreeViewNode treeViewNode;
        Intrinsics.checkNotNullParameter((Object)model2, (String)"model");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        int count2 = node.getChildren().size();
        if (count2 <= 1) {
            return null;
        }
        Object object = model2.getChild(node, count2 - 1);
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type com.android.tools.idea.layoutinspector.tree.TreeViewNode");
        TreeViewNode last = (TreeViewNode)object;
        ViewNode parent2 = (ViewNode)ViewNode.Companion.readAccess((Function1)new Function1<ViewNode.ReadAccess, ViewNode>(last){
            final /* synthetic */ TreeViewNode $last;
            {
                this.$last = $last;
                super(1);
            }

            @Nullable
            public final ViewNode invoke(@NotNull ViewNode.ReadAccess $this$readAccess) {
                Intrinsics.checkNotNullParameter((Object)$this$readAccess, (String)"$this$readAccess");
                return $this$readAccess.getParent(this.$last.getView());
            }
        });
        TreeSettings treeSettings3 = treeSettings2;
        if (treeSettings3 != null) {
            TreeSettings it = treeSettings3;
            boolean bl = false;
            ViewNode viewNode = parent2;
            treeViewNode = viewNode != null && (viewNode = viewNode.findClosestUnfilteredNode(it)) != null ? viewNode.getTreeNode() : null;
        } else {
            treeViewNode = null;
        }
        return treeViewNode == node ? last : null;
    }
}

