/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.ui;

import com.android.tools.idea.layoutinspector.model.StatusNotification;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerService;
import com.google.common.annotations.VisibleForTesting;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.project.Project;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.ui.JBColor;
import com.intellij.util.ui.JBEmptyBorder;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u0002J\b\u0010\u0014\u001a\u00020\u0011H\u0002J\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0011H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\n\u001a\u00020\u000b8\u0006X\u0087\u0004\u00a2\u0006\u000e\n\u0000\u0012\u0004\b\f\u0010\r\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/layoutinspector/ui/InspectorBanner;", "Ljavax/swing/JPanel;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "actionLayout", "Ljava/awt/FlowLayout;", "actionPanel", "classInitialized", "", "text", "Ljavax/swing/JLabel;", "getText$annotations", "()V", "getText", "()Ljavax/swing/JLabel;", "applyNewNotification", "", "statusNotification", "Lcom/android/tools/idea/layoutinspector/model/StatusNotification;", "applyUISettings", "doLayout", "updateUI", "intellij.android.layout-inspector"})
public final class InspectorBanner
extends JPanel {
    @NotNull
    private final JLabel text;
    @NotNull
    private final FlowLayout actionLayout;
    @NotNull
    private final JPanel actionPanel;
    private boolean classInitialized;

    /*
     * WARNING - void declaration
     */
    public InspectorBanner(@NotNull Project project) {
        block0: {
            void $this$actionPanel_u24lambda_u2d1;
            JComponent $this$text_u24lambda_u2d0;
            JComponent jComponent;
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            super(new BorderLayout());
            JLabel jLabel = jComponent = new JLabel();
            InspectorBanner inspectorBanner = this;
            boolean bl = false;
            $this$text_u24lambda_u2d0.setName("InspectorBannerText");
            inspectorBanner.text = jComponent;
            this.actionLayout = new FlowLayout(1, JBUI.scale((int)6), 0);
            $this$text_u24lambda_u2d0 = jComponent = new JPanel(this.actionLayout);
            inspectorBanner = this;
            boolean bl2 = false;
            $this$actionPanel_u24lambda_u2d1.setName("InspectorBannerActionPanel");
            inspectorBanner.actionPanel = jComponent;
            this.classInitialized = true;
            this.setVisible(false);
            this.add((Component)this.text, "West");
            this.add((Component)this.actionPanel, "East");
            this.applyUISettings();
            Object object = InspectorBannerService.Companion.getInstance(project);
            if (object == null || (object = ((InspectorBannerService)object).getNotificationListeners()) == null) break block0;
            object.add(new Function1<StatusNotification, Unit>((Object)this){

                public final void invoke(@Nullable StatusNotification p0) {
                    ((InspectorBanner)this.receiver).applyNewNotification(p0);
                }
            });
        }
    }

    @NotNull
    public final JLabel getText() {
        return this.text;
    }

    @VisibleForTesting
    public static /* synthetic */ void getText$annotations() {
    }

    private final void applyUISettings() {
        this.setBorder(JBUI.Borders.customLine((Color)JBColor.border(), (int)0, (int)0, (int)1, (int)0));
        JBEmptyBorder jBEmptyBorder = JBUI.Borders.empty((int)3, (int)6);
        Intrinsics.checkNotNullExpressionValue((Object)jBEmptyBorder, (String)"empty(VERTICAL_BORDER_SI\u2026, HORIZONTAL_BORDER_SIZE)");
        JBEmptyBorder borderSpacing = jBEmptyBorder;
        this.actionPanel.setBorder((Border)borderSpacing);
        this.actionLayout.setHgap(JBUI.scale((int)3));
        this.text.setBorder((Border)borderSpacing);
        EditorColorsScheme editorColorsScheme = EditorColorsManager.getInstance().getGlobalScheme();
        Intrinsics.checkNotNullExpressionValue((Object)editorColorsScheme, (String)"getInstance().globalScheme");
        EditorColorsScheme globalScheme = editorColorsScheme;
        this.setBackground(globalScheme.getColor(EditorColors.NOTIFICATION_BACKGROUND));
        this.actionPanel.setBackground(this.getBackground());
    }

    @Override
    public void updateUI() {
        super.updateUI();
        if (this.classInitialized) {
            this.applyUISettings();
        }
    }

    private final void applyNewNotification(StatusNotification statusNotification) {
        boolean $i$f$invokeLater = false;
        ApplicationManager.getApplication().invokeLater(new Runnable(this, statusNotification){
            final /* synthetic */ InspectorBanner this$0;
            final /* synthetic */ StatusNotification $statusNotification$inlined;
            {
                this.this$0 = inspectorBanner;
                this.$statusNotification$inlined = statusNotification;
            }

            public final void run() {
                boolean bl = false;
                this.this$0.setVisible(this.$statusNotification$inlined != null);
                if (this.$statusNotification$inlined != null) {
                    StatusNotification notification = this.$statusNotification$inlined;
                    this.this$0.getText().setText(notification.getMessage());
                    InspectorBanner.access$getActionPanel$p(this.this$0).removeAll();
                    Iterable $this$forEach$iv = notification.getActions();
                    boolean $i$f$forEach = false;
                    for (T element$iv : $this$forEach$iv) {
                        AnAction action2 = (AnAction)element$iv;
                        boolean bl2 = false;
                        HyperlinkLabel actionLabel = new HyperlinkLabel(action2.getTemplateText(), (Color)JBColor.BLUE);
                        actionLabel.addHyperlinkListener(new HyperlinkListener(actionLabel, action2){
                            final /* synthetic */ HyperlinkLabel $actionLabel;
                            final /* synthetic */ AnAction $action;
                            {
                                this.$actionLabel = $actionLabel;
                                this.$action = $action;
                            }

                            public final void hyperlinkUpdate(HyperlinkEvent it) {
                                DataContext dataContext = DataManager.getInstance().getDataContext((Component)this.$actionLabel);
                                Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"getInstance().getDataContext(actionLabel)");
                                DataContext context2 = dataContext;
                                Presentation presentation = this.$action.getTemplatePresentation().clone();
                                Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"action.templatePresentation.clone()");
                                Presentation presentation2 = presentation;
                                AnActionEvent event = new AnActionEvent(it.getInputEvent(), context2, "Notification", presentation2, ActionManager.getInstance(), 0);
                                this.$action.actionPerformed(event);
                            }
                        });
                        InspectorBanner.access$getActionPanel$p(this.this$0).add((Component)actionLabel);
                    }
                }
            }
        });
    }

    @Override
    public void doLayout() {
        super.doLayout();
        if (this.text.getX() + this.text.getWidth() > this.actionPanel.getX()) {
            this.text.setSize(new Dimension(Math.max(0, this.actionPanel.getX() - this.text.getX()), this.text.getSize().height));
        }
    }

    public static final /* synthetic */ JPanel access$getActionPanel$p(InspectorBanner $this) {
        return $this.actionPanel;
    }
}

