/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.tree;

import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.model.InspectorModel;
import com.android.tools.idea.layoutinspector.model.SelectionOrigin;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.tree.LayoutInspectorTreePanel;
import com.android.tools.idea.layoutinspector.tree.LayoutInspectorTreePanelKt;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.android.tools.idea.layoutinspector.tree.TreeSettingsActionsKt;
import com.android.tools.idea.layoutinspector.ui.RenderModel;
import com.android.tools.idea.layoutinspector.ui.RenderModelKt;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ToggleAction;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u0004H\u0016J\u0010\u0010\n\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u0006H\u0016\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/layoutinspector/tree/SystemNodeFilterAction;", "Lcom/intellij/openapi/actionSystem/ToggleAction;", "()V", "isSelected", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "setSelected", "", "state", "update", "intellij.android.layout-inspector"})
public final class SystemNodeFilterAction
extends ToggleAction {
    @NotNull
    public static final SystemNodeFilterAction INSTANCE = new SystemNodeFilterAction();

    private SystemNodeFilterAction() {
        super("Filter System-Defined Layers");
    }

    public boolean isSelected(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        Object object = LayoutInspector.Companion.get(event);
        return object != null && (object = ((LayoutInspector)object).getTreeSettings()) != null ? object.getHideSystemNodes() : true;
    }

    public void setSelected(@NotNull AnActionEvent event, boolean state2) {
        block5: {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            LayoutInspector layoutInspector = LayoutInspector.Companion.get(event);
            if (layoutInspector == null) {
                return;
            }
            LayoutInspector inspector = layoutInspector;
            TreeSettings treeSettings2 = inspector.getTreeSettings();
            treeSettings2.setHideSystemNodes(state2);
            inspector.getCurrentClient().getStats().setHideSystemNodes(state2);
            if (state2) {
                ViewNode hoveredNode;
                InspectorModel model2 = inspector.getLayoutInspectorModel();
                ViewNode selectedNode = model2.getSelection();
                if (selectedNode != null && !selectedNode.isInComponentTree(treeSettings2)) {
                    model2.setSelection(selectedNode.findClosestUnfilteredNode(treeSettings2), SelectionOrigin.COMPONENT_TREE);
                }
                if ((hoveredNode = model2.getHoveredNode()) != null && !hoveredNode.isInComponentTree(treeSettings2)) {
                    model2.setHoveredNode(null);
                }
            }
            LayoutInspectorTreePanel layoutInspectorTreePanel = LayoutInspectorTreePanelKt.treePanel(event);
            if (layoutInspectorTreePanel != null) {
                layoutInspectorTreePanel.refresh();
            }
            RenderModel renderModel = (RenderModel)event.getData(RenderModelKt.getDEVICE_VIEW_MODEL_KEY());
            if (renderModel == null) break block5;
            renderModel.refresh();
        }
    }

    public void update(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        InspectorClient.Capability[] capabilityArray = new InspectorClient.Capability[]{InspectorClient.Capability.SUPPORTS_SYSTEM_NODES};
        event.getPresentation().setVisible(TreeSettingsActionsKt.isActionActive(event, capabilityArray));
    }
}

