/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.tree;

import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.tree.TreeSettings;
import com.intellij.ide.util.PropertiesComponent;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0013\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0013\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0007H\u0002J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J \u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\u001c\u001a\u00020\u0007H\u0002R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR$\u0010\r\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\fR\u001a\u0010\u0010\u001a\u00020\u0007X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\n\"\u0004\b\u0012\u0010\fR$\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0014\u0010\n\"\u0004\b\u0015\u0010\fR$\u0010\u0016\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u00078V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\u0017\u0010\n\"\u0004\b\u0018\u0010\f\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/layoutinspector/tree/InspectorTreeSettings;", "Lcom/android/tools/idea/layoutinspector/tree/TreeSettings;", "activeClient", "Lkotlin/Function0;", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "(Lkotlin/jvm/functions/Function0;)V", "value", "", "composeAsCallstack", "getComposeAsCallstack", "()Z", "setComposeAsCallstack", "(Z)V", "hideSystemNodes", "getHideSystemNodes", "setHideSystemNodes", "highlightSemantics", "getHighlightSemantics", "setHighlightSemantics", "showRecompositions", "getShowRecompositions", "setShowRecompositions", "supportLines", "getSupportLines", "setSupportLines", "get", "key", "", "defaultValue", "hasCapability", "capability", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient$Capability;", "set", "", "intellij.android.layout-inspector"})
public final class InspectorTreeSettings
implements TreeSettings {
    @NotNull
    private final Function0<InspectorClient> activeClient;
    private boolean highlightSemantics;

    public InspectorTreeSettings(@NotNull Function0<? extends InspectorClient> activeClient) {
        Intrinsics.checkNotNullParameter(activeClient, (String)"activeClient");
        this.activeClient = activeClient;
    }

    @Override
    public boolean getHideSystemNodes() {
        return this.hasCapability(InspectorClient.Capability.SUPPORTS_SYSTEM_NODES) && this.get("live.layout.inspector.tree.hide.system", true);
    }

    @Override
    public void setHideSystemNodes(boolean value2) {
        this.set("live.layout.inspector.tree.hide.system", value2, true);
    }

    @Override
    public boolean getComposeAsCallstack() {
        return this.get("live.layout.inspector.tree.compose.callstack", true);
    }

    @Override
    public void setComposeAsCallstack(boolean value2) {
        this.set("live.layout.inspector.tree.compose.callstack", value2, true);
    }

    @Override
    public boolean getHighlightSemantics() {
        return this.highlightSemantics;
    }

    @Override
    public void setHighlightSemantics(boolean bl) {
        this.highlightSemantics = bl;
    }

    @Override
    public boolean getSupportLines() {
        return this.get("live.layout.inspector.tree.lines", true);
    }

    @Override
    public void setSupportLines(boolean value2) {
        this.set("live.layout.inspector.tree.lines", value2, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean getShowRecompositions() {
        if (!this.hasCapability(InspectorClient.Capability.SUPPORTS_COMPOSE_RECOMPOSITION_COUNTS)) return false;
        if (!this.get("live.layout.inspector.tree.recompositions", false)) return false;
        Object t = StudioFlags.DYNAMIC_LAYOUT_INSPECTOR_ENABLE_RECOMPOSITION_COUNTS.get();
        Intrinsics.checkNotNullExpressionValue(t, (String)"DYNAMIC_LAYOUT_INSPECTOR\u2026ECOMPOSITION_COUNTS.get()");
        if ((Boolean)t == false) return false;
        Object t2 = StudioFlags.USE_COMPONENT_TREE_TABLE.get();
        Intrinsics.checkNotNullExpressionValue(t2, (String)"USE_COMPONENT_TREE_TABLE.get()");
        if ((Boolean)t2 == false) return false;
        return true;
    }

    @Override
    public void setShowRecompositions(boolean value2) {
        this.set("live.layout.inspector.tree.recompositions", value2, false);
    }

    private final boolean hasCapability(InspectorClient.Capability capability) {
        InspectorClient client2 = (InspectorClient)this.activeClient.invoke();
        if (!client2.isConnected()) {
            return true;
        }
        return client2.getCapabilities().contains((Object)capability);
    }

    private final boolean get(String key, boolean defaultValue) {
        return PropertiesComponent.getInstance().getBoolean(key, defaultValue);
    }

    private final void set(String key, boolean value2, boolean defaultValue) {
        PropertiesComponent.getInstance().setValue(key, value2, defaultValue);
    }
}

