/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.snapshots;

import com.android.tools.idea.layoutinspector.LayoutInspector;
import com.android.tools.idea.layoutinspector.LayoutInspectorToolWindowFactoryKt;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.ex.TooltipDescriptionProvider;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.fileChooser.FileSaverDialog;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileWrapper;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\t"}, d2={"Lcom/android/tools/idea/layoutinspector/snapshots/ExportSnapshotAction;", "Lcom/intellij/openapi/actionSystem/AnAction;", "Lcom/intellij/openapi/actionSystem/ex/TooltipDescriptionProvider;", "()V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "intellij.android.layout-inspector"})
public final class ExportSnapshotAction
extends AnAction
implements TooltipDescriptionProvider {
    @NotNull
    public static final ExportSnapshotAction INSTANCE = new ExportSnapshotAction();

    private ExportSnapshotAction() {
        super("Export Snapshot", "Export a snapshot of Layout inspector to share, inspect, and use offline.", AllIcons.ToolbarDecorator.Export);
    }

    public void update(@NotNull AnActionEvent event) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        super.update(event);
        event.getPresentation().setEnabled((object = (LayoutInspector)event.getData(LayoutInspectorToolWindowFactoryKt.getLAYOUT_INSPECTOR_DATA_KEY())) != null && (object = ((LayoutInspector)object).getCurrentClient()) != null ? object.isConnected() : false);
    }

    public void actionPerformed(@NotNull AnActionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        LayoutInspector layoutInspector = (LayoutInspector)event.getData(LayoutInspectorToolWindowFactoryKt.getLAYOUT_INSPECTOR_DATA_KEY());
        if (layoutInspector == null) {
            return;
        }
        LayoutInspector inspector = layoutInspector;
        Project project = inspector.getLayoutInspectorModel().getProject();
        VirtualFile outputDir = VfsUtil.getUserHomeDir();
        String[] stringArray = new String[]{"li"};
        FileSaverDescriptor descriptor2 = new FileSaverDescriptor("Save Layout Snapshot", "Save layout inspector snapshot", stringArray);
        FileSaverDialog fileSaverDialog = FileChooserFactory.getInstance().createSaveFileDialog(descriptor2, project);
        Intrinsics.checkNotNullExpressionValue((Object)fileSaverDialog, (String)"getInstance().createSave\u2026alog(descriptor, project)");
        FileSaverDialog saveFileDialog = fileSaverDialog;
        Object fileName = inspector.getCurrentClient().getProcess().getName() + "_" + new SimpleDateFormat("yyyy.MM.dd_HH.mm", Locale.US).format(new Date());
        CharSequence charSequence = (CharSequence)fileName;
        Regex regex = new Regex("[^._A-Za-z0-9]");
        String string = "";
        fileName = regex.replace(charSequence, string);
        fileName = (String)fileName + (SystemInfo.isMac ? ".li" : "");
        VirtualFileWrapper virtualFileWrapper = saveFileDialog.save(outputDir, (String)fileName);
        if (virtualFileWrapper == null) {
            return;
        }
        VirtualFileWrapper result2 = virtualFileWrapper;
        VirtualFile vFile = result2.getVirtualFile(true);
        Object object = vFile;
        if (object == null || (object = object.toNioPath()) == null) {
            return;
        }
        Object path2 = object;
        Runnable saveAndOpenSnapshot2 = new Runnable(inspector, (Path)path2, project, vFile){
            final /* synthetic */ LayoutInspector $inspector;
            final /* synthetic */ Path $path;
            final /* synthetic */ Project $project;
            final /* synthetic */ VirtualFile $vFile;
            {
                this.$inspector = $inspector;
                this.$path = $path;
                this.$project = $project;
                this.$vFile = $vFile;
            }

            public final void run() {
                this.$inspector.getCurrentClient().saveSnapshot(this.$path);
                Project project = this.$project;
                VirtualFile virtualFile = this.$vFile;
                boolean $i$f$invokeLater = false;
                ApplicationManager.getApplication().invokeLater(new Runnable(project, virtualFile){
                    final /* synthetic */ Project $project$inlined;
                    final /* synthetic */ VirtualFile $vFile$inlined;
                    {
                        this.$project$inlined = project;
                        this.$vFile$inlined = virtualFile;
                    }

                    public final void run() {
                        boolean bl = false;
                        FileEditorManager.getInstance((Project)this.$project$inlined).openEditor(new OpenFileDescriptor(this.$project$inlined, this.$vFile$inlined), false);
                    }
                });
            }
        };
        ProgressManager.getInstance().runProcessWithProgressSynchronously(saveAndOpenSnapshot2, "Saving snapshot", true, project);
    }
}

