/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.skia;

import com.android.annotations.concurrency.Slow;
import com.android.tools.idea.layoutinspector.proto.SkiaParser;
import com.android.tools.idea.layoutinspector.skia.ParsingFailedException;
import com.android.tools.idea.layoutinspector.skia.SkiaParser;
import com.android.tools.idea.layoutinspector.skia.SkiaParserServerConnection;
import com.android.tools.idea.layoutinspector.skia.SkiaParserServerConnectionFactory;
import com.android.tools.idea.layoutinspector.skia.SkiaParserServerConnectionFactoryImpl;
import com.android.tools.idea.protobuf.ByteString;
import com.android.tools.layoutinspector.InvalidPictureException;
import com.android.tools.layoutinspector.LayoutInspectorUtils;
import com.android.tools.layoutinspector.SkiaViewNode;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0006\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\b\b\u0002\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J4\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\u0003H\u0017J\b\u0010\u0017\u001a\u00020\u0004H\u0017R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/android/tools/idea/layoutinspector/skia/SkiaParserImpl;", "Lcom/android/tools/idea/layoutinspector/skia/SkiaParser;", "failureCallback", "Lkotlin/Function0;", "", "connectionFactory", "Lcom/android/tools/idea/layoutinspector/skia/SkiaParserServerConnectionFactory;", "(Lkotlin/jvm/functions/Function0;Lcom/android/tools/idea/layoutinspector/skia/SkiaParserServerConnectionFactory;)V", "connection", "Lcom/android/tools/idea/layoutinspector/skia/SkiaParserServerConnection;", "connectionSync", "", "getViewTree", "Lcom/android/tools/layoutinspector/SkiaViewNode;", "data", "", "requestedNodes", "", "Lcom/android/tools/idea/layoutinspector/proto/SkiaParser$RequestedNodeInfo;", "scale", "", "isInterrupted", "", "shutdown", "intellij.android.layout-inspector"})
public final class SkiaParserImpl
implements SkiaParser {
    @NotNull
    private final Function0<Unit> failureCallback;
    @NotNull
    private final SkiaParserServerConnectionFactory connectionFactory;
    @NotNull
    private final Object connectionSync;
    @Nullable
    private SkiaParserServerConnection connection;

    public SkiaParserImpl(@NotNull Function0<Unit> failureCallback, @NotNull SkiaParserServerConnectionFactory connectionFactory) {
        Intrinsics.checkNotNullParameter(failureCallback, (String)"failureCallback");
        Intrinsics.checkNotNullParameter((Object)connectionFactory, (String)"connectionFactory");
        this.failureCallback = failureCallback;
        this.connectionFactory = connectionFactory;
        this.connectionSync = new Object();
    }

    public /* synthetic */ SkiaParserImpl(Function0 function0, SkiaParserServerConnectionFactory skiaParserServerConnectionFactory, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            skiaParserServerConnectionFactory = SkiaParserServerConnectionFactoryImpl.INSTANCE;
        }
        this((Function0<Unit>)function0, skiaParserServerConnectionFactory);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Override
    @Slow
    @NotNull
    public SkiaViewNode getViewTree(@NotNull byte[] data2, @NotNull Iterable<SkiaParser.RequestedNodeInfo> requestedNodes, double scale, @NotNull Function0<Boolean> isInterrupted) throws InvalidPictureException {
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        Intrinsics.checkNotNullParameter(requestedNodes, (String)"requestedNodes");
        Intrinsics.checkNotNullParameter(isInterrupted, (String)"isInterrupted");
        try {
            Map map2;
            void $this$associateByTo$iv$iv;
            void $this$associateBy$iv;
            Pair<SkiaParser.InspectorView, Map<Integer, ByteString>> pair;
            Object object = this.connectionSync;
            synchronized (object) {
                Pair<SkiaParser.InspectorView, Map<Integer, ByteString>> pair2;
                boolean bl = false;
                if (this.connection == null) {
                    this.connection = this.connectionFactory.createConnection(data2);
                }
                if ((pair2 = this.connection) == null || (pair2 = pair2.getViewTree(data2, requestedNodes, scale)) == null) {
                    throw new Exception("connection can't be null here");
                }
                pair = pair2;
            }
            Pair<SkiaParser.InspectorView, Map<Integer, ByteString>> pair3 = pair;
            SkiaParser.InspectorView root = (SkiaParser.InspectorView)pair3.component1();
            Map images = (Map)pair3.component2();
            Iterable<SkiaParser.RequestedNodeInfo> iterable = requestedNodes;
            Function0<Boolean> function0 = isInterrupted;
            Map map3 = images;
            SkiaParser.InspectorView inspectorView = root;
            LayoutInspectorUtils layoutInspectorUtils = LayoutInspectorUtils.INSTANCE;
            boolean $i$f$associateBy = false;
            int capacity$iv = RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateBy$iv, (int)10)), (int)16);
            void var13_19 = $this$associateBy$iv;
            Map destination$iv$iv = new LinkedHashMap(capacity$iv);
            boolean $i$f$associateByTo = false;
            for (Object element$iv$iv : $this$associateByTo$iv$iv) {
                void req;
                SkiaParser.RequestedNodeInfo requestedNodeInfo = (SkiaParser.RequestedNodeInfo)element$iv$iv;
                map2 = destination$iv$iv;
                boolean bl = false;
                map2.put(req.getId(), element$iv$iv);
            }
            map2 = destination$iv$iv;
            SkiaViewNode skiaViewNode = layoutInspectorUtils.buildTree(inspectorView, map3, function0, map2);
            if (skiaViewNode == null) {
                throw new ParsingFailedException();
            }
            return skiaViewNode;
        }
        catch (Exception e) {
            this.failureCallback.invoke();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Slow
    public void shutdown() {
        Object object = this.connectionSync;
        synchronized (object) {
            boolean bl = false;
            SkiaParserServerConnection skiaParserServerConnection = this.connection;
            if (skiaParserServerConnection != null) {
                skiaParserServerConnection.shutdown();
            }
            this.connection = null;
            Unit unit = Unit.INSTANCE;
        }
    }
}

