/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.resource;

import com.android.tools.idea.layoutinspector.resource.ComposeResolver;
import com.android.tools.idea.layoutinspector.resource.LambdaResolverKt;
import com.android.tools.idea.layoutinspector.resource.SourceLocation;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiWhiteSpace;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.tree.IElementType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function4;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ValueParameterDescriptor;
import org.jetbrains.kotlin.idea.caches.resolve.ResolutionUtils;
import org.jetbrains.kotlin.lexer.KtSingleValueToken;
import org.jetbrains.kotlin.psi.KtCallExpression;
import org.jetbrains.kotlin.psi.KtCallableReferenceExpression;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.psi.KtElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.KtLambdaExpression;
import org.jetbrains.kotlin.psi.KtNamedFunction;
import org.jetbrains.kotlin.psi.KtProperty;
import org.jetbrains.kotlin.psi.KtTreeVisitor;
import org.jetbrains.kotlin.psi.KtValueArgument;
import org.jetbrains.kotlin.psi.KtVisitor;
import org.jetbrains.kotlin.psi.ValueArgument;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.calls.model.ResolvedCall;
import org.jetbrains.kotlin.resolve.calls.util.CallUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001:\u0002,-B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0017\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u00a2\u0006\u0002\u0010\u000fJ6\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u000e2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fJ\u0012\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0019\u001a\u00020\nH\u0002J<\u0010\u001a\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0014\u001a\u00020\u000e2\u0006\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0016\u001a\u00020\fH\u0002J\u0010\u0010 \u001a\u00020!2\u0006\u0010\t\u001a\u00020\"H\u0002J\u0012\u0010#\u001a\u0004\u0018\u00010\"2\u0006\u0010\u0019\u001a\u00020$H\u0002J&\u0010%\u001a\u0004\u0018\u00010\n2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\f0\u001b2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010'\u001a\u00020!2\u0006\u0010(\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\u000eH\u0002J\u001c\u0010)\u001a\u00020\u00112\u0006\u0010\u0013\u001a\u00020\u000e2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\u001dH\u0002J\u0014\u0010*\u001a\u00020!*\u00020\b2\u0006\u0010+\u001a\u00020\bH\u0002R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/android/tools/idea/layoutinspector/resource/LambdaResolver;", "Lcom/android/tools/idea/layoutinspector/resource/ComposeResolver;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "visitor", "Lcom/android/tools/idea/layoutinspector/resource/LambdaResolver$LambdaVisitor;", "codeRangeOf", "Lkotlin/ranges/IntRange;", "expr", "Lorg/jetbrains/kotlin/psi/KtExpression;", "findDesiredLambdaSelectorFromName", "", "lambdaName", "", "(Ljava/lang/String;)Ljava/lang/Integer;", "findLambdaLocation", "Lcom/android/tools/idea/layoutinspector/resource/SourceLocation;", "packageName", "fileName", "functionName", "startLine", "endLine", "findParentElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "lambda", "findPossibleLambdas", "", "ktFile", "Lorg/jetbrains/kotlin/psi/KtFile;", "doc", "Lcom/intellij/openapi/editor/Document;", "isCodeElement", "", "Lcom/intellij/psi/PsiElement;", "lastCodeElement", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "selectLambdaFromSynthesizedName", "lambdas", "typeMatch", "expression", "unknown", "contains", "range", "LambdaVisitor", "VisitorData", "intellij.android.layout-inspector"})
public final class LambdaResolver
extends ComposeResolver {
    @NotNull
    private final LambdaVisitor visitor;

    public LambdaResolver(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
        this.visitor = new LambdaVisitor();
    }

    @NotNull
    public final SourceLocation findLambdaLocation(@NotNull String packageName2, @NotNull String fileName, @NotNull String lambdaName, @NotNull String functionName, int startLine, int endLine) {
        VirtualFile virtualFile;
        KtFile ktFile2;
        block7: {
            block6: {
                Intrinsics.checkNotNullParameter((Object)packageName2, (String)"packageName");
                Intrinsics.checkNotNullParameter((Object)fileName, (String)"fileName");
                Intrinsics.checkNotNullParameter((Object)lambdaName, (String)"lambdaName");
                Intrinsics.checkNotNullParameter((Object)functionName, (String)"functionName");
                if (startLine < 1 || endLine < 1) {
                    return LambdaResolver.unknown$default(this, fileName, null, 2, null);
                }
                KtFile ktFile3 = this.findKotlinFile(fileName, (Function1<? super String, Boolean>)((Function1)new Function1<String, Boolean>(packageName2){
                    final /* synthetic */ String $packageName;
                    {
                        this.$packageName = $packageName;
                        super(1);
                    }

                    @NotNull
                    public final Boolean invoke(@NotNull String it) {
                        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                        return Intrinsics.areEqual((Object)it, (Object)this.$packageName);
                    }
                }));
                if (ktFile3 == null) {
                    return LambdaResolver.unknown$default(this, fileName, null, 2, null);
                }
                ktFile2 = ktFile3;
                virtualFile = ktFile2.getVirtualFile();
                if (virtualFile == null) break block6;
                VirtualFile it = virtualFile;
                boolean bl = false;
                Document document2 = FileDocumentManager.getInstance().getDocument(it);
                virtualFile = document2;
                if (document2 != null) break block7;
            }
            return this.unknown(fileName, ktFile2);
        }
        VirtualFile doc = virtualFile;
        Map<KtExpression, Integer> possible = this.findPossibleLambdas(ktFile2, (Document)doc, functionName, startLine, endLine);
        KtExpression lambda = this.selectLambdaFromSynthesizedName(possible, lambdaName);
        int checkedStartLine = Integer.min(startLine - 1, doc.getLineCount());
        KtExpression ktExpression = lambda;
        Object object = ktExpression != null ? ktExpression.getNavigationElement() : null;
        Navigatable navigatable = object instanceof Navigatable ? (Navigatable)object : null;
        if (navigatable == null) {
            navigatable = (Navigatable)new OpenFileDescriptor(this.getProject(), ktFile2.getVirtualFile(), checkedStartLine, 0);
        }
        Navigatable navigatable2 = navigatable;
        KtExpression ktExpression2 = lambda;
        int actualLine = 1 + (ktExpression2 != null ? doc.getLineNumber(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)ktExpression2))) : checkedStartLine);
        return new SourceLocation(fileName + ":" + actualLine, navigatable2);
    }

    private final SourceLocation unknown(String fileName, KtFile ktFile2) {
        return new SourceLocation(fileName + ":unknown", (Navigatable)ktFile2);
    }

    static /* synthetic */ SourceLocation unknown$default(LambdaResolver lambdaResolver, String string, KtFile ktFile2, int n, Object object) {
        if ((n & 2) != 0) {
            ktFile2 = null;
        }
        return lambdaResolver.unknown(string, ktFile2);
    }

    private final Map<KtExpression, Integer> findPossibleLambdas(KtFile ktFile2, Document doc, String functionName, int startLine, int endLine) {
        IntRange intRange;
        IntRange intRange2;
        try {
            intRange2 = new IntRange(doc.getLineStartOffset(startLine - 1), doc.getLineEndOffset(endLine - 1));
        }
        catch (IndexOutOfBoundsException ex) {
            return MapsKt.emptyMap();
        }
        IntRange offsetRange = intRange2;
        if (offsetRange.isEmpty()) {
            return MapsKt.emptyMap();
        }
        if (endLine <= startLine) {
            intRange = IntRange.Companion.getEMPTY();
        } else {
            IntRange ex;
            try {
                ex = new IntRange(doc.getLineEndOffset(startLine - 1), doc.getLineStartOffset(endLine - 1));
            }
            catch (IndexOutOfBoundsException ex2) {
                ex = IntRange.Companion.getEMPTY();
            }
            intRange = ex;
        }
        IntRange internalRange = intRange;
        IdentityHashMap<KtExpression, Integer> possible = new IdentityHashMap<KtExpression, Integer>();
        LambdaVisitor.forEachLambda$default(this.visitor, (KtElement)ktFile2, false, (Function4)new Function4<KtExpression, Integer, Boolean, Function0<? extends Unit>, Unit>(this, functionName, offsetRange, internalRange, possible){
            final /* synthetic */ LambdaResolver this$0;
            final /* synthetic */ String $functionName;
            final /* synthetic */ IntRange $offsetRange;
            final /* synthetic */ IntRange $internalRange;
            final /* synthetic */ IdentityHashMap<KtExpression, Integer> $possible;
            {
                this.this$0 = $receiver;
                this.$functionName = $functionName;
                this.$offsetRange = $offsetRange;
                this.$internalRange = $internalRange;
                this.$possible = $possible;
                super(4);
            }

            public final void invoke(@NotNull KtExpression expr, int nesting, boolean hasComposableSibling, @NotNull Function0<Unit> recurse) {
                Intrinsics.checkNotNullParameter((Object)expr, (String)"expr");
                Intrinsics.checkNotNullParameter(recurse, (String)"recurse");
                IntRange range = new IntRange(PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)expr)), PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expr)));
                IntRange codeRange = LambdaResolver.access$codeRangeOf(this.this$0, expr);
                if (LambdaResolver.access$typeMatch(this.this$0, expr, this.$functionName) && LambdaResolver.access$contains(this.this$0, this.$offsetRange, codeRange) && LambdaResolver.access$contains(this.this$0, range, this.$internalRange)) {
                    ((Map)this.$possible).put(expr, hasComposableSibling ? -1 : nesting);
                }
                recurse.invoke();
            }
        }, 2, null);
        return possible;
    }

    private final IntRange codeRangeOf(KtExpression expr) {
        int startOffset = PsiUtilsKt.getStartOffset((PsiElement)((PsiElement)expr));
        int endOffset = PsiUtilsKt.getEndOffset((PsiElement)((PsiElement)expr));
        if (expr instanceof KtLambdaExpression) {
            PsiElement psiElement = ((KtLambdaExpression)expr).getBodyExpression();
            startOffset = psiElement != null && (psiElement = psiElement.getChildren()) != null && (psiElement = (PsiElement)ArraysKt.firstOrNull((Object[])psiElement)) != null ? PsiUtilsKt.getStartOffset((PsiElement)psiElement) : startOffset;
            PsiElement psiElement2 = this.lastCodeElement((KtLambdaExpression)expr);
            endOffset = psiElement2 != null ? PsiUtilsKt.getEndOffset((PsiElement)psiElement2) : endOffset;
        }
        return new IntRange(startOffset, endOffset);
    }

    private final boolean contains(IntRange $this$contains, IntRange range) {
        return range.isEmpty() || $this$contains.contains(range.getFirst()) && $this$contains.contains(range.getLast());
    }

    private final PsiElement lastCodeElement(KtLambdaExpression lambda) {
        ASTNode aSTNode = lambda.getRightCurlyBrace();
        PsiElement psiElement = aSTNode instanceof PsiElement ? (PsiElement)aSTNode : null;
        if (psiElement == null) {
            return null;
        }
        PsiElement expr = psiElement;
        while (!this.isCodeElement(expr)) {
            while (expr.getPrevSibling() == null) {
                if (expr.getParent() == null) {
                    return null;
                }
                if (!Intrinsics.areEqual((Object)expr, (Object)lambda)) continue;
                return null;
            }
            if (expr.getPrevSibling() == null) {
                return null;
            }
            while (expr.getLastChild() != null) {
                Intrinsics.checkNotNullExpressionValue((Object)expr.getLastChild(), (String)"expr.lastChild");
            }
        }
        return expr;
    }

    private final boolean isCodeElement(PsiElement expr) {
        if (expr instanceof PsiWhiteSpace) {
            return false;
        }
        LeafElement leafElement = expr instanceof LeafElement ? (LeafElement)expr : null;
        if (leafElement == null) {
            return true;
        }
        LeafElement leafElement2 = leafElement;
        IElementType iElementType = leafElement2.getElementType();
        KtSingleValueToken ktSingleValueToken = iElementType instanceof KtSingleValueToken ? (KtSingleValueToken)iElementType : null;
        if (ktSingleValueToken == null) {
            return true;
        }
        KtSingleValueToken token = ktSingleValueToken;
        return !Intrinsics.areEqual((Object)token.getValue(), (Object)")") && !Intrinsics.areEqual((Object)token.getValue(), (Object)"}");
    }

    private final boolean typeMatch(KtExpression expression2, String functionName) {
        return ((CharSequence)functionName).length() > 0 ? expression2 instanceof KtCallableReferenceExpression && Intrinsics.areEqual((Object)((KtCallableReferenceExpression)expression2).getCallableReference().getReferencedName(), (Object)functionName) : expression2 instanceof KtLambdaExpression;
    }

    /*
     * WARNING - void declaration
     */
    private final KtExpression selectLambdaFromSynthesizedName(Map<KtExpression, Integer> lambdas, String lambdaName) {
        Collection collection2;
        switch (lambdas.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (KtExpression)CollectionsKt.single((Iterable)lambdas.keySet());
            }
        }
        if (StringsKt.startsWith$default((String)lambdaName, (String)"lambda-", (boolean)false, (int)2, null)) {
            Integer n = (Integer)CollectionsKt.singleOrNull((Iterable)CollectionsKt.toSet((Iterable)lambdas.values()));
            if (n == null) {
                return null;
            }
            int nesting = n;
            if (nesting == -1) {
                return null;
            }
            collection2 = lambdas.keySet();
        } else {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Map.Entry it;
            void $this$filterTo$iv$iv;
            CharSequence $this$count$iv = lambdaName;
            boolean $i$f$count = false;
            int count$iv22 = 0;
            for (int i = 0; i < $this$count$iv.length(); ++i) {
                char element$iv;
                char it2 = element$iv = $this$count$iv.charAt(i);
                boolean bl = false;
                if (!(it2 == '$')) continue;
                ++count$iv22;
            }
            int wantedNestingLevel = count$iv22;
            Iterable $this$filter$iv = lambdas.entrySet();
            boolean $i$f$filter = false;
            Iterable count$iv22 = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                it = (Map.Entry)element$iv$iv;
                boolean bl = false;
                if (!(((Number)it.getValue()).intValue() == wantedNestingLevel)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (Map.Entry)item$iv$iv;
                Collection collection3 = destination$iv$iv;
                boolean bl = false;
                collection3.add((KtExpression)it.getKey());
            }
            collection2 = (List)destination$iv$iv;
        }
        Collection candidates2 = collection2;
        switch (candidates2.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return (KtExpression)CollectionsKt.first((Iterable)candidates2);
            }
        }
        KtExpression arbitrary = (KtExpression)CollectionsKt.first((Iterable)candidates2);
        KtElement ktElement = this.findParentElement(arbitrary);
        if (ktElement == null) {
            return null;
        }
        KtElement topElement = ktElement;
        Integer n = this.findDesiredLambdaSelectorFromName(lambdaName);
        if (n == null) {
            return null;
        }
        int selector = n;
        int index2 = selector - 1;
        List nestedUnderTopElement = new ArrayList();
        this.visitor.forEachLambda(topElement, true, (Function4<? super KtExpression, ? super Integer, ? super Boolean, ? super Function0<Unit>, Unit>)((Function4)new Function4<KtExpression, Integer, Boolean, Function0<? extends Unit>, Unit>((List<KtExpression>)nestedUnderTopElement){
            final /* synthetic */ List<KtExpression> $nestedUnderTopElement;
            {
                this.$nestedUnderTopElement = $nestedUnderTopElement;
                super(4);
            }

            public final void invoke(@NotNull KtExpression expression2, int n, boolean bl, @NotNull Function0<Unit> function0) {
                Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
                Intrinsics.checkNotNullParameter(function0, (String)"<anonymous parameter 3>");
                this.$nestedUnderTopElement.add(expression2);
            }
        }));
        if (!(0 <= index2 ? index2 < nestedUnderTopElement.size() : false)) {
            return null;
        }
        KtExpression candidate = (KtExpression)nestedUnderTopElement.get(index2);
        return lambdas.containsKey(candidate) ? candidate : null;
    }

    private final Integer findDesiredLambdaSelectorFromName(String lambdaName) {
        String part = StringsKt.substringAfterLast$default((String)lambdaName, (char)'$', null, (int)2, null);
        return StringsKt.toIntOrNull((String)part);
    }

    private final KtElement findParentElement(KtExpression lambda) {
        KtElement next;
        PsiElement psiElement = lambda.getParent();
        KtElement ktElement = next = psiElement instanceof KtElement ? (KtElement)psiElement : null;
        while (next != null) {
            psiElement = next;
            if (((psiElement instanceof KtClass ? true : psiElement instanceof KtNamedFunction) ? true : psiElement instanceof KtProperty) ? true : psiElement instanceof KtLambdaExpression) {
                return next;
            }
            PsiElement psiElement2 = next.getParent();
            next = psiElement2 instanceof KtElement ? (KtElement)psiElement2 : null;
        }
        return null;
    }

    public static final /* synthetic */ IntRange access$codeRangeOf(LambdaResolver $this, KtExpression expr) {
        return $this.codeRangeOf(expr);
    }

    public static final /* synthetic */ boolean access$typeMatch(LambdaResolver $this, KtExpression expression2, String functionName) {
        return $this.typeMatch(expression2, functionName);
    }

    public static final /* synthetic */ boolean access$contains(LambdaResolver $this, IntRange $receiver, IntRange range) {
        return $this.contains($receiver, range);
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003JD\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\u00052*\u0010\r\u001a&\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0005\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u0010\u0012\u0004\u0012\u00020\t0\u000eJ\u0010\u0010\u0011\u001a\u00020\u00052\u0006\u0010\u0012\u001a\u00020\u0013H\u0002J\u001e\u0010\u0014\u001a\u00020\t2\u0006\u0010\u0015\u001a\u00020\u00072\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\t0\u0010H\u0002J\u001a\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u001a\u0010\u001b\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010\u00182\u0006\u0010 \u001a\u00020!2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00182\u0006\u0010#\u001a\u00020$2\u0006\u0010\u001a\u001a\u00020\u0002H\u0016R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/android/tools/idea/layoutinspector/resource/LambdaResolver$LambdaVisitor;", "Lorg/jetbrains/kotlin/psi/KtTreeVisitor;", "Lcom/android/tools/idea/layoutinspector/resource/LambdaResolver$VisitorData;", "()V", "foundComposableSibling", "", "nesting", "", "forEachLambda", "", "startElement", "Lorg/jetbrains/kotlin/psi/KtElement;", "excludeTopElements", "callable", "Lkotlin/Function4;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "Lkotlin/Function0;", "hasComposableAnnotation", "expression", "Lorg/jetbrains/kotlin/psi/KtLambdaExpression;", "nestedOperation", "newNesting", "operation", "visitCallableReferenceExpression", "Ljava/lang/Void;", "Lorg/jetbrains/kotlin/psi/KtCallableReferenceExpression;", "data", "visitClass", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "visitLambdaExpression", "visitNamedFunction", "function", "Lorg/jetbrains/kotlin/psi/KtNamedFunction;", "visitProperty", "property", "Lorg/jetbrains/kotlin/psi/KtProperty;", "intellij.android.layout-inspector"})
    private static final class LambdaVisitor
    extends KtTreeVisitor<VisitorData> {
        private int nesting;
        private boolean foundComposableSibling;

        public final void forEachLambda(@NotNull KtElement startElement, boolean excludeTopElements, @NotNull Function4<? super KtExpression, ? super Integer, ? super Boolean, ? super Function0<Unit>, Unit> callable) {
            Intrinsics.checkNotNullParameter((Object)startElement, (String)"startElement");
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            this.nesting = 0;
            this.foundComposableSibling = false;
            startElement.acceptChildren((KtVisitor)this, (Object)new VisitorData(excludeTopElements, callable));
        }

        public static /* synthetic */ void forEachLambda$default(LambdaVisitor lambdaVisitor, KtElement ktElement, boolean bl, Function4 function4, int n, Object object) {
            if ((n & 2) != 0) {
                bl = false;
            }
            lambdaVisitor.forEachLambda(ktElement, bl, (Function4<? super KtExpression, ? super Integer, ? super Boolean, ? super Function0<Unit>, Unit>)function4);
        }

        @Nullable
        public Void visitLambdaExpression(@NotNull KtLambdaExpression expression2, @NotNull VisitorData data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            this.foundComposableSibling = this.foundComposableSibling || this.hasComposableAnnotation(expression2);
            data2.getCallable().invoke((Object)expression2, (Object)this.nesting, (Object)this.foundComposableSibling, (Object)new Function0<Unit>(this, expression2, data2){
                final /* synthetic */ LambdaVisitor this$0;
                final /* synthetic */ KtLambdaExpression $expression;
                final /* synthetic */ VisitorData $data;
                {
                    this.this$0 = $receiver;
                    this.$expression = $expression;
                    this.$data = $data;
                    super(0);
                }

                public final void invoke() {
                    LambdaVisitor.access$nestedOperation(this.this$0, LambdaVisitor.access$getNesting$p(this.this$0) + 1, (Function0)new Function0<Unit>(this.this$0, this.$expression, this.$data){
                        final /* synthetic */ LambdaVisitor this$0;
                        final /* synthetic */ KtLambdaExpression $expression;
                        final /* synthetic */ VisitorData $data;
                        {
                            this.this$0 = $receiver;
                            this.$expression = $expression;
                            this.$data = $data;
                            super(0);
                        }

                        public final void invoke() {
                            LambdaVisitor.access$visitLambdaExpression$s-92132953(this.this$0, this.$expression, this.$data);
                        }
                    });
                }
            });
            return null;
        }

        @Nullable
        public Void visitCallableReferenceExpression(@NotNull KtCallableReferenceExpression expression2, @NotNull VisitorData data2) {
            Intrinsics.checkNotNullParameter((Object)expression2, (String)"expression");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            data2.getCallable().invoke((Object)expression2, (Object)this.nesting, (Object)this.foundComposableSibling, (Object)new Function0<Unit>(this, expression2, data2){
                final /* synthetic */ LambdaVisitor this$0;
                final /* synthetic */ KtCallableReferenceExpression $expression;
                final /* synthetic */ VisitorData $data;
                {
                    this.this$0 = $receiver;
                    this.$expression = $expression;
                    this.$data = $data;
                    super(0);
                }

                public final void invoke() {
                    LambdaVisitor.access$nestedOperation(this.this$0, LambdaVisitor.access$getNesting$p(this.this$0) + 1, (Function0)new Function0<Unit>(this.this$0, this.$expression, this.$data){
                        final /* synthetic */ LambdaVisitor this$0;
                        final /* synthetic */ KtCallableReferenceExpression $expression;
                        final /* synthetic */ VisitorData $data;
                        {
                            this.this$0 = $receiver;
                            this.$expression = $expression;
                            this.$data = $data;
                            super(0);
                        }

                        public final void invoke() {
                            LambdaVisitor.access$visitCallableReferenceExpression$s-92132953(this.this$0, this.$expression, this.$data);
                        }
                    });
                }
            });
            return null;
        }

        @Nullable
        public Void visitClass(@NotNull KtClass klass, @NotNull VisitorData data2) {
            Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            if (!data2.getExcludeTopElements()) {
                this.nestedOperation(0, (Function0<Unit>)((Function0)new Function0<Unit>(this, klass, data2){
                    final /* synthetic */ LambdaVisitor this$0;
                    final /* synthetic */ KtClass $klass;
                    final /* synthetic */ VisitorData $data;
                    {
                        this.this$0 = $receiver;
                        this.$klass = $klass;
                        this.$data = $data;
                        super(0);
                    }

                    public final void invoke() {
                        LambdaVisitor.access$visitClass$s-92132953(this.this$0, this.$klass, this.$data);
                    }
                }));
            }
            return null;
        }

        @Nullable
        public Void visitProperty(@NotNull KtProperty property2, @NotNull VisitorData data2) {
            Intrinsics.checkNotNullParameter((Object)property2, (String)"property");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            if (!data2.getExcludeTopElements()) {
                this.nestedOperation(0, (Function0<Unit>)((Function0)new Function0<Unit>(this, property2, data2){
                    final /* synthetic */ LambdaVisitor this$0;
                    final /* synthetic */ KtProperty $property;
                    final /* synthetic */ VisitorData $data;
                    {
                        this.this$0 = $receiver;
                        this.$property = $property;
                        this.$data = $data;
                        super(0);
                    }

                    public final void invoke() {
                        LambdaVisitor.access$visitProperty$s-92132953(this.this$0, this.$property, this.$data);
                    }
                }));
            }
            return null;
        }

        @Nullable
        public Void visitNamedFunction(@NotNull KtNamedFunction function, @NotNull VisitorData data2) {
            Intrinsics.checkNotNullParameter((Object)function, (String)"function");
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            if (!data2.getExcludeTopElements()) {
                this.nestedOperation(0, (Function0<Unit>)((Function0)new Function0<Unit>(this, function, data2){
                    final /* synthetic */ LambdaVisitor this$0;
                    final /* synthetic */ KtNamedFunction $function;
                    final /* synthetic */ VisitorData $data;
                    {
                        this.this$0 = $receiver;
                        this.$function = $function;
                        this.$data = $data;
                        super(0);
                    }

                    public final void invoke() {
                        LambdaVisitor.access$visitNamedFunction$s-92132953(this.this$0, this.$function, this.$data);
                    }
                }));
            }
            return null;
        }

        private final void nestedOperation(int newNesting, Function0<Unit> operation) {
            int nestingBefore = this.nesting;
            boolean foundComposableSiblingBefore = this.foundComposableSibling;
            this.nesting = newNesting;
            this.foundComposableSibling = false;
            operation.invoke();
            this.nesting = nestingBefore;
            this.foundComposableSibling = foundComposableSiblingBefore;
        }

        private final boolean hasComposableAnnotation(KtLambdaExpression expression2) {
            PsiElement psiElement;
            PsiElement psiElement2 = expression2.getParent();
            KtValueArgument ktValueArgument = psiElement2 instanceof KtValueArgument ? (KtValueArgument)psiElement2 : null;
            if (ktValueArgument == null) {
                return false;
            }
            KtValueArgument argument = ktValueArgument;
            PsiElement argumentParent = argument.getParent();
            KtCallExpression ktCallExpression = argumentParent instanceof KtCallExpression ? (KtCallExpression)argumentParent : null;
            if (ktCallExpression == null && (ktCallExpression = (psiElement = argumentParent.getParent()) instanceof KtCallExpression ? (KtCallExpression)psiElement : null) == null) {
                return false;
            }
            KtCallExpression call = ktCallExpression;
            ResolvedCall resolvedCall = ResolutionUtils.resolveToCall$default((KtElement)((KtElement)call), null, (int)1, null);
            if (resolvedCall == null) {
                return false;
            }
            ResolvedCall resolvedCall2 = resolvedCall;
            ValueParameterDescriptor valueParameterDescriptor = CallUtilKt.getParameterForArgument((ResolvedCall)resolvedCall2, (ValueArgument)((ValueArgument)argument));
            if (valueParameterDescriptor == null) {
                return false;
            }
            ValueParameterDescriptor parameter = valueParameterDescriptor;
            return parameter.getType().getAnnotations().hasAnnotation(LambdaResolverKt.access$getCOMPOSABLE_ANNOTATION_FQNAME$p());
        }

        public static final /* synthetic */ void access$nestedOperation(LambdaVisitor $this, int newNesting, Function0 operation) {
            $this.nestedOperation(newNesting, (Function0<Unit>)operation);
        }

        public static final /* synthetic */ int access$getNesting$p(LambdaVisitor $this) {
            return $this.nesting;
        }

        public static final /* synthetic */ Void access$visitLambdaExpression$s-92132953(LambdaVisitor $this, KtLambdaExpression p0, Object p1) {
            return (Void)super.visitLambdaExpression(p0, p1);
        }

        public static final /* synthetic */ Void access$visitCallableReferenceExpression$s-92132953(LambdaVisitor $this, KtCallableReferenceExpression p0, Object p1) {
            return (Void)super.visitCallableReferenceExpression(p0, p1);
        }

        public static final /* synthetic */ Void access$visitClass$s-92132953(LambdaVisitor $this, KtClass p0, Object p1) {
            return (Void)super.visitClass(p0, p1);
        }

        public static final /* synthetic */ Void access$visitProperty$s-92132953(LambdaVisitor $this, KtProperty p0, Object p1) {
            return (Void)super.visitProperty(p0, p1);
        }

        public static final /* synthetic */ Void access$visitNamedFunction$s-92132953(LambdaVisitor $this, KtNamedFunction p0, Object p1) {
            return (Void)super.visitNamedFunction(p0, p1);
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\f\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012*\u0010\u0004\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000f\u001a\u00020\u0003H\u00c6\u0003J-\u0010\u0010\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0003JA\u0010\u0011\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032,\b\u0002\u0010\u0004\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\t0\u0005H\u00c6\u0001J\u0013\u0010\u0012\u001a\u00020\u00032\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00d6\u0001J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R5\u0010\u0004\u001a&\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b\u0012\u0004\u0012\u00020\t0\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lcom/android/tools/idea/layoutinspector/resource/LambdaResolver$VisitorData;", "", "excludeTopElements", "", "callable", "Lkotlin/Function4;", "Lorg/jetbrains/kotlin/psi/KtExpression;", "", "Lkotlin/Function0;", "", "(ZLkotlin/jvm/functions/Function4;)V", "getCallable", "()Lkotlin/jvm/functions/Function4;", "getExcludeTopElements", "()Z", "component1", "component2", "copy", "equals", "other", "hashCode", "toString", "", "intellij.android.layout-inspector"})
    private static final class VisitorData {
        private final boolean excludeTopElements;
        @NotNull
        private final Function4<KtExpression, Integer, Boolean, Function0<Unit>, Unit> callable;

        public VisitorData(boolean excludeTopElements, @NotNull Function4<? super KtExpression, ? super Integer, ? super Boolean, ? super Function0<Unit>, Unit> callable) {
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            this.excludeTopElements = excludeTopElements;
            this.callable = callable;
        }

        public final boolean getExcludeTopElements() {
            return this.excludeTopElements;
        }

        @NotNull
        public final Function4<KtExpression, Integer, Boolean, Function0<Unit>, Unit> getCallable() {
            return this.callable;
        }

        public final boolean component1() {
            return this.excludeTopElements;
        }

        @NotNull
        public final Function4<KtExpression, Integer, Boolean, Function0<Unit>, Unit> component2() {
            return this.callable;
        }

        @NotNull
        public final VisitorData copy(boolean excludeTopElements, @NotNull Function4<? super KtExpression, ? super Integer, ? super Boolean, ? super Function0<Unit>, Unit> callable) {
            Intrinsics.checkNotNullParameter(callable, (String)"callable");
            return new VisitorData(excludeTopElements, callable);
        }

        public static /* synthetic */ VisitorData copy$default(VisitorData visitorData, boolean bl, Function4 function4, int n, Object object) {
            if ((n & 1) != 0) {
                bl = visitorData.excludeTopElements;
            }
            if ((n & 2) != 0) {
                function4 = visitorData.callable;
            }
            return visitorData.copy(bl, function4);
        }

        @NotNull
        public String toString() {
            return "VisitorData(excludeTopElements=" + this.excludeTopElements + ", callable=" + this.callable + ")";
        }

        public int hashCode() {
            int n = this.excludeTopElements ? 1 : 0;
            if (n != 0) {
                n = 1;
            }
            int result2 = n;
            result2 = result2 * 31 + this.callable.hashCode();
            return result2;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof VisitorData)) {
                return false;
            }
            VisitorData visitorData = (VisitorData)other;
            if (this.excludeTopElements != visitorData.excludeTopElements) {
                return false;
            }
            return Intrinsics.areEqual(this.callable, visitorData.callable);
        }
    }
}

