/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.protobuf;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jetbrains.annotations.NotNull;

final class LimitedInputStream
extends FilterInputStream {
    private int limit;

    LimitedInputStream(InputStream in, int limit) {
        super(in);
        this.limit = limit;
    }

    @Override
    public int available() throws IOException {
        return Math.min(super.available(), this.limit);
    }

    @Override
    public int read() throws IOException {
        if (this.limit <= 0) {
            return -1;
        }
        int result2 = super.read();
        if (result2 >= 0) {
            --this.limit;
        }
        return result2;
    }

    @Override
    public int read(byte @NotNull [] b, int off, int len) throws IOException {
        if (this.limit <= 0) {
            return -1;
        }
        int result2 = super.read(b, off, len = Math.min(len, this.limit));
        if (result2 >= 0) {
            this.limit -= result2;
        }
        return result2;
    }

    @Override
    public long skip(long n) throws IOException {
        long result2 = super.skip(Math.min(n, (long)this.limit));
        if (result2 >= 0L) {
            this.limit = (int)((long)this.limit - result2);
        }
        return result2;
    }
}

