/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.legacy;

import com.android.annotations.concurrency.Slow;
import com.android.ddmlib.AndroidDebugBridge;
import com.android.ddmlib.Client;
import com.android.ddmlib.DebugViewDumpHandler;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.layoutinspector.model.AndroidWindow;
import com.android.tools.idea.layoutinspector.model.ViewNode;
import com.android.tools.idea.layoutinspector.pipeline.ComponentTreeData;
import com.android.tools.idea.layoutinspector.pipeline.TreeLoader;
import com.android.tools.idea.layoutinspector.pipeline.adb.AdbUtils;
import com.android.tools.idea.layoutinspector.pipeline.adb.AdbUtilsKt;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyAndroidWindow;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyClient;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyEvent;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyPropertiesProvider;
import com.android.tools.idea.layoutinspector.pipeline.legacy.LegacyTreeParser;
import com.android.tools.idea.layoutinspector.resource.ResourceLookup;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorErrorInfo;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0002 !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0003J\u001a\u0010\u0016\u001a\n\u0012\u0004\u0012\u00020\u0013\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u0019H\u0016J$\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\b\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001fH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R&\u0010\u0005\u001a\u0004\u0018\u00010\u00068\u0006@\u0006X\u0087\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\u0007\u0010\b\u001a\u0004\b\t\u0010\n\"\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u0004\u0018\u00010\u0006*\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\""}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyTreeLoader;", "Lcom/android/tools/idea/layoutinspector/pipeline/TreeLoader;", "client", "Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyClient;", "(Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyClient;)V", "ddmClientOverride", "Lcom/android/ddmlib/Client;", "getDdmClientOverride$annotations", "()V", "getDdmClientOverride", "()Lcom/android/ddmlib/Client;", "setDdmClientOverride", "(Lcom/android/ddmlib/Client;)V", "selectedDdmClient", "getSelectedDdmClient", "(Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyClient;)Lcom/android/ddmlib/Client;", "capture", "Lcom/android/tools/idea/layoutinspector/model/AndroidWindow;", "windowName", "", "propertiesUpdater", "Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyPropertiesProvider$Updater;", "getAllWindowIds", "", "data", "", "loadComponentTree", "Lcom/android/tools/idea/layoutinspector/pipeline/ComponentTreeData;", "resourceLookup", "Lcom/android/tools/idea/layoutinspector/resource/ResourceLookup;", "process", "Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "CaptureByteArrayHandler", "ListViewRootsHandler", "intellij.android.layout-inspector"})
public final class LegacyTreeLoader
implements TreeLoader {
    @NotNull
    private final LegacyClient client;
    @Nullable
    private Client ddmClientOverride;

    public LegacyTreeLoader(@NotNull LegacyClient client2) {
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        this.client = client2;
    }

    private final Client getSelectedDdmClient(LegacyClient $this$selectedDdmClient) {
        Object object = this.ddmClientOverride;
        if (object == null) {
            AndroidDebugBridge androidDebugBridge = (AndroidDebugBridge)AdbUtils.INSTANCE.getAdbFuture(this.client.getModel().getProject()).get();
            object = androidDebugBridge != null ? AdbUtilsKt.findClient(androidDebugBridge, $this$selectedDdmClient.getProcess()) : null;
        }
        return object;
    }

    @Nullable
    public final Client getDdmClientOverride() {
        return this.ddmClientOverride;
    }

    public final void setDdmClientOverride(@Nullable Client client2) {
        this.ddmClientOverride = client2;
    }

    @VisibleForTesting
    public static /* synthetic */ void getDdmClientOverride$annotations() {
    }

    @Override
    @Nullable
    public ComponentTreeData loadComponentTree(@Nullable Object data2, @NotNull ResourceLookup resourceLookup, @NotNull ProcessDescriptor process2) {
        ComponentTreeData componentTreeData;
        Intrinsics.checkNotNullParameter((Object)resourceLookup, (String)"resourceLookup");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        LegacyEvent legacyEvent = data2 instanceof LegacyEvent ? (LegacyEvent)data2 : null;
        if (legacyEvent == null) {
            return null;
        }
        LegacyEvent legacyEvent2 = legacyEvent;
        String windowName = legacyEvent2.component1();
        LegacyPropertiesProvider.Updater updater = legacyEvent2.component2();
        AndroidWindow androidWindow = this.capture(windowName, updater);
        if (androidWindow != null) {
            AndroidWindow it = androidWindow;
            boolean bl = false;
            componentTreeData = new ComponentTreeData(it, 0, SetsKt.emptySet());
        } else {
            componentTreeData = null;
        }
        return componentTreeData;
    }

    @Nullable
    public List<String> getAllWindowIds(@Nullable Object data2) {
        this.client.getLaunchMonitor().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_WINDOW_LIST_REQUESTED);
        Client client2 = this.getSelectedDdmClient(this.client);
        if (client2 == null) {
            return null;
        }
        Client ddmClient = client2;
        List<String> result2 = data2 instanceof LegacyEvent ? ((LegacyEvent)data2).getAllWindows() : new ListViewRootsHandler().getWindows(ddmClient, 5L, TimeUnit.SECONDS);
        this.client.getLatestScreenshots().keySet().retainAll((Collection)result2);
        this.client.getLatestData().keySet().retainAll((Collection)result2);
        this.client.getLaunchMonitor().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_WINDOW_LIST_RECEIVED);
        return result2;
    }

    @Slow
    private final AndroidWindow capture(String windowName, LegacyPropertiesProvider.Updater propertiesUpdater) {
        this.client.getLaunchMonitor().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_HIERARCHY_REQUESTED);
        Client client2 = this.getSelectedDdmClient(this.client);
        if (client2 == null) {
            return null;
        }
        Client ddmClient = client2;
        CaptureByteArrayHandler hierarchyHandler = new CaptureByteArrayHandler();
        ddmClient.dumpViewHierarchy(windowName, false, true, false, (DebugViewDumpHandler)hierarchyHandler);
        ResourceLookup.updateConfiguration$default(propertiesUpdater.getLookup().getResourceLookup(), ddmClient.getDevice().getDensity(), null, null, 6, null);
        byte[] byArray = hierarchyHandler.getData();
        if (byArray == null) {
            return null;
        }
        byte[] hierarchyData = byArray;
        this.client.getLaunchMonitor().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_HIERARCHY_RECEIVED);
        this.client.getLatestData().put(windowName, hierarchyData);
        if (!this.client.isConnected()) {
            return null;
        }
        Pair<ViewNode, String> pair = LegacyTreeParser.INSTANCE.parseLiveViewNode(hierarchyData, propertiesUpdater);
        if (pair == null) {
            return null;
        }
        Pair<ViewNode, String> pair2 = pair;
        ViewNode rootNode = (ViewNode)pair2.component1();
        String hash2 = (String)pair2.component2();
        CaptureByteArrayHandler imageHandler = new CaptureByteArrayHandler();
        this.client.getLaunchMonitor().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_SCREENSHOT_REQUESTED);
        ddmClient.captureView(windowName, hash2, (DebugViewDumpHandler)imageHandler);
        try {
            byte[] byArray2;
            if (byArray2 != null) {
                byte[] it = byArray2 = imageHandler.getData();
                boolean bl = false;
                this.client.getLatestScreenshots().put(windowName, it);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.client.getLaunchMonitor().updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.LEGACY_SCREENSHOT_RECEIVED);
        return new LegacyAndroidWindow(this.client, rootNode, windowName);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\u0010\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0014R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyTreeLoader$CaptureByteArrayHandler;", "Lcom/android/ddmlib/DebugViewDumpHandler;", "()V", "mData", "Ljava/util/concurrent/atomic/AtomicReference;", "", "getData", "handleViewDebugResult", "", "data", "Ljava/nio/ByteBuffer;", "intellij.android.layout-inspector"})
    private static final class CaptureByteArrayHandler
    extends DebugViewDumpHandler {
        @NotNull
        private final AtomicReference<byte[]> mData = new AtomicReference();

        protected void handleViewDebugResult(@NotNull ByteBuffer data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            byte[] b = new byte[data2.remaining()];
            data2.get(b);
            this.mData.set(b);
        }

        @Nullable
        public final byte[] getData() {
            this.waitForResult(15L, TimeUnit.SECONDS);
            return this.mData.get();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014R2\u0010\u0003\u001a&\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005 \u0006*\u0012\u0012\f\u0012\n \u0006*\u0004\u0018\u00010\u00050\u0005\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/LegacyTreeLoader$ListViewRootsHandler;", "Lcom/android/ddmlib/DebugViewDumpHandler;", "()V", "viewRoots", "Ljava/util/concurrent/CopyOnWriteArrayList;", "", "kotlin.jvm.PlatformType", "getWindows", "", "c", "Lcom/android/ddmlib/Client;", "timeout", "", "unit", "Ljava/util/concurrent/TimeUnit;", "handleViewDebugResult", "", "data", "Ljava/nio/ByteBuffer;", "intellij.android.layout-inspector"})
    private static final class ListViewRootsHandler
    extends DebugViewDumpHandler {
        private final CopyOnWriteArrayList<String> viewRoots = Lists.newCopyOnWriteArrayList();

        protected void handleViewDebugResult(@NotNull ByteBuffer data2) {
            Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
            int nWindows = data2.getInt();
            for (int i = 0; i < nWindows; ++i) {
                int len = data2.getInt();
                this.viewRoots.add(DebugViewDumpHandler.getString((ByteBuffer)data2, (int)len));
            }
        }

        @Slow
        @NotNull
        public final List<String> getWindows(@NotNull Client c, long timeout, @NotNull TimeUnit unit) throws IOException {
            Intrinsics.checkNotNullParameter((Object)c, (String)"c");
            Intrinsics.checkNotNullParameter((Object)((Object)unit), (String)"unit");
            c.listViewRoots((DebugViewDumpHandler)this);
            this.waitForResult(timeout, unit);
            CopyOnWriteArrayList<String> copyOnWriteArrayList = this.viewRoots;
            Intrinsics.checkNotNullExpressionValue(copyOnWriteArrayList, (String)"viewRoots");
            return copyOnWriteArrayList;
        }
    }
}

