/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.legacy;

import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerService;
import com.android.tools.idea.projectsystem.ProjectSystemUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.util.xml.GenericAttributeValue;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.android.dom.manifest.Manifest;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.util.projectStructure.ProjectStructureUtilKt;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\b\u0010\t\u001a\u00020\u0006H\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/legacy/ComposeWarning;", "", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "isRunningCurrentProject", "", "client", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "isUsingCompose", "performCheck", "", "intellij.android.layout-inspector"})
public final class ComposeWarning {
    @NotNull
    private final Project project;

    public ComposeWarning(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public final void performCheck(@NotNull InspectorClient client2) {
        block1: {
            InspectorBannerService bannerService;
            Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
            if (!this.isRunningCurrentProject(client2) || !this.isUsingCompose()) break block1;
            int apiLevel = client2.getProcess().getDevice().getApiLevel();
            String message2 = apiLevel < 29 ? "To see compose nodes in the inspector please use a device with API >= 29" : "Cannot display compose nodes, try restarting the application";
            InspectorBannerService inspectorBannerService = bannerService = InspectorBannerService.Companion.getInstance(this.project);
            if (inspectorBannerService != null) {
                inspectorBannerService.setNotification(message2, CollectionsKt.listOf((Object)bannerService.getDISMISS_ACTION()));
            }
        }
    }

    private final boolean isRunningCurrentProject(InspectorClient client2) {
        boolean bl;
        block5: {
            Iterable $this$any$iv = ProjectStructureUtilKt.allModules((Project)this.project);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Manifest manifest;
                    Module module2 = (Module)element$iv;
                    boolean bl2 = false;
                    AndroidFacet facet2 = AndroidFacet.getInstance((Module)module2);
                    if (facet2 != null) {
                        AndroidFacet it;
                        boolean bl3 = false;
                        manifest = Manifest.getMainManifest(it);
                    } else {
                        manifest = null;
                    }
                    Manifest manifest2 = manifest;
                    boolean $i$f$runReadAction = false;
                    String packageName2 = (String)ApplicationManager.getApplication().runReadAction(new Computable(manifest2){
                        final /* synthetic */ Manifest $manifest$inlined;
                        {
                            this.$manifest$inlined = manifest;
                        }

                        public final T compute() {
                            GenericAttributeValue<String> genericAttributeValue;
                            boolean bl = false;
                            return (T)(this.$manifest$inlined != null && (genericAttributeValue = this.$manifest$inlined.getPackage()) != null ? genericAttributeValue.getStringValue() : null);
                        }
                    });
                    if (!Intrinsics.areEqual((Object)packageName2, (Object)client2.getProcess().getName())) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final boolean isUsingCompose() {
        boolean bl;
        block3: {
            Iterable $this$any$iv = ProjectStructureUtilKt.allModules((Project)this.project);
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    Module it = (Module)element$iv;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    if (!ProjectSystemUtil.getModuleSystem(it).getUsesCompose()) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }
}

