/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection;

import com.android.tools.idea.appinspection.api.process.ProcessesModel;
import com.android.tools.idea.appinspection.inspector.api.process.DeviceDescriptor;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.layoutinspector.metrics.ForegroundProcessDetectionMetrics;
import com.android.tools.idea.layoutinspector.metrics.LayoutInspectorMetrics;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.DeviceModel;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcess;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetection;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessDetectionKt;
import com.android.tools.idea.layoutinspector.pipeline.foregroundprocessdetection.ForegroundProcessListener;
import com.android.tools.idea.transport.TransportClient;
import com.android.tools.idea.transport.TransportService;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.CoroutineScope;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0007J\b\u0010\f\u001a\u00020\rH\u0002JL\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\u00132\b\b\u0002\u0010\u0014\u001a\u00020\u00072\b\b\u0002\u0010\u0015\u001a\u00020\r2\u0006\u0010\u0016\u001a\u00020\u00172\b\b\u0002\u0010\u0018\u001a\u00020\u0019R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/foregroundprocessdetection/ForegroundProcessDetectionInitializer;", "", "()V", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getDefaultForegroundProcessListener", "Lcom/android/tools/idea/layoutinspector/pipeline/foregroundprocessdetection/ForegroundProcessListener;", "deviceModel", "Lcom/android/tools/idea/layoutinspector/pipeline/foregroundprocessdetection/DeviceModel;", "processModel", "Lcom/android/tools/idea/appinspection/api/process/ProcessesModel;", "getDefaultTransportClient", "Lcom/android/tools/idea/transport/TransportClient;", "initialize", "Lcom/android/tools/idea/layoutinspector/pipeline/foregroundprocessdetection/ForegroundProcessDetection;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "foregroundProcessListener", "transportClient", "metrics", "Lcom/android/tools/idea/layoutinspector/metrics/ForegroundProcessDetectionMetrics;", "layoutInspectorMetrics", "Lcom/android/tools/idea/layoutinspector/metrics/LayoutInspectorMetrics;", "intellij.android.layout-inspector"})
public final class ForegroundProcessDetectionInitializer {
    @NotNull
    public static final ForegroundProcessDetectionInitializer INSTANCE = new ForegroundProcessDetectionInitializer();
    @NotNull
    private static final Logger logger;

    private ForegroundProcessDetectionInitializer() {
    }

    @VisibleForTesting
    @NotNull
    public final ForegroundProcessListener getDefaultForegroundProcessListener(@NotNull DeviceModel deviceModel, @NotNull ProcessesModel processModel) {
        Intrinsics.checkNotNullParameter((Object)deviceModel, (String)"deviceModel");
        Intrinsics.checkNotNullParameter((Object)processModel, (String)"processModel");
        return new ForegroundProcessListener(deviceModel, processModel){
            final /* synthetic */ DeviceModel $deviceModel;
            final /* synthetic */ ProcessesModel $processModel;
            {
                this.$deviceModel = $deviceModel;
                this.$processModel = $processModel;
            }

            public void onNewProcess(@NotNull DeviceDescriptor device2, @NotNull ForegroundProcess foregroundProcess) {
                Intrinsics.checkNotNullParameter((Object)device2, (String)"device");
                Intrinsics.checkNotNullParameter((Object)foregroundProcess, (String)"foregroundProcess");
                if (!Intrinsics.areEqual((Object)device2, (Object)this.$deviceModel.getSelectedDevice())) {
                    return;
                }
                ProcessDescriptor foregroundProcessDescriptor = ForegroundProcessDetectionKt.matchToProcessDescriptor(foregroundProcess, this.$processModel);
                if (foregroundProcessDescriptor == null) {
                    ForegroundProcessDetectionInitializer.access$getLogger$p().info("Process descriptor not found for foreground process \"" + foregroundProcess.getProcessName() + "\" on device \"" + device2.getManufacturer() + " " + device2.getModel() + " API " + device2.getApiLevel() + "\"");
                } else {
                    ForegroundProcessDetectionInitializer.access$getLogger$p().info("Process descriptor found for foreground process \"" + foregroundProcess.getProcessName() + "\" on device \"" + device2.getManufacturer() + " " + device2.getModel() + " API " + device2.getApiLevel() + "\"");
                }
                this.$processModel.setSelectedProcess(foregroundProcessDescriptor);
            }
        };
    }

    private final TransportClient getDefaultTransportClient() {
        TransportService.Companion.getInstance();
        return new TransportClient(TransportService.Companion.getChannelName());
    }

    @NotNull
    public final ForegroundProcessDetection initialize(@NotNull Project project, @NotNull ProcessesModel processModel, @NotNull DeviceModel deviceModel, @NotNull CoroutineScope coroutineScope, @NotNull ForegroundProcessListener foregroundProcessListener, @NotNull TransportClient transportClient, @NotNull ForegroundProcessDetectionMetrics metrics, @NotNull LayoutInspectorMetrics layoutInspectorMetrics) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)processModel, (String)"processModel");
        Intrinsics.checkNotNullParameter((Object)deviceModel, (String)"deviceModel");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        Intrinsics.checkNotNullParameter((Object)foregroundProcessListener, (String)"foregroundProcessListener");
        Intrinsics.checkNotNullParameter((Object)transportClient, (String)"transportClient");
        Intrinsics.checkNotNullParameter((Object)metrics, (String)"metrics");
        Intrinsics.checkNotNullParameter((Object)layoutInspectorMetrics, (String)"layoutInspectorMetrics");
        ForegroundProcessDetection foregroundProcessDetection = new ForegroundProcessDetection(project, deviceModel, processModel, transportClient, layoutInspectorMetrics, metrics, coroutineScope, null, null, 0L, 896, null);
        foregroundProcessDetection.getForegroundProcessListeners().add(foregroundProcessListener);
        processModel.addSelectedProcessListeners((Function0<Unit>)((Function0)new Function0<Unit>(processModel, deviceModel, foregroundProcessDetection){
            final /* synthetic */ ProcessesModel $processModel;
            final /* synthetic */ DeviceModel $deviceModel;
            final /* synthetic */ ForegroundProcessDetection $foregroundProcessDetection;
            {
                this.$processModel = $processModel;
                this.$deviceModel = $deviceModel;
                this.$foregroundProcessDetection = $foregroundProcessDetection;
                super(0);
            }

            public final void invoke() {
                DeviceDescriptor selectedProcessDevice;
                ProcessDescriptor processDescriptor2 = this.$processModel.getSelectedProcess();
                DeviceDescriptor deviceDescriptor = selectedProcessDevice = processDescriptor2 != null ? processDescriptor2.getDevice() : null;
                if (selectedProcessDevice != null && !Intrinsics.areEqual((Object)selectedProcessDevice, (Object)this.$deviceModel.getSelectedDevice())) {
                    this.$foregroundProcessDetection.startPollingDevice(selectedProcessDevice);
                }
            }
        }));
        return foregroundProcessDetection;
    }

    public static /* synthetic */ ForegroundProcessDetection initialize$default(ForegroundProcessDetectionInitializer foregroundProcessDetectionInitializer, Project project, ProcessesModel processesModel, DeviceModel deviceModel, CoroutineScope coroutineScope, ForegroundProcessListener foregroundProcessListener, TransportClient transportClient, ForegroundProcessDetectionMetrics foregroundProcessDetectionMetrics, LayoutInspectorMetrics layoutInspectorMetrics, int n, Object object) {
        if ((n & 0x10) != 0) {
            foregroundProcessListener = foregroundProcessDetectionInitializer.getDefaultForegroundProcessListener(deviceModel, processesModel);
        }
        if ((n & 0x20) != 0) {
            transportClient = foregroundProcessDetectionInitializer.getDefaultTransportClient();
        }
        if ((n & 0x80) != 0) {
            layoutInspectorMetrics = LayoutInspectorMetrics.INSTANCE;
        }
        return foregroundProcessDetectionInitializer.initialize(project, processesModel, deviceModel, coroutineScope, foregroundProcessListener, transportClient, foregroundProcessDetectionMetrics, layoutInspectorMetrics);
    }

    public static final /* synthetic */ Logger access$getLogger$p() {
        return logger;
    }

    static {
        Logger logger2 = Logger.getInstance(ForegroundProcessDetectionInitializer.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(ForegroundPr\u2026nInitializer::class.java)");
        logger = logger2;
    }
}

