/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline.appinspection;

import com.android.tools.idea.appinspection.inspector.api.AppInspectionAppProguardedException;
import com.android.tools.idea.appinspection.inspector.api.AppInspectionArtifactNotFoundException;
import com.android.tools.idea.appinspection.inspector.api.AppInspectionCannotFindAdbDeviceException;
import com.android.tools.idea.appinspection.inspector.api.AppInspectionLibraryMissingException;
import com.android.tools.idea.appinspection.inspector.api.AppInspectionProcessNoLongerExistsException;
import com.android.tools.idea.appinspection.inspector.api.AppInspectionServiceException;
import com.android.tools.idea.appinspection.inspector.api.AppInspectionVersionIncompatibleException;
import com.android.tools.idea.appinspection.inspector.api.AppInspectionVersionMissingException;
import com.android.tools.idea.appinspection.inspector.api.launch.LibraryCompatbilityInfo;
import com.android.tools.idea.layoutinspector.pipeline.ErrorInfo;
import com.android.tools.idea.layoutinspector.pipeline.ErrorInfoKt;
import com.android.tools.idea.layoutinspector.pipeline.InspectorConnectionError;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.ConnectionFailedException;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.compose.ComposeLayoutInspectorClientKt;
import com.android.tools.idea.transport.TransportNonExistingFileException;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorErrorInfo;
import com.intellij.openapi.diagnostic.Logger;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0002\u001a\u00020\u0003*\u0004\u0018\u00010\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\"\u0015\u0010\u0002\u001a\u00020\u0003*\u00020\u00078F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\b\u00a8\u0006\r"}, d2={"GMAVEN_HOSTNAME", "", "errorCode", "Lcom/android/tools/idea/layoutinspector/pipeline/ErrorInfo;", "Lcom/android/tools/idea/appinspection/inspector/api/launch/LibraryCompatbilityInfo$Status;", "getErrorCode", "(Lcom/android/tools/idea/appinspection/inspector/api/launch/LibraryCompatbilityInfo$Status;)Lcom/android/tools/idea/layoutinspector/pipeline/ErrorInfo;", "", "(Ljava/lang/Throwable;)Lcom/android/tools/idea/layoutinspector/pipeline/ErrorInfo;", "logUnexpectedError", "", "error", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorConnectionError;", "intellij.android.layout-inspector"})
public final class ConnectionFailedExceptionKt {
    @NotNull
    public static final String GMAVEN_HOSTNAME = "maven.google.com";

    @NotNull
    public static final ErrorInfo getErrorCode(@NotNull Throwable $this$errorCode) {
        ErrorInfo errorInfo;
        Intrinsics.checkNotNullParameter((Object)$this$errorCode, (String)"<this>");
        Throwable throwable = $this$errorCode;
        if (throwable instanceof ConnectionFailedException) {
            errorInfo = ErrorInfoKt.info(((ConnectionFailedException)$this$errorCode).getCode());
        } else if (throwable instanceof AppInspectionCannotFindAdbDeviceException) {
            errorInfo = ErrorInfoKt.info(DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_CANNOT_FIND_DEVICE);
        } else if (throwable instanceof AppInspectionProcessNoLongerExistsException) {
            errorInfo = ErrorInfoKt.info(DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_PROCESS_NO_LONGER_EXISTS);
        } else if (throwable instanceof AppInspectionVersionIncompatibleException) {
            errorInfo = ErrorInfoKt.info(DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_INCOMPATIBLE_VERSION);
        } else if (throwable instanceof AppInspectionVersionMissingException) {
            errorInfo = ErrorInfoKt.info(DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_VERSION_FILE_NOT_FOUND);
        } else if (throwable instanceof AppInspectionLibraryMissingException) {
            errorInfo = ErrorInfoKt.info(DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_MISSING_LIBRARY);
        } else if (throwable instanceof AppInspectionAppProguardedException) {
            errorInfo = ErrorInfoKt.info(DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_PROGUARDED_APP);
        } else if (throwable instanceof AppInspectionArtifactNotFoundException) {
            DynamicLayoutInspectorErrorInfo.AttachErrorCode attachErrorCode;
            if (StringsKt.endsWith$default((String)((AppInspectionArtifactNotFoundException)$this$errorCode).getArtifactCoordinate().getVersion(), (String)"-SNAPSHOT", (boolean)false, (int)2, null)) {
                attachErrorCode = DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_SNAPSHOT_NOT_SPECIFIED;
            } else {
                String string = $this$errorCode.getMessage();
                attachErrorCode = (string != null ? StringsKt.contains$default((CharSequence)string, (CharSequence)GMAVEN_HOSTNAME, (boolean)false, (int)2, null) : false) ? DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_FAILED_MAVEN_DOWNLOAD : (((AppInspectionArtifactNotFoundException)$this$errorCode).getArtifactCoordinate().sameArtifact(ComposeLayoutInspectorClientKt.getMINIMUM_COMPOSE_COORDINATE()) ? DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_COMPOSE_INSPECTOR_NOT_FOUND : DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_ARTIFACT_NOT_FOUND);
            }
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"artifact", (Object)((AppInspectionArtifactNotFoundException)$this$errorCode).getArtifactCoordinate().toString())};
            errorInfo = ErrorInfoKt.info(attachErrorCode, pairArray);
        } else if (throwable instanceof AppInspectionServiceException) {
            ConnectionFailedExceptionKt.logUnexpectedError(new InspectorConnectionError($this$errorCode));
            errorInfo = ErrorInfoKt.info(DynamicLayoutInspectorErrorInfo.AttachErrorCode.UNKNOWN_APP_INSPECTION_ERROR);
        } else if (throwable instanceof TransportNonExistingFileException) {
            Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"path", (Object)((TransportNonExistingFileException)$this$errorCode).getPath())};
            errorInfo = ErrorInfoKt.info(DynamicLayoutInspectorErrorInfo.AttachErrorCode.TRANSPORT_PUSH_FAILED_FILE_NOT_FOUND, pairArray);
        } else {
            ConnectionFailedExceptionKt.logUnexpectedError(new InspectorConnectionError($this$errorCode));
            errorInfo = ErrorInfoKt.info(DynamicLayoutInspectorErrorInfo.AttachErrorCode.UNKNOWN_ERROR_CODE);
        }
        return errorInfo;
    }

    @NotNull
    public static final ErrorInfo getErrorCode(@Nullable LibraryCompatbilityInfo.Status $this$errorCode) {
        DynamicLayoutInspectorErrorInfo.AttachErrorCode attachErrorCode;
        LibraryCompatbilityInfo.Status status2 = $this$errorCode;
        switch (status2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[status2.ordinal()]) {
            case 1: {
                attachErrorCode = DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_INCOMPATIBLE_VERSION;
                break;
            }
            case 2: {
                attachErrorCode = DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_PROGUARDED_APP;
                break;
            }
            case 3: {
                attachErrorCode = DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_VERSION_FILE_NOT_FOUND;
                break;
            }
            case 4: {
                attachErrorCode = DynamicLayoutInspectorErrorInfo.AttachErrorCode.APP_INSPECTION_MISSING_LIBRARY;
                break;
            }
            default: {
                ConnectionFailedExceptionKt.logUnexpectedError(new InspectorConnectionError("Unexpected status " + $this$errorCode));
                attachErrorCode = DynamicLayoutInspectorErrorInfo.AttachErrorCode.UNKNOWN_APP_INSPECTION_ERROR;
            }
        }
        return ErrorInfoKt.info(attachErrorCode);
    }

    public static final void logUnexpectedError(@NotNull InspectorConnectionError error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        try {
            Logger.getInstance(ConnectionFailedException.class).error((Throwable)error);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Metadata(mv={1, 6, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LibraryCompatbilityInfo.Status.values().length];
            nArray[LibraryCompatbilityInfo.Status.INCOMPATIBLE.ordinal()] = 1;
            nArray[LibraryCompatbilityInfo.Status.APP_PROGUARDED.ordinal()] = 2;
            nArray[LibraryCompatbilityInfo.Status.VERSION_MISSING.ordinal()] = 3;
            nArray[LibraryCompatbilityInfo.Status.LIBRARY_MISSING.ordinal()] = 4;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

