/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline;

import com.android.tools.idea.layoutinspector.LayoutInspectorBundle;
import com.android.tools.idea.layoutinspector.metrics.LayoutInspectorSessionMetrics;
import com.android.tools.idea.layoutinspector.metrics.statistics.SessionStatistics;
import com.android.tools.idea.layoutinspector.pipeline.DisconnectedClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClientLaunchMonitorKt;
import com.android.tools.idea.layoutinspector.pipeline.appinspection.ConnectionFailedExceptionKt;
import com.android.tools.idea.layoutinspector.ui.InspectorBannerService;
import com.android.tools.idea.util.ListenerCollection;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorAttachToProcess;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorErrorInfo;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorEvent;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.util.concurrency.AppExecutorUtil;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0005\u0018\u00002\u00020\u0001B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0018\u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0016\u001a\u00020\bH\u0002J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u000e\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u001cJ\u000e\u0010\u001d\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0006\u0010\u001e\u001a\u00020\bJ\u000e\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u0007R \u0010\u0004\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u00020\f8\u0002X\u0083\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLaunchMonitor;", "", "project", "Lcom/intellij/openapi/project/Project;", "attachErrorStateListeners", "Lcom/android/tools/idea/util/ListenerCollection;", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorErrorInfo$AttachErrorState;", "", "stats", "Lcom/android/tools/idea/layoutinspector/metrics/statistics/SessionStatistics;", "executorService", "Ljava/util/concurrent/ScheduledExecutorService;", "(Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/util/ListenerCollection;Lcom/android/tools/idea/layoutinspector/metrics/statistics/SessionStatistics;Ljava/util/concurrent/ScheduledExecutorService;)V", "client", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "clientLock", "currentFuture", "Ljava/util/concurrent/ScheduledFuture;", "currentProgress", "lastUpdate", "", "handleTimeout", "logAttachError", "errorCode", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorErrorInfo$AttachErrorCode;", "onFailure", "t", "", "start", "stop", "updateProgress", "progress", "intellij.android.layout-inspector"})
public final class InspectorClientLaunchMonitor {
    @NotNull
    private final Project project;
    @NotNull
    private final ListenerCollection<Function1<DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit>> attachErrorStateListeners;
    @NotNull
    private final SessionStatistics stats;
    @TestOnly
    @NotNull
    private final ScheduledExecutorService executorService;
    private long lastUpdate;
    @NotNull
    private DynamicLayoutInspectorErrorInfo.AttachErrorState currentProgress;
    @Nullable
    private ScheduledFuture<?> currentFuture;
    @NotNull
    private final Object clientLock;
    @Nullable
    private InspectorClient client;

    public InspectorClientLaunchMonitor(@NotNull Project project, @NotNull ListenerCollection<Function1<DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit>> attachErrorStateListeners, @NotNull SessionStatistics stats, @NotNull ScheduledExecutorService executorService) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(attachErrorStateListeners, (String)"attachErrorStateListeners");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)executorService, (String)"executorService");
        this.project = project;
        this.attachErrorStateListeners = attachErrorStateListeners;
        this.stats = stats;
        this.executorService = executorService;
        this.currentProgress = DynamicLayoutInspectorErrorInfo.AttachErrorState.UNKNOWN_ATTACH_ERROR_STATE;
        this.clientLock = new Object();
    }

    public /* synthetic */ InspectorClientLaunchMonitor(Project project, ListenerCollection listenerCollection, SessionStatistics sessionStatistics, ScheduledExecutorService scheduledExecutorService, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            ScheduledExecutorService scheduledExecutorService2 = AppExecutorUtil.getAppScheduledExecutorService();
            Intrinsics.checkNotNullExpressionValue((Object)scheduledExecutorService2, (String)"getAppScheduledExecutorService()");
            scheduledExecutorService = scheduledExecutorService2;
        }
        this(project, (ListenerCollection<Function1<DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit>>)listenerCollection, sessionStatistics, scheduledExecutorService);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void start(@NotNull InspectorClient client2) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)client2, (String)"client");
        boolean bl2 = bl = this.client == null;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        Object object = this.clientLock;
        synchronized (object) {
            boolean bl3 = false;
            this.client = client2;
            Unit unit = Unit.INSTANCE;
        }
        this.updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.NOT_STARTED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void updateProgress(@NotNull DynamicLayoutInspectorErrorInfo.AttachErrorState progress2) {
        block7: {
            Intrinsics.checkNotNullParameter((Object)progress2, (String)"progress");
            this.attachErrorStateListeners.forEach(new Consumer(progress2){
                final /* synthetic */ DynamicLayoutInspectorErrorInfo.AttachErrorState $progress;
                {
                    this.$progress = $progress;
                }

                public final void accept(@NotNull Function1<? super DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit> it) {
                    Intrinsics.checkNotNullParameter(it, (String)"it");
                    it.invoke((Object)this.$progress);
                }
            });
            if (progress2.compareTo((Enum)this.currentProgress) <= 0) {
                return;
            }
            ScheduledFuture<?> scheduledFuture2 = this.currentFuture;
            if (scheduledFuture2 != null) {
                scheduledFuture2.cancel(true);
            }
            this.currentProgress = progress2;
            this.stats.setCurrentProgress(progress2);
            if (this.currentProgress.compareTo((Enum)InspectorClientLaunchMonitorKt.getCONNECTED_STATE()) < 0) {
                this.lastUpdate = System.currentTimeMillis();
                Object object = this.clientLock;
                synchronized (object) {
                    boolean bl = false;
                    if (this.client != null) {
                        this.currentFuture = this.executorService.schedule(new Runnable(this){
                            final /* synthetic */ InspectorClientLaunchMonitor $tmp0;
                            {
                                this.$tmp0 = $tmp0;
                            }

                            public final void run() {
                                InspectorClientLaunchMonitor.access$handleTimeout(this.$tmp0);
                            }
                        }, 30L, TimeUnit.SECONDS);
                    }
                    Unit unit = Unit.INSTANCE;
                }
            }
            InspectorBannerService inspectorBannerService = InspectorBannerService.Companion.getInstance(this.project);
            if (inspectorBannerService == null) break block7;
            inspectorBannerService.removeNotification(LayoutInspectorBundle.INSTANCE.message("connect.timeout", new String[0]));
        }
    }

    public final void onFailure(@NotNull Throwable t) {
        Intrinsics.checkNotNullParameter((Object)t, (String)"t");
        this.logAttachError(ConnectionFailedExceptionKt.getErrorCode(t).getCode());
        this.stop();
    }

    private final void handleTimeout() {
        block0: {
            InspectorBannerService banner;
            AnAction continueWaiting2 = new AnAction(this){
                final /* synthetic */ InspectorClientLaunchMonitor this$0;
                {
                    this.this$0 = $receiver;
                    super("Continue Waiting");
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void actionPerformed(@NotNull AnActionEvent event) {
                    Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                    InspectorBannerService inspectorBannerService = InspectorBannerService.Companion.getInstance(InspectorClientLaunchMonitor.access$getProject$p(this.this$0));
                    if (inspectorBannerService != null) {
                        inspectorBannerService.removeNotification(LayoutInspectorBundle.INSTANCE.message("connect.timeout", new String[0]));
                    }
                    Object object = InspectorClientLaunchMonitor.access$getClientLock$p(this.this$0);
                    InspectorClientLaunchMonitor inspectorClientLaunchMonitor = this.this$0;
                    Object object2 = object;
                    synchronized (object2) {
                        boolean bl = false;
                        if (InspectorClientLaunchMonitor.access$getClient$p(inspectorClientLaunchMonitor) != null) {
                            InspectorClientLaunchMonitor.access$setCurrentFuture$p(inspectorClientLaunchMonitor, InspectorClientLaunchMonitor.access$getExecutorService$p(inspectorClientLaunchMonitor).schedule(new Runnable(inspectorClientLaunchMonitor){
                                final /* synthetic */ InspectorClientLaunchMonitor $tmp0;
                                {
                                    this.$tmp0 = $tmp0;
                                }

                                public final void run() {
                                    InspectorClientLaunchMonitor.access$handleTimeout(this.$tmp0);
                                }
                            }, 30L, TimeUnit.SECONDS));
                        }
                        Unit unit = Unit.INSTANCE;
                    }
                }
            };
            InspectorClient inspectorClient = this.client;
            String disconnectText = (inspectorClient != null ? inspectorClient.getClientType() : null) == DynamicLayoutInspectorAttachToProcess.ClientType.APP_INSPECTION_CLIENT ? "Dump Views" : "Disconnect";
            AnAction disconnect2 = new AnAction(disconnectText, this){
                final /* synthetic */ InspectorClientLaunchMonitor this$0;
                {
                    this.this$0 = $receiver;
                    super($disconnectText);
                }

                public void actionPerformed(@NotNull AnActionEvent event) {
                    block1: {
                        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                        InspectorBannerService inspectorBannerService = InspectorBannerService.Companion.getInstance(InspectorClientLaunchMonitor.access$getProject$p(this.this$0));
                        if (inspectorBannerService != null) {
                            inspectorBannerService.removeNotification(LayoutInspectorBundle.INSTANCE.message("connect.timeout", new String[0]));
                        }
                        Logger.getInstance(InspectorClientLaunchMonitor.class).warn("Client " + InspectorClientLaunchMonitor.access$getClient$p(this.this$0) + " timed out during attach at step " + InspectorClientLaunchMonitor.access$getCurrentProgress$p(this.this$0) + " on the users request");
                        InspectorClientLaunchMonitor.access$logAttachError(this.this$0, DynamicLayoutInspectorErrorInfo.AttachErrorCode.CONNECT_TIMEOUT);
                        InspectorClient inspectorClient = InspectorClientLaunchMonitor.access$getClient$p(this.this$0);
                        if (inspectorClient == null) break block1;
                        inspectorClient.disconnect();
                    }
                }
            };
            InspectorBannerService inspectorBannerService = banner = InspectorBannerService.Companion.getInstance(this.project);
            if (inspectorBannerService == null) break block0;
            Object[] objectArray = new AnAction[]{continueWaiting2, disconnect2};
            inspectorBannerService.setNotification(LayoutInspectorBundle.INSTANCE.message("connect.timeout", new String[0]), CollectionsKt.listOf((Object[])objectArray));
        }
    }

    private final void logAttachError(DynamicLayoutInspectorErrorInfo.AttachErrorCode errorCode) {
        Object object = this.client;
        if (object == null || (object = object.getStats()) == null) {
            object = DisconnectedClient.INSTANCE.getStats();
        }
        Object stats = object;
        InspectorClient inspectorClient = this.client;
        new LayoutInspectorSessionMetrics(null, inspectorClient != null ? inspectorClient.getProcess() : null, null).logEvent(DynamicLayoutInspectorEvent.DynamicLayoutInspectorEventType.ATTACH_ERROR, (SessionStatistics)stats, this.currentProgress, errorCode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void stop() {
        Object object = this.clientLock;
        synchronized (object) {
            boolean bl = false;
            this.client = null;
            Unit unit = Unit.INSTANCE;
        }
        ScheduledFuture<?> scheduledFuture2 = this.currentFuture;
        if (scheduledFuture2 != null) {
            scheduledFuture2.cancel(true);
        }
        this.currentFuture = null;
    }

    public static final /* synthetic */ Project access$getProject$p(InspectorClientLaunchMonitor $this) {
        return $this.project;
    }

    public static final /* synthetic */ Object access$getClientLock$p(InspectorClientLaunchMonitor $this) {
        return $this.clientLock;
    }

    public static final /* synthetic */ InspectorClient access$getClient$p(InspectorClientLaunchMonitor $this) {
        return $this.client;
    }

    public static final /* synthetic */ void access$setCurrentFuture$p(InspectorClientLaunchMonitor $this, ScheduledFuture scheduledFuture2) {
        $this.currentFuture = scheduledFuture2;
    }

    public static final /* synthetic */ ScheduledExecutorService access$getExecutorService$p(InspectorClientLaunchMonitor $this) {
        return $this.executorService;
    }

    public static final /* synthetic */ void access$handleTimeout(InspectorClientLaunchMonitor $this) {
        $this.handleTimeout();
    }

    public static final /* synthetic */ DynamicLayoutInspectorErrorInfo.AttachErrorState access$getCurrentProgress$p(InspectorClientLaunchMonitor $this) {
        return $this.currentProgress;
    }

    public static final /* synthetic */ void access$logAttachError(InspectorClientLaunchMonitor $this, DynamicLayoutInspectorErrorInfo.AttachErrorCode errorCode) {
        $this.logAttachError(errorCode);
    }
}

