/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.layoutinspector.pipeline;

import com.android.ddmlib.AndroidDebugBridge;
import com.android.tools.idea.appinspection.inspector.api.process.ProcessDescriptor;
import com.android.tools.idea.concurrency.FutureUtils;
import com.android.tools.idea.flags.StudioFlags;
import com.android.tools.idea.layoutinspector.metrics.statistics.SessionStatistics;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClient;
import com.android.tools.idea.layoutinspector.pipeline.InspectorClientLaunchMonitor;
import com.android.tools.idea.layoutinspector.pipeline.adb.AdbUtils;
import com.android.tools.idea.layoutinspector.pipeline.adb.AdbUtilsKt;
import com.android.tools.idea.util.ListenerCollection;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorAttachToProcess;
import com.google.wireless.android.sdk.stats.DynamicLayoutInspectorErrorInfo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;
import org.jetbrains.annotations.VisibleForTesting;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\u0010\u0001\n\u0002\b\r\b&\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u000eJ\u000e\u00101\u001a\u00020\u00132\u0006\u0010\u0004\u001a\u00020\u0005J\u0006\u00102\u001a\u00020\u0013J\b\u00103\u001a\u00020\u0013H\u0016J\u000e\u00104\u001a\b\u0012\u0004\u0012\u00020605H$J\u000e\u00107\u001a\b\u0012\u0004\u0012\u00020605H$J\u0010\u00108\u001a\u00020\u00132\u0006\u00109\u001a\u00020\u0019H\u0004J\u0010\u0010:\u001a\u00020\u00132\u0006\u0010(\u001a\u00020'H\u0002J\u0010\u0010;\u001a\u00020\u00132\u0006\u0010<\u001a\u00020\u0017H\u0004J\u001a\u0010=\u001a\u00020\u00132\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u0011J\u001a\u0010?\u001a\u00020\u00132\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00130\u0011J\u001c\u0010@\u001a\u00020\u00132\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00130\u0011H\u0016J\u001a\u0010A\u001a\u00020\u00132\u0012\u0010>\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00130\u0011J\u0010\u0010B\u001a\u00020\u00132\u0006\u0010(\u001a\u00020\u0012H\u0016R \u0010\u000f\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00130\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0018\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00130\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u001aR$\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R$\u0010(\u001a\u00020'2\u0006\u0010&\u001a\u00020'@GX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R \u0010-\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020'\u0012\u0004\u0012\u00020\u00130\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R \u00100\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020\u00130\u00110\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006C"}, d2={"Lcom/android/tools/idea/layoutinspector/pipeline/AbstractInspectorClient;", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient;", "clientType", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorAttachToProcess$ClientType;", "project", "Lcom/intellij/openapi/project/Project;", "process", "Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "isInstantlyAutoConnected", "", "stats", "Lcom/android/tools/idea/layoutinspector/metrics/statistics/SessionStatistics;", "parentDisposable", "Lcom/intellij/openapi/Disposable;", "(Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorAttachToProcess$ClientType;Lcom/intellij/openapi/project/Project;Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;ZLcom/android/tools/idea/layoutinspector/metrics/statistics/SessionStatistics;Lcom/intellij/openapi/Disposable;)V", "attachStateListeners", "Lcom/android/tools/idea/util/ListenerCollection;", "Lkotlin/Function1;", "Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorErrorInfo$AttachErrorState;", "", "getClientType", "()Lcom/google/wireless/android/sdk/stats/DynamicLayoutInspectorAttachToProcess$ClientType;", "disconnectStateLock", "", "errorCallbacks", "", "()Z", "<set-?>", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLaunchMonitor;", "launchMonitor", "getLaunchMonitor", "()Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLaunchMonitor;", "setLaunchMonitor", "(Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClientLaunchMonitor;)V", "getProcess", "()Lcom/android/tools/idea/appinspection/inspector/api/process/ProcessDescriptor;", "getProject", "()Lcom/intellij/openapi/project/Project;", "value", "Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient$State;", "state", "getState", "()Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient$State;", "setState", "(Lcom/android/tools/idea/layoutinspector/pipeline/InspectorClient$State;)V", "stateCallbacks", "getStats", "()Lcom/android/tools/idea/layoutinspector/metrics/statistics/SessionStatistics;", "treeEventCallbacks", "connect", "disconnect", "dispose", "doConnect", "Lcom/google/common/util/concurrent/ListenableFuture;", "", "doDisconnect", "fireError", "error", "fireState", "fireTreeEvent", "event", "registerConnectionTimeoutCallback", "callback", "registerErrorCallback", "registerStateCallback", "registerTreeEventCallback", "updateProgress", "intellij.android.layout-inspector"})
public abstract class AbstractInspectorClient
implements InspectorClient {
    @NotNull
    private final DynamicLayoutInspectorAttachToProcess.ClientType clientType;
    @NotNull
    private final Project project;
    @NotNull
    private final ProcessDescriptor process;
    private final boolean isInstantlyAutoConnected;
    @NotNull
    private final SessionStatistics stats;
    @NotNull
    private InspectorClient.State state;
    @NotNull
    private final ListenerCollection<Function1<InspectorClient.State, Unit>> stateCallbacks;
    @NotNull
    private final ListenerCollection<Function1<String, Unit>> errorCallbacks;
    @NotNull
    private final ListenerCollection<Function1<Object, Unit>> treeEventCallbacks;
    @NotNull
    private final ListenerCollection<Function1<DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit>> attachStateListeners;
    @NotNull
    private InspectorClientLaunchMonitor launchMonitor;
    @NotNull
    private final Object disconnectStateLock;

    public AbstractInspectorClient(@NotNull DynamicLayoutInspectorAttachToProcess.ClientType clientType, @NotNull Project project, @NotNull ProcessDescriptor process2, boolean isInstantlyAutoConnected, @NotNull SessionStatistics stats, @NotNull Disposable parentDisposable) {
        Intrinsics.checkNotNullParameter((Object)clientType, (String)"clientType");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)process2, (String)"process");
        Intrinsics.checkNotNullParameter((Object)stats, (String)"stats");
        Intrinsics.checkNotNullParameter((Object)parentDisposable, (String)"parentDisposable");
        this.clientType = clientType;
        this.project = project;
        this.process = process2;
        this.isInstantlyAutoConnected = isInstantlyAutoConnected;
        this.stats = stats;
        Disposer.register((Disposable)parentDisposable, (Disposable)this);
        this.state = InspectorClient.State.INITIALIZED;
        this.stateCallbacks = ListenerCollection.Companion.createWithDirectExecutor();
        this.errorCallbacks = ListenerCollection.Companion.createWithDirectExecutor();
        this.treeEventCallbacks = ListenerCollection.Companion.createWithDirectExecutor();
        this.attachStateListeners = ListenerCollection.Companion.createWithDirectExecutor();
        this.launchMonitor = new InspectorClientLaunchMonitor(this.project, this.attachStateListeners, this.stats, null, 8, null);
        this.disconnectStateLock = new Object();
    }

    @Override
    @NotNull
    public final DynamicLayoutInspectorAttachToProcess.ClientType getClientType() {
        return this.clientType;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @Override
    @NotNull
    public final ProcessDescriptor getProcess() {
        return this.process;
    }

    @Override
    public final boolean isInstantlyAutoConnected() {
        return this.isInstantlyAutoConnected;
    }

    @Override
    @NotNull
    public final SessionStatistics getStats() {
        return this.stats;
    }

    @Override
    @NotNull
    public final InspectorClient.State getState() {
        return this.state;
    }

    @VisibleForTesting
    public final void setState(@NotNull InspectorClient.State value2) {
        Intrinsics.checkNotNullParameter((Object)((Object)value2), (String)"value");
        if (this.state != value2) {
            this.state = value2;
            this.fireState(value2);
        }
    }

    @NotNull
    public final InspectorClientLaunchMonitor getLaunchMonitor() {
        return this.launchMonitor;
    }

    @TestOnly
    public final void setLaunchMonitor(@NotNull InspectorClientLaunchMonitor inspectorClientLaunchMonitor) {
        Intrinsics.checkNotNullParameter((Object)inspectorClientLaunchMonitor, (String)"<set-?>");
        this.launchMonitor = inspectorClientLaunchMonitor;
    }

    @Override
    public void dispose() {
        this.launchMonitor.stop();
    }

    @Override
    public void registerStateCallback(@NotNull Function1<? super InspectorClient.State, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.stateCallbacks.add(callback);
    }

    @Override
    public final void registerErrorCallback(@NotNull Function1<? super String, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.errorCallbacks.add(callback);
    }

    @Override
    public final void registerTreeEventCallback(@NotNull Function1<Object, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.treeEventCallbacks.add(callback);
    }

    @Override
    public final void registerConnectionTimeoutCallback(@NotNull Function1<? super DynamicLayoutInspectorErrorInfo.AttachErrorState, Unit> callback) {
        Intrinsics.checkNotNullParameter(callback, (String)"callback");
        this.attachStateListeners.add(callback);
    }

    private final void fireState(InspectorClient.State state2) {
        this.stateCallbacks.forEach(new Consumer(state2){
            final /* synthetic */ InspectorClient.State $state;
            {
                this.$state = $state;
            }

            public final void accept(@NotNull Function1<? super InspectorClient.State, Unit> callback) {
                Intrinsics.checkNotNullParameter(callback, (String)"callback");
                callback.invoke((Object)((Object)this.$state));
            }
        });
    }

    protected final void fireError(@NotNull String error) {
        Intrinsics.checkNotNullParameter((Object)error, (String)"error");
        this.errorCallbacks.forEach(new Consumer(error){
            final /* synthetic */ String $error;
            {
                this.$error = $error;
            }

            public final void accept(@NotNull Function1<? super String, Unit> callback) {
                Intrinsics.checkNotNullParameter(callback, (String)"callback");
                callback.invoke((Object)this.$error);
            }
        });
    }

    protected final void fireTreeEvent(@NotNull Object event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        this.treeEventCallbacks.forEach(new Consumer(event){
            final /* synthetic */ Object $event;
            {
                this.$event = $event;
            }

            public final void accept(@NotNull Function1<Object, Unit> callback) {
                Intrinsics.checkNotNullParameter(callback, (String)"callback");
                callback.invoke(this.$event);
            }
        });
    }

    @Override
    public final void connect(@NotNull Project project) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.launchMonitor.start(this);
        boolean bl2 = bl = this.state == InspectorClient.State.INITIALIZED;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        this.setState(InspectorClient.State.CONNECTING);
        AndroidDebugBridge androidDebugBridge = (AndroidDebugBridge)AdbUtils.INSTANCE.getAdbFuture(project).get();
        if (androidDebugBridge == null) {
            return;
        }
        AndroidDebugBridge adb = androidDebugBridge;
        if (!Intrinsics.areEqual((Object)AdbUtilsKt.executeShellCommand$default(adb, this.process.getDevice(), "echo ok", 0L, 4, null), (Object)"ok")) {
            this.setState(InspectorClient.State.DISCONNECTED);
            return;
        }
        this.launchMonitor.updateProgress(DynamicLayoutInspectorErrorInfo.AttachErrorState.ADB_PING);
        ListenableFuture listenableFuture = this.doConnect();
        Executor executor2 = MoreExecutors.directExecutor();
        Intrinsics.checkNotNullExpressionValue((Object)executor2, (String)"directExecutor()");
        FutureUtils.addCallback((ListenableFuture)listenableFuture, (Executor)executor2, (FutureCallback)new FutureCallback(this){
            final /* synthetic */ AbstractInspectorClient this$0;
            {
                this.this$0 = $receiver;
            }

            public void onSuccess(@Nullable Void value2) {
                this.this$0.setState(InspectorClient.State.CONNECTED);
            }

            public void onFailure(@NotNull Throwable t) {
                Intrinsics.checkNotNullParameter((Object)t, (String)"t");
                this.this$0.getLaunchMonitor().onFailure(t);
                this.this$0.disconnect();
                Logger.getInstance(AbstractInspectorClient.class).warn("Connection failure with 'use.dev.jar=" + StudioFlags.APP_INSPECTION_USE_DEV_JAR.get() + "' 'use.snapshot.jar=" + StudioFlags.APP_INSPECTION_USE_SNAPSHOT_JAR.get() + "' cause:", t);
            }
        });
    }

    @Override
    public void updateProgress(@NotNull DynamicLayoutInspectorErrorInfo.AttachErrorState state2) {
        Intrinsics.checkNotNullParameter((Object)state2, (String)"state");
        this.launchMonitor.updateProgress(state2);
    }

    @NotNull
    protected abstract ListenableFuture doConnect();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void disconnect() {
        Object object = this.disconnectStateLock;
        synchronized (object) {
            block6: {
                block5: {
                    boolean bl = false;
                    if (this.state == InspectorClient.State.DISCONNECTED) break block5;
                    if (this.state != InspectorClient.State.DISCONNECTING) break block6;
                }
                return;
            }
            this.setState(InspectorClient.State.DISCONNECTING);
            Unit unit = Unit.INSTANCE;
        }
        this.doDisconnect().addListener(new Runnable(this){
            final /* synthetic */ AbstractInspectorClient this$0;
            {
                this.this$0 = $receiver;
            }

            public final void run() {
                this.this$0.setState(InspectorClient.State.DISCONNECTED);
                AbstractInspectorClient.access$getTreeEventCallbacks$p(this.this$0).clear();
                AbstractInspectorClient.access$getStateCallbacks$p(this.this$0).clear();
                AbstractInspectorClient.access$getErrorCallbacks$p(this.this$0).clear();
            }
        }, MoreExecutors.directExecutor());
    }

    @NotNull
    protected abstract ListenableFuture doDisconnect();

    public static final /* synthetic */ ListenerCollection access$getTreeEventCallbacks$p(AbstractInspectorClient $this) {
        return $this.treeEventCallbacks;
    }

    public static final /* synthetic */ ListenerCollection access$getStateCallbacks$p(AbstractInspectorClient $this) {
        return $this.stateCallbacks;
    }

    public static final /* synthetic */ ListenerCollection access$getErrorCallbacks$p(AbstractInspectorClient $this) {
        return $this.errorCallbacks;
    }
}

